<style>


#image_upload_box {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: #ccc;
    z-index: 9500;
    padding: 70px 20px 20px 20px;
}

#image_upload_box_2 {
    position: relative;
    width: 100%;
    height: 100%;
}

.image_upload_box_dragdrop {
    border: 10px dashed #555;
}

#input_image_upload {
    display: none;
}

#input_image_upload_label {
    position: absolute;
    top: 0;
    bottom: 0;
    left: 0;
    right: 0;
    margin: auto;
    width: 300px;
    height: 90px;
    text-align: center;
    color: #fff;
    padding: 15px;
    background-color: rgba(0,0,0,0.5);
    cursor: pointer;
}

#input_image_upload_label:HOVER {
    background-color: #2b2b2b;
}

#imageeditor_meta_box {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0,0,0,0.95);
    z-index: 9000;
    padding-top: 50px;
}

#imagebox {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: #111;
    z-index: 5000;
    padding: 10px;
    display: none;
}

#imagebox_error {
    position: absolute;
    top: -70px;
    left: 0;
    width: 100%;
    text-align: center;
    opacity: 0;
}

.show_image_error {
    top: 20px !important;
    opacity: 1 !important;
}

#imagebox_error span {
    background-color: #ff0000;
    padding: 5px 10px;
}

#imageeditor_box {
    padding: 10px;
    border: 2px solid rgba(255,255,255,0.2);
    max-height: -webkit-calc(100% - 150px);
    max-height: -moz-calc(100% - 150px);
    max-height: calc(100% - 150px);
}

#imageeditor_box img {
    width: 100%;
    height: auto;
}

#cropper_control {
    margin: 10px 0;
}

#cropper_control li {
    position: relative;
    width: 40px;
    height: 40px;
    border: 2px solid #fff;
    opacity: 0.3;
    margin-bottom: 10px;
}

#cropper_control li:HOVER {
    opacity: 1;
}

#cropper_photo_filter {
    height: 0px;
    overflow: hidden;
    margin-top: 10px;
}

#cropper_photo_filter li svg,
#cropper_control li svg {
    position: absolute;
    top: 8px;
    left: 8px;
    width: 20px;
    height: 20px;
}

#cropper_photo_filter li {
    position: relative;
    width: 40px;
    height: 40px;
    border: 2px solid #fff;
    display: inline-block;
    background-position: center center;
    background-size: cover;
    opacity: .3;
    margin-bottom: 2px;
}

#cropper_photo_filter li:HOVER {
    opacity: 1 !important;
}

#cropper_photo_filter li:FIRST-CHILD {
    background-image: none !important;
}

#imagetagging {
    padding: 10px;
}

#image_rechte_list,
#image_tag_list {
    width: 100%;
    -webkit-column-count: 2;
    -moz-column-count: 2;
    column-count: 2;
}

#imagebox hr {
    border: 0;
    width: 100%;
    height: 4px;
    background-color: #fff;
    margin: 20px 0;
}

#button_imagebox_close,
#button_register_close {
    position: absolute;
    right: 0;
    top: 0;
}

#imageeditor{
    height: 100%;
    padding: 10px;
}

#upload_img,
#save_img {
    position: fixed;
    bottom: 20px;
    right: 20px;
    margin: auto;
    height: 50px;
    padding: 15px 20px 10px 55px;
    background-color: #2b2b2b;
    border: 0;
    color: #fff;
    overflow: hidden;
    cursor: pointer;
    z-index: 9999;
    font-size: inherit;
    font-family: inherit;
}

#upload_img svg {
    position: absolute;
    left: 10px;
    top: 10px;
    width: 30px;
    height: 30px;
}

#save_img {
    display: none;
}

#cropper_image_edit {
    width: 100%;
    height: auto;
    display: none;
}

#img_upload_info_box {
    padding-right: 20px;
}

#img_upload_info_box label {
    display: block;
    margin-bottom: 5px;
    color: #555;
    margin-top: 10px;
}

#img_upload_info_box input {
    opacity: .2;
    background-color: transparent;
    border: 2px solid #fff;
    padding: 10px;
    font-family: inherit;
    font-size: inherit;
    color: #fff;
    width: 100%;
    margin-bottom: 10px;
}

#img_upload_info_box input:FOCUS {
    opacity: 1;
}

#image_please_wait {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: #ccc;
    z-index: 9999;
    display: none;
}

.spinner {
    position: absolute;
    top: 0;
    bottom: 0;
    left: 0;
    right: 0;
    margin: auto;
    width: 300px;
    height: 100px;
    text-align: center;
    font-size: 10px;
}

.spinner > div {
    background-color: #2b2b2b;
    height: 100%;
    width: 20px;
    display: inline-block;
    -webkit-animation: sk-stretchdelay 1.2s infinite ease-in-out;
    animation: sk-stretchdelay 1.2s infinite ease-in-out;
}

.spinner .rect2 {
    -webkit-animation-delay: -1.1s;
    animation-delay: -1.1s;
}

.spinner .rect3 {
    -webkit-animation-delay: -1.0s;
    animation-delay: -1.0s;
}

.spinner .rect4 {
    -webkit-animation-delay: -0.9s;
    animation-delay: -0.9s;
}

.spinner .rect5 {
    -webkit-animation-delay: -0.8s;
    animation-delay: -0.8s;
}

@-webkit-keyframes sk-stretchdelay {
    0%, 40%, 100% {
        -webkit-transform: scaleY(0.4);
    }
    20% {
        -webkit-transform: scaleY(1.0);
    }
}

@keyframes sk-stretchdelay {
    0%, 40%, 100% {
        transform: scaleY(0.4);
        -webkit-transform: scaleY(0.4);
    }
    20% {
        transform: scaleY(1.0);
        -webkit-transform: scaleY(1.0);
    }
}
</style>

<div id="image_edit_meta_box">
    <div id="image_please_wait">
        <div class="spinner">
            <div class="rect1"></div>
            <div class="rect2"></div>
            <div class="rect3"></div>
            <div class="rect4"></div>
            <div class="rect5"></div>
        </div>
    </div>

    <div id="image_upload_box">
        <div id="image_upload_box_2" class="image_upload_box_dragdrop">
            <label for="input_image_upload" id="input_image_upload_label" class="transition">Zum Hochladen<br>Drag&amp;Drop<br>oder hier klicken</label>
            <input id="input_image_upload" type="file" class="sr-only" name="file" accept=".jpg,.jpeg,.png,.gif,.bmp,.tiff,">
        </div>
    </div>
    <?php
    require Plugin::get('PATH','imgedit').'header.php';
    ?>
    <div id="imageeditor_meta_box">
        <div id="imagebox_error" class="trans"><span></span></div>
        <div id="imageeditor" class="twothird left">
            <div id="imageeditor_box">
                <img src="" id="cropper_image">
                <img src="" id="cropper_image_edit">
            </div>
            <ul id="cropper_photo_filter" class="trans">
                <?php
                $a = 0;
                while ($a < 27) {
                    echo '
                    <li class="cropper_photo_filter photo_filter_'.$a.' trans" data-filter="'.$a.'">';
                    if ($a == 0) {
                        echo '
                        <svg viewBox="0 0 100 100">
                            <use xlink:href="#icn_close" />
                        </svg>';
                    }
                    echo '</li>';
                    $a++;
                }
                ?>
            </ul>
            <div id="delete_picture">Bild löschen</div>
        </div>
        <div class="onethird right">
            <ul id="cropper_control" class="onethird left">
                <li class="trans" id="btn_cropper_fit">
                    <svg viewBox="0 0 100 100">
                        <use xlink:href="#icn_fittobox" />
                    </svg>
                </li>
                <li class="trans" id="btn_cropper_zoomin">
                    <svg viewBox="0 0 100 100">
                        <use xlink:href="#icn_zoomin" />
                    </svg>
                </li>
                <li class="trans" id="btn_cropper_zoomout">
                    <svg viewBox="0 0 100 100">
                        <use xlink:href="#icn_zoomout" />
                    </svg>
                </li>
                <li class="trans" id="btn_cropper_flip1">
                    <svg viewBox="0 0 100 100">
                        <use xlink:href="#icn_flip1" />
                    </svg>
                </li>
                <li class="trans" id="btn_cropper_flip2">
                    <svg viewBox="0 0 100 100">
                        <use xlink:href="#icn_flip2" />
                    </svg>
                </li>
                <li class="trans" id="btn_cropper_rotatecw">
                    <svg viewBox="0 0 100 100">
                        <use xlink:href="#icn_rotatecw" />
                    </svg>
                </li>
                <li class="trans" id="btn_cropper_rotateccw">
                    <svg viewBox="0 0 100 100">
                        <use xlink:href="#icn_rotateccw" />
                    </svg>
                </li>
                <li class="trans" id="btn_cropper_filter">
                    <svg viewBox="0 0 100 100">
                        <use xlink:href="#icn_filter" />
                    </svg>
                </li>
            </ul>
            <div id="img_upload_info_box" class="twothird right">
                <label for="img_upload_name">Bildname</label>
                <input type="text" id="img_upload_name">
                <label for="img_upload_alt">Alt-Tag</label>
                <input type="text" id="img_upload_alt">
                <label for="img_upload_title">Title-Tag</label>
                <input type="text" id="img_upload_title">
                <label for="img_upload_tags">Tags &amp; Schlagworte (mit Komma getrennt)</label>
                <input type="text" id="img_upload_tags">
            </div>
        </div>
        <label class="btn btn-primary btn-upload" for="inputImage" title="Upload image file">
            <span class="docs-tooltip" data-toggle="tooltip" data-animation="false" title="Import image with Blob URLs">
                <span class="fa fa-upload"></span>
            </span>
        </label>
        <button id="upload_img">
            <svg viewBox="0 0 100 100">
                <use xlink:href="#icn_save" />
            </svg>
            Bild speichern
        </button>
        <button id="save_img">
            <div class="button"></div>
            Änderungen speichern
        </button>
    </div>
</div>
<script type="text/javascript">
    /////CROPPER
    $(document).ready(function() {
        var $image = $('#cropper_image');
        var uploadedImageURL;
        var options = {
            viewMode: 1,
            dragMode: 'move',
            guides: false,
            highlight: false,
            autoCropArea: 0.95,
            cropend: function (e) {
                var img_pw = $('#cropper_image').cropper('getCroppedCanvas',{width: 55, height: 55}).toDataURL('image/jpeg');
                $(".cropper_photo_filter").css("background-image", 'url('+img_pw+')');
            },
            ready: function (e) {
                var img_pw = $('#cropper_image').cropper('getCroppedCanvas',{width: 55, height: 55}).toDataURL('image/jpeg');
                $(".cropper_photo_filter").css("background-image", 'url('+img_pw+')');
            }
    };

    $('#cropper_image').cropper(options);

    /////CROPPER IMAGEIMPORT
    var $inputImage = $('#input_image_upload');

    if (URL) {
        $inputImage.change(function () {
            var filename = $(this).val().split('\\').pop();
            $('#img_upload_name').val(filename);
            var files = this.files;
            var file;

            if (!$image.data('cropper')) {
                return;
            }

            if (files && files.length) {
                file = files[0];
                if (/^image\/\w+$/.test(file.type)) {
                    if (uploadedImageURL) {
                        URL.revokeObjectURL(uploadedImageURL);
                    }
                    uploadedImageURL = URL.createObjectURL(file);
                    $image.cropper('destroy').attr('src', uploadedImageURL).cropper(options);
                    $inputImage.val('');
                } else {
                    window.alert('Please choose an image file.');
                }
            }
        });
    } else {
        $inputImage.prop('disabled', true).parent().addClass('disabled');
    }
    /////CROPPER UPLOAD
    $ ('#upload_img').click(function() {
    //    if (!$("input[name='photo_tag']").is(':checked')){
    //
    //        $('#imagebox_error span').text('');
    //        $('#imagebox_error').addClass('show_image_error');
    //        setTimeout(function() {
    //            $('#imagebox_error').removeClass('show_image_error');
    //        }, 5000);
    //
    //        $('#imagebox').addClass('shake');
    //        setTimeout(function() {
    //            $('#imagebox').removeClass('shake');
    //        }, 1000);
    //    }
    //    else{
            //ajax_img(prepare_upload());
        $.when(get_upload_data()).then(function(data) {
            upload_img(prepare_upload(data));
        });
      //  }
    });

    /////CROPPER FILTER
    $('.cropper_photo_filter').click(function() {
        var filter = $(this).data('filter');
        $('body').data('cropper_filter',filter);
        $(".cropper_photo_filter").css('opacity',.3);
        $(this).css('opacity',1);

        $(".cropper-view-box").removeClass (function (index, className) {
            return (className.match (/\bphoto_filter_\S+/g) || []).join(' ');
        });
        $(".cropper-view-box").addClass('photo_filter_'+filter);
    });

    /////CROPPER CHANGE
    $('#btn_cropper_flip1').click(function() {
        if (!$(this).hasClass('clicked')) {
            $('#cropper_image').cropper('scale', -1, 1);
            $(this).find('svg').css('transform', 'scaleX(-1)');
        } else {
            $('#cropper_image').cropper('scale', 1, 1);
            $(this).find('svg').css('transform', 'scaleX(1)');
        }
        $(this).toggleClass('clicked');
    });

    $('#btn_cropper_flip2').click(function() {
        if (!$(this).hasClass('clicked')) {
            $('#cropper_image').cropper('scale', 1, -1);
            $(this).find('svg').css('transform', 'scaleY(-1)');
        } else {
            $('#cropper_image').cropper('scale', 1, 1);
            $(this).find('svg').css('transform', 'scaleY(1)');
        }
        $(this).toggleClass('clicked');
    });

    $('#btn_cropper_zoomin').click(function() {
        $('#cropper_image').cropper('zoom', 0.1);
    });

    $('#btn_cropper_zoomout').click(function() {
        $('#cropper_image').cropper('zoom', -0.1);
    });

    $('#btn_cropper_rotatecw').click(function() {
        $('#cropper_image').cropper('rotate', 45);
    });

    $('#btn_cropper_rotateccw').click(function() {
        $('#cropper_image').cropper('rotate', -45);
    });

    $('#btn_cropper_fit').click(function() {
//        var canvasData = $('#cropper_image').cropper('getCanvasData');
//
//        // $('#cropper_image').cropper('zoomTo', 1);
//        $('#cropper_image').cropper('autoCropArea', 1);
//        $('#cropper_image').cropper('setData', {x:0,y:0,width:canvasData.width, height: canvasData.height});
    });

    $('#btn_cropper_filter').click(function() {
        if ($(this).hasClass('open')) {
            $('#cropper_photo_filter').css('height',0);
        } else {
            var filter_height = $('#cropper_photo_filter')[0].scrollHeight;
            $('#cropper_photo_filter').css('height',filter_height);
        }
        $(this).toggleClass('open');
    });

    $('#delete_picture').click(function() {
        var id =$(this).data('id');
        ajax_img_delete(id);
    });

    $('input[type=radio]').change(function() {
        if ($('body').data('img') == 'edit') {
            $('#save_img').fadeIn();
        }
    });

    $('#save_img').click(function() {
        var update = {
            'picid' :       $('#save_img').data('id'),
            'tagid' :       getcheckvalue('photo_tag'),
            'rightid' :     getcheckvalue('photo_recht')
        }
        ajax_img_change(update);
    });
});

$('#input_image_upload').change(function() {
   $('#image_upload_box').fadeOut();
});

prepare_upload = function(data) {
    var crop_data = $("#cropper_image").cropper("getData");

    if (crop_data.width>crop_data.height) {
        var img_small = $("#cropper_image").cropper("getCroppedCanvas",{width: data.IMG_UPLOAD_SMALL[0]}).toDataURL("image/jpeg");
        var img_medium = $("#cropper_image").cropper("getCroppedCanvas",{width: data.IMG_UPLOAD_MEDIUM[0]}).toDataURL("image/jpeg");
        var img_big = $("#cropper_image").cropper("getCroppedCanvas",{width: data.IMG_UPLOAD_BIG[0]}).toDataURL("image/jpeg");
    } else {
        var img_small = $("#cropper_image").cropper("getCroppedCanvas",{width: data.IMG_UPLOAD_SMALL[1]}).toDataURL("image/jpeg");
        var img_medium = $("#cropper_image").cropper("getCroppedCanvas",{width: data.IMG_UPLOAD_MEDIUM[1]}).toDataURL("image/jpeg");
        var img_big = $("#cropper_image").cropper("getCroppedCanvas",{width: data.IMG_UPLOAD_BIG[1]}).toDataURL("image/jpeg");
    }

    var img_original = '';
    if (data.KEEP_ORIGINAL_IMG == true) {
        img_original = $("#cropper_image").cropper("getCroppedCanvas",{width: crop_data.width}).toDataURL("image/jpeg")
    }

    var upload = {
        "type"          : 'jpeg',
        "name"          : $('#img_upload_name').val(),
        "alt"           : $('#img_upload_alt').val(),
        "title"         : $('#img_upload_title').val(),
        "tags"          : $('#img_upload_tags').val(),
        "img_small"     : img_small,
        "img_medium"    : img_medium,
        "img_big"       : img_big,
        "img_original"  : img_original}
    return upload;
};

get_upload_data = function() {
    return $.getJSON("<?php echo PA::getURL(); ?>api/getthemeconfig");
}
upload_img = function(data) {
    $.ajax({
        type: "post",
        url: "<?php echo PA::getURL(); ?>plugin/p/imgedit/upload",
        data: {
            'data' : data
        },
        beforeSend: function() {
            $('#image_please_wait').fadeIn();
        },
        success: function(data) {
            console.log(data);
            console.log('upload');
            $('#image_please_wait').fadeOut();
            $.ajax({
                type: "GET",
                url: "<?php echo Plugin::getFile("imgedit", "media"); ?> ",
                success : function(text) {
                    $("#meta_box").empty().html(text);
                    $("#meta_box").fadeIn();
                }
            });
        }
    });
}


$('.cleditor_img_box_edit').click(function(e){
    e.preventDefault();
});



</script>
