<?php
$sync_url = Config::get('URL').'sync/';

$admin_js_scripts = '
$(document).ready(function() {
    $("#admin_editor").cleditor({
        height: 250, // height not including margins, borders or padding
        controls: // controls to add to the toolbar
            "bold italic underline strikethrough subscript superscript | " +
            "removeformat | bullets numbering | outdent " +
            "indent | alignleft center alignright justify | undo redo | " +
            "rule image link unlink | table | source",
                        styles: // styles in the style popup
            [["Absatz", "<p>"], ["Überschrift 1", "<h1>"], ["Überschrift 2", "<h2>"],
            ["Überschrift 3", "<h3>"], ["Überschrift 4","<h4>"],  ["Zitat","<blockquote>"]],
        useCSS: false, // use CSS to style HTML when possible (not supported in ie)
        docCSSFile:
            "'.Theme::get('URL').'css/style.css",
        bodyStyle: // style to assign to document body contained within the editor
            "cursor:text; background-color: transparent"
    });

    //DOC_READY_END
});

var elems = document.getElementsByClassName("delete_button");
var confirmIt = function (e) {
    if (!confirm("'.Text::get('CONFIRM_DELETE').'")) e.preventDefault();
};
for (var i = 0, l = elems.length; i < l; i++) {
    elems[i].addEventListener("click", confirmIt, false);
}

var timeout = 5000;
(function poll() {
    setTimeout(function() {
        $.ajax({ url: "'.$sync_url.'", success: function(data) {
            if (data.backoff >= 20 && timeout >= 60000) {
                timeout = timeout*2;
                if (timeout > 600000) {
                    timeout = 600000;
                }
            } else {
                timeout = data.backoff * 1000;
            }
            poll();
        }, dataType: "json"}).fail(function() {
            timeout = 180000;
        });
    }, timeout);
})();

$(".admin_connection_head").click(function(e) {
    if ($(e.target).is("a")) {
        return;
    } else {
        var $parent = $(this).parent();
        var $box_height = $parent[0].scrollHeight;
        if ($parent.height() != 100) {
            $parent.height(100);
        } else {
            $parent.height($box_height);
        }
        $(this).find(".admin_connection_goto").toggleClass("admin_connection_goto_zu");
    }
});

changeMask($("#offerCurrency").val());
showHideInputs($("#offerUnits").val());

$("#offerUnits").on("change", function() {
    console.log(this.value);
    showHideInputs(this.value);
});

$("#offerCurrency").on("change", function() {
    changeMask(this.value);
});

function showHideInputs(unit) {
    switch (unit) {
        case "1":
        case "2":
            $("#offerPrice").hide();
            $("#offerCurrency").hide();
            break;
        default:
            $("#offerPrice").show();
            $("#offerCurrency").show();
            break;
    }
}

function changeMask(currency) {
    switch (currency) {
        case "1":
            $("#offerPrice").mask("# ##0,00", {reverse: true});
            break;
        case "2":
            $("#offerPrice").mask("#,##0.00000000", {reverse: true});
            break;
        case "3":
        default:
            $("#offerPrice").mask("#,##0.00", {reverse: true});
            break;
    }
}';

?>
