<?php

/**
 * PlaceModel
 *
 */
class PlaceModel
{
    public static function getPlaceByPostalcode($postalcode)
    {
        $prefix = Config::get('DB_PREFIX');
        $database = DatabaseFactory::getFactory()->getConnection();

        $sql = "SELECT id,
                       name,
                       lat,
                       lon
                FROM ".$prefix."places
                WHERE plz = :postalcode
                LIMIT 1";
        $query = $database->prepare($sql);
        $query->bindParam(':postalcode', $postalcode, PDO::PARAM_STR);
        $query->execute();
        if ($query->rowCount() == 0)
        {
            return false;
        } else {
            $place = $query->fetch();
            return $place;
        }
    }
}
