<?php

class UpdateController extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    public function __construct()
    {
        parent::__construct();
    }

    public function postalcode()
    {
        Session::set('search_plz', Request::post('setNewPLZ',true));
        Redirect::to(Helper::getCurrentPath());
    }

    public function sorting($order)
    {
        // look for sort in url and set sort order for sorting
        $sortOrder = explode('_',$order);
        DatabaseArgs::setOrderBy($sortOrder);
        Redirect::to(Helper::getCurrentPath());
    }

    public function feature($type, $what, $id)
    {
        switch ($type) {
            case 'admin':
                Auth::checkForAdmin();
                switch ($what) {
                    case 'offer':
                        OfferModel::featureOffer('admin',$id);
                        $redirect = 'offers/view/'.$id;
                        break;
                    case 'profile':
                        UserProfileModel::featureProfile($id);
                        $redirect = 'profiles/view/'.$id;
                        break;
                    case 'other':
                        UserProfileModel::featureOtherProfile($id);
                        $redirect = 'profiles/view/'.$id;
                        break;
                    case 'profiledetail':
                        UserProfileModel::featureProfile($id);
                        $profile = UserProfileModel::getUserProfile($id);
                        $redirect = 'admin/users/edit/'.$profile->user_id;
                        break;
                    case 'otherdetail':
                        UserProfileModel::featureOtherProfile($id);
                        $profile = UserProfileModel::getUserProfile($id);
                        $redirect = 'admin/users/edit/'.$profile->user_id;
                        break;
                }
                break;
            case 'user':
                switch ($what) {
                    case 'offer':
                        OfferModel::checkOwnership($id);
                        OfferModel::featureOffer('user',$id);
                        $redirect = 'offers/view/'.$id;
                        break;
                }
                break;
        }
        Redirect::to($redirect);
    }

    public function approve($redirect, $user_id)
    {
        Auth::checkForSuperAdmin();
        switch ($redirect) {
            case 'user':
                $path = "users";
                break;
            case 'userdetail':
                $path = "users/edit/".$user_id;
                break;
            default:
                $path = "users";
                break;
        }
        UserModel::approveUser($user_id);
        Redirect::to('admin/'.$path);
    }

    public function disapprove($redirect, $user_id)
    {
        Auth::checkForSuperAdmin();
        switch ($redirect) {
            case 'user':
                $path = "users";
                break;
            case 'userdetail':
                $path = "users/edit/".$user_id;
                break;
            default:
                $path = "users";
                break;
        }
        UserModel::disapproveUser($user_id);
        Redirect::to('admin/'.$path);
    }

    public function delete($what,$id,$type = null)
    {
        switch ($what)
        {
            case 'offer':
                OfferModel::checkOwnership($id);
                $offer = OfferModel::getOffer($id);
                OfferModel::deleteOffer($id);
                Redirect::to('profiles/view/'.$offer->profile_id);
                break;
            case 'profile':
                UserProfileModel::checkOwnership($id);
                UserProfileModel::deleteProfile($id);
                Redirect::to('admin/users');
                break;
            case 'image':
                if ($type != null) {
                    $returnpath = UploadModel::deleteImage($type,$id);
                    Redirect::to($returnpath);
                }
                break;
            case 'user':
                Auth::checkForSuperAdmin();
                UserModel::deleteUser($id, true);
                Redirect::to('admin/users');
                break;
        }
    }
}
