<?php
$offer = $data['offer'];
$offer_price = Helper::convertPrice($offer->price,
                                    $offer->currency,
                                    $offer->unit,
                                    'edit');
if ($offer->title == '')
{
    $headline = Text::get('OFFER_EDIT_HEADLINE_NEW');
} else {
    $headline = Text::get('OFFER_EDIT_HEADLINE_EDIT');
}
?>
<h1 class="headline"><?php echo $headline; ?></h1>
<div id="admin_edit_sidebar" class="admin_onethird right">
    <?php PA::showImageUploader('offerimage','offer_small',$offer->id,$offer->image,Text::get('OFFER_EDIT_IMAGE_LABEL')); ?>

    <div class="edit_sidebar_box admin_edit_sidebar_text">
        <?php
        echo Text::get('OFFER_EDIT_SIDEBAR_TEXT');
        ?>
    </div>
</div>

<div id="login_box_2" class="admin_twothird left">
    <form action="<?php echo PA::getURL(); ?>offers/save_action/<?php echo $offer->id; ?>"
          name="addOffer"
          method="post">
        <label for="offerType"
               class="form_label"><span><?php echo Text::get('OFFER_EDIT_OFFER_LABEL'); ?></span></label>
        <select id="offerType"
                class="form_element"
                name="offerType">
            <option value="1"<?php
                    if($offer->type == 1) { echo ' selected'; } ?>><?php echo Text::get('OFFER_EDIT_OFFER'); ?></option>
            <option value="2"<?php
                    if($offer->type == 2) { echo ' selected'; } ?>><?php echo Text::get('OFFER_EDIT_REQUEST'); ?></option>
        </select>
        <input type="hidden" name="offerCategory1" value="1" />
        <?php
        $category_prefix = 'offerCategory2';
        echo '<label class="form_label" for="'.$category_prefix.'"><span>'.Text::get('OFFER_EDIT_CATEGORY_LABEL').'</span></label>';
        PA::showCategories('select', $category_prefix,$offer->category2);
        ?>

        <label for="offerTitle"
               class="form_label"><span><?php echo Text::get('OFFER_EDIT_OFFER_NAME_LABEL'); ?></span></label>
        <input type="text"
               name="offerTitle"
               id="offerTitle"
               class="form_element"
               placeholder="<?php echo Text::get('OFFER_EDIT_OFFER_NAME_PLACEHOLDER'); ?>"
               value="<?php echo $offer->title; ?>"
               required />
        <label for="offerDetail" class="form_label"><span><?php echo Text::get('OFFER_EDIT_OFFER_DESCRIPTION_LABEL'); ?></span></label>
        <textarea type="text"
               name="offerDetail"
               id="offerDetail"
               class="form_element"
               placeholder="<?php echo Text::get('OFFER_EDIT_OFFER_DESCRIPTION_PLACEHOLDER'); ?>"
               rows="3"><?php echo $offer->detail; ?></textarea>
        <label for="offerTags" class="form_label"><span><?php echo Text::get('OFFER_EDIT_OFFER_TAGS_LABEL'); ?></span></label>
        <input type="text"
               name="offerTags"
               id="offerTags"
               class="form_element"
               placeholder="<?php echo Text::get('OFFER_EDIT_OFFER_TAGS_PLACEHOLDER'); ?>"
               value="<?php echo $offer->tags; ?>" />
        <label for="offerPrice"
               class="form_label"><span><?php echo Text::get('OFFER_EDIT_OFFER_PRICE_LABEL'); ?></span></label>
        <div class="admin_half left">
            <div class="admin_half left">
                <input type="text"
                       name="offerPrice"
                       id="offerPrice"
                       class="form_element"
                       placeholder="<?php echo Text::get('OFFER_EDIT_OFFER_PRICE_PLACEHOLDER'); ?>"
                       value="<?php echo $offer_price['price']; ?>" />
            </div>
            <div class="admin_half right">
                <?php
                $currency_data = PA::getCurrencies();
                PA::showCurrencyDropdown($currency_data,$offer->currency,'short');
                ?>
            </div>
        </div>
            <div class="admin_half right">
            <?php
            $units_data = PA::getUnits();
            PA::showUnitsDropdown($units_data,$offer->unit,'');
            ?>
        </div>
        <div class="clear"></div>
        <label for="offerStatus"
               class="form_label"><span><?php echo Text::get('OFFER_EDIT_OFFER_STATUS_LABEL'); ?></span></label>
        <select id="offerStatus"
                class="form_element"
                name="offerStatus">
            <option value="1"<?php
                    if($offer->status == 1) { echo ' selected'; } ?>>
                <?php echo Text::get('OFFER_EDIT_OFFER_STATUS_1'); ?>
            </option>
            <option value="2"<?php
                    if($offer->status == 2) { echo ' selected'; } ?>>
                <?php echo Text::get('OFFER_EDIT_OFFER_STATUS_2'); ?>
            </option>
            <option value="3"<?php
                    if($offer->status == 3) { echo ' selected'; } ?>>
                <?php echo Text::get('OFFER_EDIT_OFFER_STATUS_3'); ?>
            </option>
        </select>
        <div class="form_label"><span><?php echo Text::get('OFFER_EDIT_OFFER_FEATURE_LABEL'); ?></span></div>
        <input type="checkbox"
               name="offerFeatured"
               id="offerFeatured"
               value="1"<?php
                    if ($offer->user_featured == 1) { echo ' checked'; } ?>>
        <label for="offerFeatured" class="form_checkbox"><?php echo Text::get('OFFER_EDIT_OFFER_FEATURE'); ?></label>

        <br><br>
        <input type="submit"
               value="<?php echo Text::get('OFFER_EDIT_SAVE'); ?>"
               class="form_submit">
    </form>
</div>
<div class="clear"></div>
<?php
PA::showFooter();
?>
