<?php

class Text
{
    private static $texts;

    public static function get($key)
    {
        // if not $key
        if (!$key) {
            return null;
        }

        // load config file (this is only done once per application lifecycle)
        if (!self::$texts)
        {
            $lang = Language::get();
            self::$texts = require('../language/'.$lang.'.texts.php');
            if (file_exists(Theme::get('PATH').'language/'.$lang.'.texts.php')) {
                $themeTexts = require(Theme::get('PATH').'language/'.$lang.'.texts.php');
                self::$texts = array_replace_recursive(self::$texts, $themeTexts);
            }
        }

        // check if array key exists
        if (!array_key_exists($key, self::$texts))
        {
            return $key;
        }

        return self::$texts[$key];
    }

}
