<?php

class Config
{
    private static $config;
    private static $db_config;

    public static function get($key)
    {
        if (!self::$config) {
            $config_file = '../application/config/internal.php';

            if (!file_exists($config_file)) {
                return false;
            }

            self::$config = require $config_file;
        }

        return self::$config[$key];
    }

    public static function getURL()
    {
        $lang = Language::get();

        if (self::get('MULTILANGUAGE') && $lang != null) {
            $url = self::$config['URL'].$lang.'/';
        } else {
            $url = self::$config['URL'];
        }

        return $url;
    }

    public static function getFromDB($key)
    {
        if (!self::$db_config) {
            $database = DatabaseFactory::getFactory()->getConnection();
            if (!$database) {
                return false;
            }
            $prefix = self::get('DB_PREFIX');
            if ($database->query("SHOW TABLES LIKE '".$prefix."settings'")->rowCount() < 1) {
                return false;
            }
            $query = $database->prepare("SELECT name,
                                                value_text,
                                                value_int
                                         FROM ".$prefix."settings");
            if ($query->execute()) {
                $configuration = array();
                foreach ($query->fetchAll() as $config) {
                    if ($config->value_int === NULL) {
                        $configuration[$config->name]   =       $config->value_text;
                    } else {
                        $configuration[$config->name]   = (int) $config->value_int;
                    }
                }
            } else {
                $configuration['MarketUsedTheme'] = Theme::getThemes()[0];
            }
            self::$db_config = $configuration;
        }

        if (in_array($key,array_keys(self::$db_config))) {
            return self::$db_config[$key];
        } else {
            return false;
        }
    }

    public static function unsetDBConfig()
    {
        self::$db_config = null;
    }
}
