<?php

/**
 * Class PA//ADMIN
 *
 */
class Admin
{

    public static function adminGetLink($type, $id = '')
    {
        switch ($type) {
            //  ADMIN NAVI
            case 'index':
                $link = PA::getHomeURL().'admin/';
                break;
            case 'settings':
                $link = PA::getHomeURL().'admin/settings';
                break;
            case 'connections':
                $link = PA::getHomeURL().'admin/connections';
                break;
            case 'users':
                $link = PA::getHomeURL().'admin/users';
                break;
            case 'offers':
                $link = PA::getHomeURL().'admin/offers';
                break;
            case 'pages':
                $link = PA::getHomeURL().'admin/pages';
                break;

            //USER ADMINISTRATION
            case 'user_edit':
                $link = PA::getHomeURL().'admin/users/edit/'.$id;
                break;
            case 'user_edit_action':
                $link = PA::getHomeURL().'admin/users/edit_action/'.$id;
                break;
            case 'profile_edit':
                $link = PA::getHomeURL().'profiles/edit/'.$id;
                break;
            case 'user_add':
                $link = PA::getHomeURL().'admin/users/add/';
                break;
            case 'user_view':
                $link = PA::getHomeURL().'profiles/view/'.$id;
                break;
            case 'user_delete_profile':
                $link = PA::getHomeURL().'update/delete/profile/'.$id;
                break;
            case 'user_change_password':
                $link = PA::getHomeURL().'profiles/changePassword/'.$id;
                break;
            case 'user_delete':
                $link = PA::getHomeURL().'update/delete/user/'.$id;
                break;
            case 'new_offer':
                $link = PA::getHomeURL().'offers/add/'.$id;
                break;
            case 'approve_user':
                $link = PA::getHomeURL().'update/approve/user/'.$id;
                break;
            case 'disapprove_user':
                $link = PA::getHomeURL().'update/disapprove/user/'.$id;
                break;
            case 'approve_user_detail':
                $link = PA::getHomeURL().'update/approve/userdetail/'.$id;
                break;
            case 'disapprove_user_detail':
                $link = PA::getHomeURL().'update/disapprove/userdetail/'.$id;
                break;
            case 'feature_profile':
                $link = PA::getHomeURL().'update/feature/admin/profile/'.$id;
                break;
            case 'other_feature_profile':
                $link = PA::getHomeURL().'update/feature/admin/other/'.$id;
                break;
            case 'feature_profile_detail':
                $link = PA::getHomeURL().'update/feature/admin/profiledetail/'.$id;
                break;
            case 'other_feature_profile_detail':
                $link = PA::getHomeURL().'update/feature/admin/otherdetail/'.$id;
                break;

            //OFFER ADMINISTARTION
            case 'offer_edit':
                $link = PA::getHomeURL().'offers/edit/'.$id;
                break;
            case 'offer_view':
                $link = PA::getHomeURL().'offers/view/'.$id;
                break;
            case 'offer_delete':
                $link = PA::getHomeURL().'update/delete/offer/'.$id;
                break;
        }
        return $link;
    }

    public static function adminGetCSS()
    {
        $path_to_css = Config::get('PATH_VIEW').'admin/style.css';
        $css_as_string = file_get_contents($path_to_css);
        // Remove comments
        $css_as_string = preg_replace('!/\*[^*]*\*+([^/][^*]*\*+)*/!', '', $css_as_string);
        // Remove space after colons
        $css_as_string = str_replace(': ', ':', $css_as_string);

        $img_path = Config::get('PATH_VIEW').'admin/';

        $css_as_string = str_replace('[adminimg]', $img_path, $css_as_string);

        // Remove whitespace
        $css_as_string = str_replace(array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '),
                                     ' ', $css_as_string);
        return '
        <style>'.$css_as_string.'</style>';
    }

    public static function adminShowEditMenu($data)
    {
        if (!PA::isAdmin()) { return false; }
        elseif (PA::isAdmin()) {
            echo '<div id="admin_edit_menu">';

            $featuredimg = 'icn_featured.png';
            $featured = false;

            $other_featuredimg = 'icn_other_featured.png';
            $other_featured = false;
            $otherFeaturable = false;

            if (PA::isProfilePage()) {
                $details = $data;
                $edit_id = $details->id;
                $edit_type = 'editUser';
                if ($details->admin_featured == 1) {
                    $featuredimg = 'icn_featured_ok.png';
                    $featured = true;
                }
                if ($details->other_featured == 1) {
                    $other_featuredimg = 'icn_other_featured_ok.png';
                    $other_featured = true;
                }
            } elseif (PA::isOfferPage()) {
                $details = $data['profile'];
                $offer = $data['offer'];
                $edit_id = $offer->id;
                $edit_type = 'editOffer';
                if ($offer->admin_featured == 1) {
                    $featuredimg = 'icn_featured_ok.png';
                    $featured = true;
                }
            } elseif (PA::isPage()) {
                $page = $data['page'];
                $edit_id = $page->id;
                $edit_type = 'editPage';
            }

            if (PA::isEditable()) {

                //FEATURE PAGE OR OFFER
                if (PA::isOfferPage()) {
                    $edit_text = Text::get('ADMIN_EDIT_MENU_EDIT_OFFER');
                    $feature_link = PA::getlink('feature_offer_admin',$edit_id);
                    if ($featured == true) {
                        $feature_text = Text::get('ADMIN_EDIT_MENU_UNFEATURE_OFFER');
                    } else {
                        $feature_text = Text::get('ADMIN_EDIT_MENU_FEATURE_OFFER');
                    }
                    $delete_text = Text::get('ADMIN_EDIT_MENU_DELETE_OFFER');
                    $delete_link = PA::getLink('delete_offer',$edit_id);
                } elseif (PA::isProfilePage()) {
                    $edit_text = Text::get('ADMIN_EDIT_MENU_EDIT_PROFILE');
                    $feature_link = PA::adminGetLink('feature_profile',$edit_id);
                    $otherFeaturable = true;
                    $other_feature_link = PA::adminGetLink('other_feature_profile',$edit_id);
                    if ($featured == true) {
                        $feature_text = Text::get('ADMIN_EDIT_MENU_UNFEATURE_PROFILE');
                    } else {
                        $feature_text = Text::get('ADMIN_EDIT_MENU_FEATURE_PROFILE');
                    }

                    if ($other_featured == true) {
                        $other_feature_text = Text::get('ADMIN_EDIT_MENU_OTHER_UNFEATURE_PROFILE');
                    } else {
                        $other_feature_text = Text::get('ADMIN_EDIT_MENU_OTHER_FEATURE_PROFILE');
                    }
                    $delete_text = Text::get('ADMIN_EDIT_MENU_DELETE_PROFILE');
                    $delete_link = PA::getLink('delete_profile',$edit_id);
                }
                $edit_link = PA::getEditLink($edit_type,$edit_id);

                echo '
                <ul class="menu">
                    <li>
                        <a href="'.$feature_link.'">
                            <img src="'.PA::getThemeURL().'img/'.$featuredimg.'" class="menuhead_img" alt="'.$feature_text.'">
                        </a>
                        <ul>
                            <li>
                                <a href="'.$feature_link.'">
                                    '.$feature_text.'
                                </a>
                            </li>
                        </ul>
                    </li>
                </ul>';

                if ($otherFeaturable == true) {
                echo '
                <ul class="menu">
                    <li>
                        <a href="'.$other_feature_link.'">
                            <img src="'.PA::getThemeURL().'img/'.$other_featuredimg.'" class="menuhead_img" alt="'.$other_feature_text.'">
                        </a>
                        <ul>
                            <li>
                                <a href="'.$other_feature_link.'">
                                    '.$other_feature_text.'
                                </a>
                            </li>
                        </ul>
                    </li>
                </ul>';
                }

                //EDIT PAGE
                echo '
                <ul class="menu">
                    <li>
                        <a href="'.$edit_link.'">
                            <img src="'.PA::getThemeURL().'img/icn_edit.png" class="menuhead_img" alt="'.$edit_text.'">
                        </a>
                        <ul>
                            <li><a href="'.$edit_link.'">'.$edit_text.'</a></li>
                        </ul>
                    </li>
                </ul>';
            }

            //NEW OFFER FOR USER
            if (PA::isProfilePage()) {
                $new_offer_link = PA::adminGetLink('new_offer',$edit_id);
                $new_offer_text = Text::get('ADMIN_EDIT_MENU_NEW_OFFER');
                echo '
                    <ul class="menu">
                        <li>
                            <a href="'.$new_offer_link.'">
                                <img src="'.PA::getThemeURL().'img/icn_new_offer.png" class="menuhead_img" alt="'.$new_offer_text.'">
                            </a>
                            <ul>
                                <li><a href="'.$new_offer_link.'">'.$new_offer_text.'</a></li>
                            </ul>
                        </li>
                    </ul>';
            }

            //DELETE PROFILE/OFFER
            echo '
                <ul class="menu">
                    <li>
                        <a href="'.$delete_link.'" class="delete_button">
                            <img src="'.PA::getThemeURL().'img/icn_delete.png" class="menuhead_img" alt="'.$delete_text.'">
                        </a>
                        <ul>
                            <li><a href="'.$delete_link.'" class="delete_button">'.$delete_text.'</a></li>
                        </ul>
                    </li>
                </ul>
                <div class="clear"></div>
            </div>';
        }
    }

    public static function adminShowUserList($users)
    {
        echo '
        <table id="admin_users_table">
            <tr>
                <th class="admin_users_table_td1">'.AdminText::get('USERS_NAME').'</th>
                <th class="admin_users_table_td2">'.AdminText::get('USERS_REGISTER_DATE').'</th>
                <th class="admin_users_table_td3">'.AdminText::get('USERS_LASTLOGIN_DATE').'</th>
                <th class="admin_users_table_td4">
                    <div class="admin_table_button admin_button_offers">
                        <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAntJREFUeNrsmFuITVEYx/eZM2hKSpKRGS/EeGByotOgkSjl8kaJB08e3J6nqZmmNA8eXBKaRErut0jxKjSlhIk0kTeTW1JKDHPG8Vv6Tn3tyNqX9rSn76tfZ31773X57/Wt9a2zC9VqNRgPVheMEzMhJsSEmBATYkJMiAkxIX9sLnTByjQbLWR8+i3ALdgAr2A5fMrjjOwQEc7mwfw8zsh0GIRp4g/AMvietxnpVCKc9aQlIssZaYMHUBT/MmzJ22KfAA+hJL5b3K3wNm/b7zYlwtmhtEVEnZEzMNnz2dtwGmbBY5gh159DWdbGTljzn3a+wnavHp0QT4ar/rZV6nSoa7+gXa63wohHO8O+44sSWoUIz86U36fuXUn5ItyXWT0L9Wn2GSW0VsEi6FUhdhxuhtaa6/wdPBN/KTTBHfgBU2AFVHRgSJbvEX8E9kE/3E07tGrsVlPfH6P+v7iu2j0QtX6cDhvgpep0c+j+YngNm8Q/Ao9gEjTDIOwK1SlDRdr7DI1RxxVn+3U7zlHld8NE5bfAHLXlupBZIuHYLPfLoTa7VbI8Bu+zyiOX4KOUF8J6da+i4jyQdVFbB6NS/qmeb1f13Us6mWVCdNn5sPL3Jshle1T5PLzJOrP3wZDa0dZKuaiOJs4a/tJfLRQXwEYpf4P9sUeTcKfpDO1gdTAbrkKbPOMW9gkowlS4AOvk3jlVvy/JWJIKaYIvajCrI9RtUdl9FEpJxlIfJLMhCbEO8Q/CPc+6JZXdb8CTsT7GuwPhi9CfpihWkew/MNbH+A9yjopr15KKCDwPbj52SuWNqHYlj5+D7EujCTEhJsSEmBATYkJMSA7ttwADANRGjTnzjPlwAAAAAElFTkSuQmCC">
                    </div>
                </th><th class="admin_users_table_td5">
                    <div class="admin_table_button admin_button_offers">
                        <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAttJREFUeNrsmc9LFVEUx+eZZb+o8EU/sCxDQdHoWVCEuXChRQuDiCKC2rlwEVjoH+BagqhVLSKIoLIkCNoUKRT0EPpNJeLCoKQSgrQIE6fvgRM8hnNn5s7c133EPfBZvPPm3nnfO+eec+68jO/73v9gGSfECXFCnBAnxAlJYWWG51sMToPHYBrMA1qpn2AcXAINRVFCT8QQnWDKj7YFcAusMnhvY0LOgHlfzybAOlNCTOyRTnAblCcY+xS0gAXbm30ZGAObU8xxAly3LeQsGBD8c2CYRdKGrwZtoFK49hnYZVtIHuwO5g9wFUwG/MtBF1gd8JPQFSzeSvrNgjrB/04Q4XEKzgt+2ltNNuvIJrBGIURl0wr/RptC1lNoCv4vIWOWKvw/0gopTzGWbv5W8M+EjGlQzDNpU8gLcFPxVCSrVwgZi3iKRQ8tWsmPMa/dBg5LHRK4ayK00jaN+RjX1ILj3FAGbRQMlUL3+wZ8CPmeCuExRQh/Bld4DutCKDQGwXfhu5XgqEIEJYTL3Jr4pSDEYxG0sl8D/nau2EH7BS6Ac4oFsH5CpD3QCvZw1e8RFopu1gfOg9+ldrAqC3xeAnoVZ5CLEWMTk6aOZLhrbeNa8ID7qTlu7z2hOewvaCDbuVd7CJ7bKogV4EhB07gTNPIPeil0uH8LKN3vAGjmOcgO8TxDacItyR6h1T4Z0eh1gL0B33twI2QMpfFrSdt5XSGLwCmuD2GWE1r8T+BJxLjxpClZV8hB4SBl2kbAo2LWkZp/IMLjFF5VrCdCgrvBWo256YXEDq4vE+C1RshM8cs837SQZs4ucS3Hr4kKW3wSckdjjkGdPixOaGX43ZNOSt8vnFO2gy0a8+wzvUeqNUMqG3Kk1Yn9DfxewJiQRs19NxsS2zOaczWZFLI1wcnxleD/xkVRx2pMtijZBCn0HvdduYKsdT9BCxI7pN0/Vk6IE+KEOCFOiBMC+yPAAD+0qEzOrxdPAAAAAElFTkSuQmCC">
                    </div>
                </th>
                <th class="admin_users_table_td6">
                <div class="admin_table_button admin_button_edit_user">
                    <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAhFJREFUeNrsmc1Kw0AQgJMaq60o/qEgIoJPINZ38KSICvYRlOqtJx/C2safgz8XL971DbyJF0+e9KZVBKXgqa3rDIwYYpJms0l3LTvwHbJsm/m6u9nM1mSMGZ0QphbRIlpEi2gRLaJFDCMl+f5ZYBcoAl1C34QjIokMUGK/sQ1YUb9PlsQQUGZ/oxBVRpbIOvOPLSD1X0TGgVOg6SNTUFmkH9gEpul6ADhuMTLKiaSBCiV45ZAZBE4CZIoqiVgeC/vSITMcIFNSRQQ3XNsnSafMiMc0Q/msKiIVFhwoM0V9R4Ezardpn1FijdgsXOCamXTI5GmfUeKphSPRYOEDR2ZG5J5JjUSd8ceGKiImjUQUiTLtK9JFuiNMJ4wvkugRzSEOCUxij5LiCZTepx/BkC3ifhUPG3VaS2ZcU1vkw30CEgdxP2RE6onDCBINWkuGKiI54DOCiJ3UBizyqF0BnjgkKkm+DvF0xqptlqq7n7a1kDKxLmxREXwd3wE+gEWXzHOLzc5iCZcLPJ17gQtK7gVYcslUfSTS7SjeeDpjbfDgSLLqIfPqksiwNpXSPJ0nPA4LUGbZ0WcVqAFHtM8YKoos+KwB9zSbj1JPiMJzZDrn0z4GnAN5ur4B3tt99mpx9M15tD1S4nfAPR6K4yms6qfx18AbJX5LydeABtGUJaH/H9EiWkSLaBEtokU6TeRbgAEApc+LLBr1fCgAAAAASUVORK5CYII=">
                </div>
                </th>
                <th class="admin_users_table_td7">
                    <div class="admin_table_button admin_button_delete">
                        <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAbZJREFUeNrsmE1KAzEYhiftWBUrqCAURRAvIXgDEcWtC7cqLt14AcG9Sw8gLl0KnsGtK6GrgpTWH9BarTa+wSximGFoTMaxvIGH0sxP5pl8mSSfkFJGw1BK0ZAUilCEIhShCEWKKLIB3kDbogf2QzQoHJYoY6ACki7sg1lwDpZTrr8Fm6AOyknPBN5BN7TIMdgFnZTjM2A84x6qt1opxybAKTgc5KFih16cNnAto2A+o40otMirDqGXQOOrOmhYuYbWlG4s1PpfjZFn8BhapJAldrxuBJyBGvjwOBWokNoC93mJqEZXwJznF9vVH4LcJsRQ8Shd7+1zZv8EV6Bh1d+Aa6tOhc6ly9cp/RVgsDtQAQ35s1zoY6tGXQ8sgipoGvU7+twT6x4dUHN5Jp890ta/LWsGf9KfU3PeaSac+y9WvyLjP5fxFKEIRShCEYpQ5A9EZOhtgE+ROGGzVjIoWzvM32zsvO0Qk8oa2APrRp3Kbx3pRMKCUX8AJsG2t1WpY/JBZRrrAba6KtW0BO7yCi0RcDyJPENLdeND9J3f8plFUWnYfp6hxXmEIhShCEUoQpEili8BBgAwzfiS5i1EyAAAAABJRU5ErkJggg==">
                    </div>
                </th>
            </tr>';

        foreach($users as $user) {

            // NAME
            if (!$user->company_name) {
                $user_name = '['.$user->user_name.']';
            } else {
                $user_name = $user->company_name;
            }

            // DATES
            if (!$user->user_last_login_timestamp) {
                $user_login_date = '[x]';
            } else {
                $user_login_date = date('d.m.Y',$user->user_last_login_timestamp);
            }
            $user_register_date = date('d.m.Y',$user->user_creation_timestamp);

            // Status
            if ($user->user_active == 0) {
                $user_status = '<span class="status_red">&bull;</span>';
            } else {
                $user_status = '<span class="status_green">&bull;</span>';
            }

            echo '
            <tr>
                <td class="admin_users_table_td1">'.$user_status.' <a href="'.PA::adminGetLink('user_view',$user->profile_id).'">'.$user_name.'</a><br>&nbsp; &nbsp;<a href="mailto: '.$user->user_email.'">'.$user->user_email.'</a></td>
                <td class="admin_users_table_td2">'.$user_register_date.'</td>
                <td class="admin_users_table_td3">'.$user_login_date.'</td>
                <td class="admin_users_table_td4" title="'.AdminText::get('USERS_BUTTON_OFFERS').'">'.$user->offers_number.'/'.$user->request_number.'</div></td>
                <td class="admin_users_table_td5">';
                if ($user->user_approved == 1) {
                    echo '
                    <a href="'.PA::adminGetLink('disapprove_user',$user->id).'" title="'.AdminText::get('USERS_BUTTON_USER_DISAPPROVE').'">
                        <div class="admin_table_button admin_button_new_offer">
                            <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAfhJREFUeNrsmc1qAjEUhbWL0mU33fYJ+hwuRGQQEbEiIl3OSqaDzEKwIiJSitiHKPSJuu0TdFf6m96hkQ7tOHOS3KiVHDgrkzDfmJzcZIpCiMI+6KCwJ3IgDsSBOBAH8m9AAnLJwrMsyb5273hnV3AovvVMLiv2zfJC/MjXGUMHYqUXcoUB4lr8lW8LJBTpimGqBhBzsV4+N0goshXDeBoQU5EvGAZZ7Cc5vx+S78l1haU5IQ9y2rySH7kX+wx4e2/kBjDWCBzLs7XYJ+ADtDLGGIJj1GymVuwx+CDtlL4R2LduO35VpsYHuaMQGCpTkw0EnSIxTI8cgBBNk/3IZCOLQBikTct0YzXdlQfCTL+n4NZA0Pm/DqLLVa9xFX2BBkSPsehkA4ndV4C44IRASxRUT+RP8Ax0zH6aYXojHTChkgp3bWq1NSBWinYFpCk3MxMNtw3SACGQf2u0LZA6CNGXCYXATDYN4oEQQaJPD4SZbgqkKo+2OonUBWHmtkEqIMSAIaZvbIGUQQgkTlvg1Fxwg5TkhRxnjKKxveQsUc7IRzltrqRR3ZHPye857R64S5SsUn1sEJtZMe6LDV2ZGme/dC0Fxrcdv0mYGWPR5yXCROsSu6jxnT2Ut4+XzIV4lXxKvtXprAPivlg5EAfiQByIA9k7kC8BBgCKs4YFhJC+fgAAAABJRU5ErkJggg==">
                        </div>
                    </a>';
                } else {
                    echo '
                    <a href="'.PA::adminGetLink('approve_user',$user->id).'" title="'.AdminText::get('USERS_BUTTON_USER_APPROVE').'">
                        <div class="admin_table_button admin_button_new_offer">
                            <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAbhJREFUeNrsmbFKA0EQhpMjhCBi4VNYXiEWFiJiESGIpAhW2qSwEBEMCOlstLISC7EIFiJqkUKs1MLCh7FKREWD6PmvKGxxXGZn9/ZimIGvSXY2+2U3ezMkH0VRbhgiyA1JiIiIiIiIiIiIiIiIpBMjYPy/i5TAFbjjygQDItEGcyDkymQtUgSXoKy9xpLJUqQAzkAl5j1jmSBDiVNQTRgT/u7WwIqoz2yBWp9xXbBNnlW1uh4JQCvqH09gymRu3xJHBIlnMG06P2dBk2CCkXdAlJjhfFEciQ54BKFB3j5B4hXMcnecI/EXHeIR2CNIvIF5m6PLldCPQtICdogSZdvfoI2EvpDFmLwmQaIHKi4uE8qgG8KCPsCyltMgSiy5uhUpg8bAA2Fhn6AONojiVZfXO3XgKLiP3ISSqLl+TlFLlBewAG4ty5MvsAounBc+huYlcM3cCXX0VtKqHDhJRdBmSNTTLIG4iQVwbiCylnYtZ5OsZE4IEus+ilIXFe1xgsSmr+raVXl+GCPR8NnruJxMr3Cbnhu2n97ZVWyBd9ADu77757z8qysiIiIiIiIiIiIiIpJafAswAObe2SRr3ERmAAAAAElFTkSuQmCC">
                        </div>
                    </a>';
                }
                echo '</td>';

                echo'
                <td class="admin_users_table_td6">
                    <a href="'.Admin::adminGetLink('user_edit', $user->id).'" title="'.AdminText::get('USERS_BUTTON_USER_EDIT').'">
                        <div class="admin_table_button admin_button_edit_user">
                            <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAhFJREFUeNrsmc1Kw0AQgJMaq60o/qEgIoJPINZ38KSICvYRlOqtJx/C2safgz8XL971DbyJF0+e9KZVBKXgqa3rDIwYYpJms0l3LTvwHbJsm/m6u9nM1mSMGZ0QphbRIlpEi2gRLaJFDCMl+f5ZYBcoAl1C34QjIokMUGK/sQ1YUb9PlsQQUGZ/oxBVRpbIOvOPLSD1X0TGgVOg6SNTUFmkH9gEpul6ADhuMTLKiaSBCiV45ZAZBE4CZIoqiVgeC/vSITMcIFNSRQQ3XNsnSafMiMc0Q/msKiIVFhwoM0V9R4Ezardpn1FijdgsXOCamXTI5GmfUeKphSPRYOEDR2ZG5J5JjUSd8ceGKiImjUQUiTLtK9JFuiNMJ4wvkugRzSEOCUxij5LiCZTepx/BkC3ifhUPG3VaS2ZcU1vkw30CEgdxP2RE6onDCBINWkuGKiI54DOCiJ3UBizyqF0BnjgkKkm+DvF0xqptlqq7n7a1kDKxLmxREXwd3wE+gEWXzHOLzc5iCZcLPJ17gQtK7gVYcslUfSTS7SjeeDpjbfDgSLLqIfPqksiwNpXSPJ0nPA4LUGbZ0WcVqAFHtM8YKoos+KwB9zSbj1JPiMJzZDrn0z4GnAN5ur4B3tt99mpx9M15tD1S4nfAPR6K4yms6qfx18AbJX5LydeABtGUJaH/H9EiWkSLaBEtokU6TeRbgAEApc+LLBr1fCgAAAAASUVORK5CYII=">
                        </div>
                    </a>
                </td>
                ';
                if ($user->profile_id != '') {
                    $deleteLink = PA::adminGetLink('user_delete_profile',$user->profile_id);
                } else {
                    $deleteLink = PA::adminGetLink('user_delete',$user->id);
                }
                echo '
                </td>
                <td class="admin_users_table_td7">
                    <a href="'.$deleteLink.'" title="'.AdminText::get('USERS_BUTTON_USER_DELETE').'" class="delete_button">
                        <div class="admin_table_button admin_button_delete">
                            <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAbZJREFUeNrsmE1KAzEYhiftWBUrqCAURRAvIXgDEcWtC7cqLt14AcG9Sw8gLl0KnsGtK6GrgpTWH9BarTa+wSximGFoTMaxvIGH0sxP5pl8mSSfkFJGw1BK0ZAUilCEIhShCEWKKLIB3kDbogf2QzQoHJYoY6ACki7sg1lwDpZTrr8Fm6AOyknPBN5BN7TIMdgFnZTjM2A84x6qt1opxybAKTgc5KFih16cNnAto2A+o40otMirDqGXQOOrOmhYuYbWlG4s1PpfjZFn8BhapJAldrxuBJyBGvjwOBWokNoC93mJqEZXwJznF9vVH4LcJsRQ8Shd7+1zZv8EV6Bh1d+Aa6tOhc6ly9cp/RVgsDtQAQ35s1zoY6tGXQ8sgipoGvU7+twT6x4dUHN5Jp890ta/LWsGf9KfU3PeaSac+y9WvyLjP5fxFKEIRShCEYpQ5A9EZOhtgE+ROGGzVjIoWzvM32zsvO0Qk8oa2APrRp3Kbx3pRMKCUX8AJsG2t1WpY/JBZRrrAba6KtW0BO7yCi0RcDyJPENLdeND9J3f8plFUWnYfp6hxXmEIhShCEUoQpEili8BBgAwzfiS5i1EyAAAAABJRU5ErkJggg==">
                        </div>
                    </a>
                </td>
            </tr>';
        }
        echo '
        </table>';
    }

    public static function adminShowOfferList($offers)
    {
        $offers = $offers['offers'];

        echo '
        <table id="admin_offers_table">
            <tr>
                <th class="offer_location_what offer_location_kind admin_offers_table_td1" title="'.AdminText::get('OFFERS_KINDOFOFFER').'"></th>
                <th class="admin_offers_table_td2">'.AdminText::get('OFFERS_USERNAME').'</th>
                <th class="admin_offers_table_td3">'.AdminText::get('OFFERS_OFFER').'</th>
                <th class="admin_offers_table_td4">'.AdminText::get('OFFERS_OFFER_DATE').'</th>
                <th class="admin_offers_table_td5">'.AdminText::get('OFFERS_OFFER_CHANGE_DATE').'</th>
                <th class="admin_offers_table_td6">
                    <div class="admin_table_button admin_button_edit">
                        <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAwRJREFUeNrsmE9IFFEcx11bKTEsoqJISQxNE8oOKQQWdIqgQOgSHfp3MKJDERS1FQWSYHUIgiQIyg5CHgokKENJkywPZhld+mNSh7SygrWo1Onz6LcwPGbWnXVnR+T94MPsvH+z35n3+73feyHLsjJmgmVmzBAzQowQI8QIMUKMECMkxULy4CF0QzNkpVNIOIVjVcNG2/0l6JruX6QKIlAo9xVwRGtTJ19J2To4Dct8U6KyX49UwRfrv/2A5/DbcjbV7gWMy/0zKEzimZPitUMmPLKmZvV+CPE6tSbgsvqQSU6AUbjpx8wKJbGxmgeDctXtA0RhISxyqO+Byuni7GsgRysbgu2wCsqgFA7DuNauABYH7ew5sA3eaXN+Ara69Klz8JF2WA9ZQTl7n4vzPonTZwEMu/S7EpSzF7mU98fpMwLvXeoKgvKRny7ly+P0yYYlHsfz3UfK4AyMalNELYZrXfrUOEypATgAeUEuiIqdtpU6Zr2amFmwGUa0dioTWO0wZlhW/Ox0CpkL3xze9Bh0QbOkJU7W7TLmXvgF59IpZAP8TTI9+QxLZZwdIvwiDEm9mrYX4AEchJCfuVbbFHOtWhmrYZJ29+R5vuRaKp9pkpwrZtEE8quYfYX78rvXVq42ZEfhtq3sqfaclKfxij3QBFsk+uyC79obfQObIB92wy2olP6HbBlCuwSH2Nh3bdMw4qePuFGrCal2aTdfa3dSqz+m1addSAm8gtfixNni2MVwHMphhS2Ev5Q/2iOpjCqfDZ1SPgj7gxASCwZh+a2EnJewasm1A3Klfp/trb+F61o+d8rv8JsoZyEqi2crfJKw3Sr1NyaJWl2a78QlnOGPqU3XStm31MBVKIY+yIcSaIQxeCwHF6Wyr1GHGuXQ4SVq+SVkji1ZHJDrR/gj4tQOsk1QNgwNUA/X0nWKkigRmSLK+U/AHbnvdGmf62UlT6ePFEGjNu/7JXqFUv28ZA4fvFiFHOKp/XyLbLRapsspijmNN0KMECPECDFCjBAjxGf7J8AA1yBq1Xbt28kAAAAASUVORK5CYII=">
                    </div>
                </th>
                <th class="admin_offers_table_td7">
                    <div class="admin_table_button admin_button_preview">
                        <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAsFJREFUeNrsl0tIVUEYgL3XwjKxXBhBCpHVokWWKRHRJgIp6bnQoBbVXYZQG1u4KKKoFkVhbSKCHrYKBKOgTS3TyMAiei2iB/QwNDIf2b339E38B36Gi+mJU5f6Bz5G58yZ+b9zz/wzJxEEQcG/UBImYiImYiImYiImYiImYiIm8t+JBJmM31QJK2EpVEEZJGEQXkEvdMGTnwEUFuaVyFTYBClYDTN+cZu7qQeuQDsy/fkgspHqANR4l8ZgAIYgC8UwS2pdXsNJOIfQyB8XQWA+VRusV8190Akd8sSdSAkUyavlXrEl0ABbYaG69xHsReZ2tIAQmSzZdHoNfIBAGICDMAcKhGq4Bm+hD3pgj7o+HXbBCzVOGlJRYooisQW+qslvwiIVoGMnfFN9NJ0wTfUtg1MiEfZpjVWECTZDViZz9T5PwLF4HImQM2F/NfY6+KT67I9FhIFXwBeZZBCapN2nTQXzHhqhFtpV+zBUahEZa5n3ym6LQ+SemuCQavfpVv1Sqr3Ue+INvoiM16h+9ZcTjS85ibxwWNKoK02StXIVvcMNqb+/y/4Rlik5MqGLZ7fLptJ0NpasxRNqUU/0OVTl+EUuqD4uI62CCjih2sdggbdGEnBe9elwbXFmLR3oM1juidRBxlvcw97/l/Ripy72xn0K5bGmX5n4tJp0FJo9mZZxMtZdWS9h3xrZY8LrD90vGPs+omSOegHekuwUBlgPXTAii9dtjMehSK7PdPuFZMBwjN4oEo7fOmuxOHdQHYO50pSG63AVuuEjzJYjSr9cr4Z62A7z1HAX5Yjy+W8dGl2gRyTbJL0T7ht4JxmrXI74Jd4Q7ljfisCNfPkeqXVPFDZA6QRuve9OvHAZidF8/LByr9laqIMKkUrKnuJetcdwBx642/Pmw8q+2U3EREzEREzEREzEREzEREwkYvkhwAD4ho8lKnZL5AAAAABJRU5ErkJggg=="/>
                    </div>
                </th>
                <th class="admin_offers_table_td8">
                    <div class="admin_table_button admin_button_delete">
                        <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAbZJREFUeNrsmE1KAzEYhiftWBUrqCAURRAvIXgDEcWtC7cqLt14AcG9Sw8gLl0KnsGtK6GrgpTWH9BarTa+wSximGFoTMaxvIGH0sxP5pl8mSSfkFJGw1BK0ZAUilCEIhShCEWKKLIB3kDbogf2QzQoHJYoY6ACki7sg1lwDpZTrr8Fm6AOyknPBN5BN7TIMdgFnZTjM2A84x6qt1opxybAKTgc5KFih16cNnAto2A+o40otMirDqGXQOOrOmhYuYbWlG4s1PpfjZFn8BhapJAldrxuBJyBGvjwOBWokNoC93mJqEZXwJznF9vVH4LcJsRQ8Shd7+1zZv8EV6Bh1d+Aa6tOhc6ly9cp/RVgsDtQAQ35s1zoY6tGXQ8sgipoGvU7+twT6x4dUHN5Jp890ta/LWsGf9KfU3PeaSac+y9WvyLjP5fxFKEIRShCEYpQ5A9EZOhtgE+ROGGzVjIoWzvM32zsvO0Qk8oa2APrRp3Kbx3pRMKCUX8AJsG2t1WpY/JBZRrrAba6KtW0BO7yCi0RcDyJPENLdeND9J3f8plFUWnYfp6hxXmEIhShCEUoQpEili8BBgAwzfiS5i1EyAAAAABJRU5ErkJggg==">
                    </div>
                </th>
            </tr>';

        foreach ($offers as $offer) {
            $created = strtotime($offer->created);
            $modified = strtotime($offer->modified);

            // DATES
            $diff = 86400;
            $difference = $modified - $created;

            $offer_date = date('d.m.Y',$created);

            if (!$modified || $difference < $diff) {
                $offer_date_modified = '[x]';
            } else {
                $offer_date_modified =  date('d.m.Y',$modified);
            }

            // Status
            if ($offer->status == 1) {
                $offer_status = '<span class="status_red">&bull;</span>';
            } elseif ($offer->status == 2) {
                $offer_status = '<span class="status_yellow">&bull;</span>';
            } elseif ($offer->status == 3) {
                $offer_status = '<span class="status_green">&bull;</span>';
            }

            if ($offer->external == 1) {
                $offerlist_location_class = 'offer_location_extern';
                $offerlist_location_text = AdminText::get('OFFERS_EXTERN');
                $platform = ConnectionsModel::getPlatformDetailsByID($offer->external_platform_id);

                if (isset($platform->name) && $platform->name != false) {
                    $offerlist_user_text = '['.$platform->name.']';
                } else {
                    $offerlist_user_text = '['.AdminText::get('PLATFORM_DELETED').']';
                }
            } else {
                $offerlist_location_class = 'offer_location_intern';
                $offerlist_location_text = AdminText::get('OFFERS_INTERN');
                $offerlist_user_text = $offer->company_name;
            }

            echo '
            <tr>
                <td class="offer_location_what '.$offerlist_location_class.' admin_offers_table_td1" title="'.$offerlist_location_text.'"></td>
                <td class="admin_offers_table_td2"><a href="'.PA::getLink('user',$offer->profile_id).'">'.$offerlist_user_text.'</a></td>
                <td class="admin_offers_table_td3">'.$offer_status.' '.$offer->title.'</td>
                <td class="admin_offers_table_td4">'.$offer_date.'</td>
                <td class="admin_offers_table_td5">'.$offer_date_modified.'</div></td>
                <td class="admin_offers_table_td6">';
                if ($offer->external == 0) {
                    echo '
                    <a href="'.PA::adminGetLink('offer_edit',$offer->id).'" title="'.AdminText::get('OFFERS_BUTTON_EDIT').'">
                        <div class="admin_table_button admin_button_edit">
                        <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAwRJREFUeNrsmE9IFFEcx11bKTEsoqJISQxNE8oOKQQWdIqgQOgSHfp3MKJDERS1FQWSYHUIgiQIyg5CHgokKENJkywPZhld+mNSh7SygrWo1Onz6LcwPGbWnXVnR+T94MPsvH+z35n3+73feyHLsjJmgmVmzBAzQowQI8QIMUKMECMkxULy4CF0QzNkpVNIOIVjVcNG2/0l6JruX6QKIlAo9xVwRGtTJ19J2To4Dct8U6KyX49UwRfrv/2A5/DbcjbV7gWMy/0zKEzimZPitUMmPLKmZvV+CPE6tSbgsvqQSU6AUbjpx8wKJbGxmgeDctXtA0RhISxyqO+Byuni7GsgRysbgu2wCsqgFA7DuNauABYH7ew5sA3eaXN+Ara69Klz8JF2WA9ZQTl7n4vzPonTZwEMu/S7EpSzF7mU98fpMwLvXeoKgvKRny7ly+P0yYYlHsfz3UfK4AyMalNELYZrXfrUOEypATgAeUEuiIqdtpU6Zr2amFmwGUa0dioTWO0wZlhW/Ox0CpkL3xze9Bh0QbOkJU7W7TLmXvgF59IpZAP8TTI9+QxLZZwdIvwiDEm9mrYX4AEchJCfuVbbFHOtWhmrYZJ29+R5vuRaKp9pkpwrZtEE8quYfYX78rvXVq42ZEfhtq3sqfaclKfxij3QBFsk+uyC79obfQObIB92wy2olP6HbBlCuwSH2Nh3bdMw4qePuFGrCal2aTdfa3dSqz+m1addSAm8gtfixNni2MVwHMphhS2Ev5Q/2iOpjCqfDZ1SPgj7gxASCwZh+a2EnJewasm1A3Klfp/trb+F61o+d8rv8JsoZyEqi2crfJKw3Sr1NyaJWl2a78QlnOGPqU3XStm31MBVKIY+yIcSaIQxeCwHF6Wyr1GHGuXQ4SVq+SVkji1ZHJDrR/gj4tQOsk1QNgwNUA/X0nWKkigRmSLK+U/AHbnvdGmf62UlT6ePFEGjNu/7JXqFUv28ZA4fvFiFHOKp/XyLbLRapsspijmNN0KMECPECDFCjBAjxGf7J8AA1yBq1Xbt28kAAAAASUVORK5CYII=" />
                        </div>
                    </a>';
                }
                echo '
                </td>
                <td class="admin_offers_table_td7">
                    <a href="'.PA::adminGetLink('offer_view',$offer->id).'" title="'.AdminText::get('OFFERS_BUTTON_VIEW').'">
                        <div class="admin_table_button admin_button_preview">
                            <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAsFJREFUeNrsl0tIVUEYgL3XwjKxXBhBCpHVokWWKRHRJgIp6bnQoBbVXYZQG1u4KKKoFkVhbSKCHrYKBKOgTS3TyMAiei2iB/QwNDIf2b339E38B36Gi+mJU5f6Bz5G58yZ+b9zz/wzJxEEQcG/UBImYiImYiImYiImYiImYiIm8t+JBJmM31QJK2EpVEEZJGEQXkEvdMGTnwEUFuaVyFTYBClYDTN+cZu7qQeuQDsy/fkgspHqANR4l8ZgAIYgC8UwS2pdXsNJOIfQyB8XQWA+VRusV8190Akd8sSdSAkUyavlXrEl0ABbYaG69xHsReZ2tIAQmSzZdHoNfIBAGICDMAcKhGq4Bm+hD3pgj7o+HXbBCzVOGlJRYooisQW+qslvwiIVoGMnfFN9NJ0wTfUtg1MiEfZpjVWECTZDViZz9T5PwLF4HImQM2F/NfY6+KT67I9FhIFXwBeZZBCapN2nTQXzHhqhFtpV+zBUahEZa5n3ym6LQ+SemuCQavfpVv1Sqr3Ue+INvoiM16h+9ZcTjS85ibxwWNKoK02StXIVvcMNqb+/y/4Rlik5MqGLZ7fLptJ0NpasxRNqUU/0OVTl+EUuqD4uI62CCjih2sdggbdGEnBe9elwbXFmLR3oM1juidRBxlvcw97/l/Ripy72xn0K5bGmX5n4tJp0FJo9mZZxMtZdWS9h3xrZY8LrD90vGPs+omSOegHekuwUBlgPXTAii9dtjMehSK7PdPuFZMBwjN4oEo7fOmuxOHdQHYO50pSG63AVuuEjzJYjSr9cr4Z62A7z1HAX5Yjy+W8dGl2gRyTbJL0T7ht4JxmrXI74Jd4Q7ljfisCNfPkeqXVPFDZA6QRuve9OvHAZidF8/LByr9laqIMKkUrKnuJetcdwBx642/Pmw8q+2U3EREzEREzEREzEREzEREwkYvkhwAD4ho8lKnZL5AAAAABJRU5ErkJggg==
" />
                        </div>
                    </a>
                </td>
                <td class="admin_offers_table_td8">
                    <a href="'.PA::adminGetLink('offer_delete',$offer->id).'" title="'.AdminText::get('OFFERS_BUTTON_DELETE').'" class="delete_button">
                        <div class="admin_table_button admin_button_delete">
                            <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAbZJREFUeNrsmE1KAzEYhiftWBUrqCAURRAvIXgDEcWtC7cqLt14AcG9Sw8gLl0KnsGtK6GrgpTWH9BarTa+wSximGFoTMaxvIGH0sxP5pl8mSSfkFJGw1BK0ZAUilCEIhShCEWKKLIB3kDbogf2QzQoHJYoY6ACki7sg1lwDpZTrr8Fm6AOyknPBN5BN7TIMdgFnZTjM2A84x6qt1opxybAKTgc5KFih16cNnAto2A+o40otMirDqGXQOOrOmhYuYbWlG4s1PpfjZFn8BhapJAldrxuBJyBGvjwOBWokNoC93mJqEZXwJznF9vVH4LcJsRQ8Shd7+1zZv8EV6Bh1d+Aa6tOhc6ly9cp/RVgsDtQAQ35s1zoY6tGXQ8sgipoGvU7+twT6x4dUHN5Jp890ta/LWsGf9KfU3PeaSac+y9WvyLjP5fxFKEIRShCEYpQ5A9EZOhtgE+ROGGzVjIoWzvM32zsvO0Qk8oa2APrRp3Kbx3pRMKCUX8AJsG2t1WpY/JBZRrrAba6KtW0BO7yCi0RcDyJPENLdeND9J3f8plFUWnYfp6hxXmEIhShCEUoQpEili8BBgAwzfiS5i1EyAAAAABJRU5ErkJggg==" />
                        </div>
                    </a>
                </td>
            </tr>';
        }
    echo '
    </table>';
    }

    public static function adminGetCategoryKeys()
    {
        $categories = Text::get('CATEGORY2');
        return array_keys($categories);
    }

    public static function adminShowCategories($type='',$prefix='',$category_selected='')
    {
        $categories = Text::get('CATEGORY2');
        unset($categories[0]);

        if ($type == 'checkbox') {
            if (in_array('0',$category_selected)) {
                $checked = ' checked';
            } else {
                $checked = '';
            }
            echo '
                <script language="JavaScript">
                    function '.$prefix.'_toggle(source) {
                        checkboxes = document.getElementsByName("'.$prefix.'[]");
                        for(var i=0, n=checkboxes.length;i<n;i++) {
                            checkboxes[i].checked = source.checked;
                        }
                    }
                    </script>
                <input type="checkbox"
                       value="0"
                       name="'.$prefix.'[]"
                       id="'.$prefix.'_all"
                       class="css-checkbox"
                       onClick="'.$prefix.'_toggle(this)"'.$checked.'>
                <label for="'.$prefix.'_all" class="css-label">'.AdminText::get('CATEGORY_SELECT_ALL').'</label>';

            foreach ($categories as $key => $category) {
                if (in_array($key,$category_selected)) {
                    $checked = ' checked';
                } else {
                    $checked = '';
                }
                echo '
                    <input type="checkbox"
                           value="'.$key.'"
                           name="'.$prefix.'[]"
                           id="'.$prefix.'_cat_'.$key.'"'.$checked.'>
                    <label for="'.$prefix.'_cat_'.$key.'">'.$category[0].'</label>';
            }
        } elseif ($type == 'select') {
            echo '
                <select id="'.$prefix.'_select" class="form_element" name="'.$prefix.'">
                <option value="0">'.AdminText::get('CATEGORY_CHOOSE').'</option>';

            foreach ($categories as $key => $category) {
                echo '<option value="'.$key.'"';
                if ($category_selected == $key) { echo ' selected'; }
                echo '>'.$category[0].'</option>';
            }
            echo '</select>';
        }
    }

    public static function isAdminArea()
    {
        if (View::getAdminStatus()) {
            return true;
        } else {
            return false;
        }
    }
}
?>
