<?php

class AdminController extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    public function __construct()
    {
        parent::__construct();
        Auth::checkForSuperAdmin();
    }

    public function index()
    {
        $this->View->renderAdmin('index');
    }

    public function settings()
    {
        $this->View->renderAdmin('settings', array(
            'settings' => AdminModel::getSettings()
        ));
    }

    public function save_settings()
    {
        AdminModel::saveSettings();
        Redirect::to('admin/settings');
    }

    public function connections()
    {
        $this->View->renderAdmin('connections', array(
            'connections' => ConnectionsModel::listConnectedPlatforms()
        ));
    }

    public function connections_add()
    {
        ConnectionsModel::connect();
        Redirect::to('admin/connections');
    }

    public function connection_confirm($uuid)
    {
        ConnectionsModel::confirm($uuid);
        Redirect::to('admin/connections');
    }

    public function connection_edit($platform_id)
    {
        ConnectionsModel::edit($platform_id);
        Redirect::to('admin/connections');
    }

    public function connection_delete($platform_id)
    {
        ConnectionsModel::delete($platform_id);
        Redirect::to('admin/connections');
    }

    public function users($action = null, $id = null)
    {
        switch (TRUE)
        {
            case ($action == 'add'):
                $this->View->renderAdmin('addUser');
                break;
            case ($action == 'add_action'):
                $registration = RegistrationModel::registerNewUser(true);

                if (is_bool($registration) && $registration == true) {
                    Redirect::to('admin/users');
                } else {
                    $this->View->renderAdmin('addUser',array(
                        'registration' => $registration
                    ));
                }
                break;
            case ($action == 'edit' && isset($id)):
                $this->View->renderAdmin('editUser', array(
                    'user' => UserModel::getProfileWithDetails($id)
                ));
                break;
            case ($action == 'edit_action' && isset($id)):
                    UserModel::changeUsernameAndEmail($id);
                    Redirect::to('admin/users/edit/'.$id);
                break;
            default:
                $this->View->renderAdmin('users', array(
                    'users' => UserModel::getProfilesWithDetails()
                ));
                break;
        }
    }

    public function offers()
    {
        $this->View->renderAdmin('offers');
    }

    public function pages($action = null, $id = null)
    {
        switch (TRUE)
        {
            case ($action == 'add'):
                $this->View->renderAdmin('editPage', array(
                    'page' => PageModel::getEmptyPage()
                ));
                break;
            case ($action == 'edit' && isset($id)):
                $this->View->renderAdmin('editPage', array(
                    'page' => PageModel::getPage($id)
                ));
                break;
            default:
                $this->View->renderAdmin('pages', array(
                    'pages' => PageModel::getPages(false)
                ));
        }
    }

    public function save_page($id)
    {
        PageModel::savePage($id);
        Redirect::to('admin/pages');
    }
}
