<?php
$profile = $data['profile'];
?>
<div id="start_content">
    <?php
    if (PA::isFirstPage()) {
        ?>
        <div id="protagonist_box" class="left onethird">
            <?php
            PA::showUserContact($profile);
            PA::showUserOpeningHours($profile);
            ?>
        </div>
        <div id="user_box" class="right twothird">
            <?php
            if (PA::isOwner($profile->id)) {
                PA::ShowEditMenu($profile);
                if ($profile->company_short_info == '') {
                    echo '<h4>'.Text::get('USER_PROFILE_NO_DESCRIPTION_SHORT').'</h4>';
                }
                if ($profile->company_info == '') {
                    echo '<p>'.Text::get('USER_PROFILE_NO_DESCRIPTION').'</p>';
                }
            }

            if ($profile->company_short_info != '') {
                echo '<h4>'.$profile->company_short_info.'</h4>';
            }
            if ($profile->company_info != '') {
                echo '<p>'.$profile->company_info.'</p>';
            }

            ?>
        </div>
        <div class="clear"></div>

        <?php
        $args = array('profile' => $profile->id,
                      'userFeatured' => true,
                      'howMany' => 8,
                      'orderBy' => 'random');
        $featuredOffers = PA::getOffers($args);

        if ($featuredOffers['number'] > 0) {
            echo '<h2 class="headline">'.Text::get('PROFILE_FEATURED_OFFERS').' '.$profile->company_name.'</h2>';
            PA::showOffersWithPictures($featuredOffers,false);
        }

        //SHOW OFFERS
        $args = array('profile' => $profile->id,
                      'type' => 1,
                      'howMany' => 10,
                      'orderBy' => 'created',
                      'order' => 'DESC');
        $offers = PA::getOffers($args);

        if ($offers['number'] > 0) {
            echo '<h2 class="headline">'.PA::filter(Text::get('PROFILE_ALL_OFFERS'),$offers['number']).' '.$profile->company_name.'</h2>';
            PA::showOfferList($offers,'',true,true,true,false);
            PA::showPagination($offers['number'],$args['howMany'],'',Text::get('OFFERS_MORE'),true);
        }

        $args = array('profile' => $profile->id,
                      'type' => 2,
                      'howMany' => 10,
                      'orderBy' => 'created',
                      'order' => 'DESC');
        $offers = PA::getOffers($args);

        //SHOW REQUESTS
        if ($offers['number'] == 'E' || !$offers['number']) {
            $offers['number'] = 0;
        }
        if ($offers['number'] > 0) {
            echo '<h2 class="headline">'.PA::filter(Text::get('PROFILE_ALL_REQUESTS'),$offers['number']).' '.$profile->company_name.'</h2>';
            PA::showOfferList($offers,'',true,true,true,false);
            PA::showPagination($offers['number'],$args['howMany'],'',Text::get('OFFERS_MORE'),true);
        }
    }

    //IF NOT ON FIRST PAGE
    else {
        $args = array('profile' => $profile->id,
                      'type' => 1,
                      'howMany' => 10,
                      'orderBy' => 'created',
                      'order' => 'DESC');
        $offers = PA::getOffers($args);
        echo '<h2 class="headline">'.PA::filter(Text::get('PROFILE_ALL_OFFERS'),$offers['number']).' '.$profile->company_name.'</h2>';
        PA::showOfferList($offers);
        PA::showPagination($offers['number'],$args['howMany'],'',Text::get('OFFERS_MORE'),true);
    }
?>
</div>
<?php
PA::showFooter();
?>
