<?php

class AdminText
{
    private static $texts;

    public static function get($key)
    {
        // if not $key
        if (!$key) {
            return null;
        }

        // load config file (this is only done once per application lifecycle)
        if (!self::$texts)
        {
            $lang = Language::get();
            self::$texts = require(Config::get('PATH_VIEW').'admin/language/'.$lang.'.texts.php');
        }

        // check if array key exists
        if (!array_key_exists($key, self::$texts))
        {
            return $key;
        }

        return self::$texts[$key];
    }

}
