<?php

class UpdateController extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    public function __construct()
    {
        parent::__construct();
    }

    public function postalcode()
    {
        Session::set('search_plz', Request::post('setNewPLZ',true));
        Redirect::to(Helper::getCurrentPath());
    }

    public function sorting($order)
    {
        // look for sort in url and set sort order for sorting
        $sortOrder = explode('_',$order);
        print_r($sortOrder);
        Helper::setSortOrder($sortOrder[0],$sortOrder[1]);
        Redirect::to(Helper::getCurrentPath());
    }

    public function feature($type,$what,$id)
    {
        switch ($type)
        {
            case 'admin':
                Auth::checkForAdmin();
                switch ($what)
                {
                    case 'offer':
                        OfferModel::featureOffer('admin',$id);
                        $redirect = 'offers';
                        break;
                    case 'profile':
                        UserProfileModel::featureProfile($id);
                        $redirect = 'profiles';
                        break;
                    case 'other':
                        UserProfileModel::featureOtherProfile($id);
                        $redirect = 'profiles';
                        break;
                }
                break;
            case 'user':
                switch ($what)
                {
                    case 'offer':
                        OfferModel::checkOwnership($id);
                        OfferModel::featureOffer('user',$id);
                        $redirect = 'offers';
                        break;
                }
                break;
        }
        Redirect::to($redirect.'/view/'.$id);
    }

    public function approve($user_id)
    {
        Auth::checkForSuperAdmin();
        UserModel::approveUser($user_id);
        Redirect::to('admin/users');
    }

    public function disapprove($user_id)
    {
        Auth::checkForSuperAdmin();
        UserModel::disapproveUser($user_id);
        Redirect::to('admin/users');
    }

    public function delete($what,$id,$type = null)
    {
        switch ($what)
        {
            case 'offer':
                OfferModel::checkOwnership($id);
                $offer = OfferModel::getOffer($id);
                OfferModel::deleteOffer($id);
                Redirect::to('profiles/view/'.$offer->profile_id);
                break;
            case 'profile':
                UserProfileModel::checkOwnership($id);
                UserProfileModel::deleteProfile($id);
                Redirect::to('admin/users');
                break;
            case 'image':
                if ($type != null) {
                    $returnpath = UploadModel::deleteImage($type,$id);
                    Redirect::to($returnpath);
                }
                break;
            case 'user':
                Auth::checkForSuperAdmin();
                UserModel::deleteUser($id, true);
                Redirect::to('admin/users');
                break;
        }
    }
}
