<?php

class SyncController extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    public function __construct()
    {
        parent::__construct();
    }

    public function index()
    {
        $this->View->renderJSON(
            SyncModel::checkSyncStatus()
        );
    }

    public function all($limit = 10)
    {
        $this->View->renderJSON(
            SyncModel::combineJobs($limit)
        );
    }

    public function delete($limit = 5)
    {
        $this->View->renderJSON(
            SyncModel::getJobs($limit,'delete')
        );
    }

    public function mails($limit = 5)
    {
        $this->View->renderJSON(
            SyncModel::processMailJobs($limit)
        );
    }

    public function statistics()
    {
        $this->View->renderJSON(
            SyncModel::getStatisticsJobs()
        );
    }
}
