<?php
$settings = $data['settings'];

if ($settings->MarketLogo == '') { $settings->MarketLogo = null; }
if ($settings->MarketHeader == '') { $settings->MarketHeader = null; }
if ($settings->MarketBackground == '') { $settings->MarketBackground = null; }

$pages = PageModel::getPages();
$noLink = new stdClass();
$noLink->id = 0;
$noLink->title = AdminText::get('SETTINGS_PLATFORM_NO_LINK');
array_unshift($pages, $noLink);

echo '
    <h1 class="headline">'.AdminText::get('SETTINGS_HEADLINE').'</h1>
    <div id="admin_sidebar" class="right admin_onethird">';
        PA::showImageUploader('platformlogo',
                              'logo_medium',
                              'platform',
                              $settings->MarketLogo,
                              AdminText::get('SETTINGS_PLATFORM_LOGO'));
        PA::showImageUploader('platformheader',
                              'header_small',
                              'platform',
                              $settings->MarketHeader,
                              AdminText::get('SETTINGS_PLATFORM_HEADER'));
        PA::showImageUploader('platformbackground',
                              'background_small',
                              'platform',
                              $settings->MarketBackground,
                              AdminText::get('SETTINGS_PLATFORM_BACKGROUND'));
        echo '
    </div>

    <div class="admin_box left admin_twothird">
        <form action="'.PA::getURL().'admin/save_settings"
              name="saveSettings"
              method="post">
            <label for="platformTitle"
                   class="form_label"><span>'.AdminText::get('SETTINGS_PLATFORM_NAME_LABEL').'</span></label>
            <input type="text"
                   name="MarketName"
                   id="platformTitle"
                   class="form_element"
                   placeholder="'.AdminText::get('SETTINGS_PLATFORM_NAME_PLACEHOLDER').'"
                   value="'.$settings->MarketName.'" />
            <label for="platformClaim"
                   class="form_label"><span>'.AdminText::get('SETTINGS_PLATFORM_CLAIM_LABEL').'</span></label>
            <input type="text"
                   name="MarketClaim"
                   id="platformClaim"
                   class="form_element"
                   placeholder="'.AdminText::get('SETTINGS_PLATFORM_CLAIM_PLACEHOLDER').'"
                   value="'.$settings->MarketClaim.'" />
            <label for="platformDetailShort" class="form_label"><span>'.AdminText::get('SETTINGS_PLATFORM_SHORTTEXT_LABEL').'</span></label>
            <textarea type="text"
                   name="MarketDetailShort"
                   id="platformDetailShort"
                   class="form_element"
                   placeholder="'.AdminText::get('SETTINGS_PLATFORM_SHORTTEXT_PLACEHOLDER').'"
                   rows="5">'.$settings->MarketDetailShort.'</textarea>
            <label for="platformDetail" class="form_label"><span>'.AdminText::get('SETTINGS_PLATFORM_LONGTEXT_LABEL').'</span></label>
            <textarea type="text"
                   name="MarketDetail"
                   id="platformDetail"
                   class="form_element"
                   placeholder="'.AdminText::get('SETTINGS_PLATFORM_LONGTEXT_PLACEHOLDER').'"
                   rows="7">'.$settings->MarketDetail.'</textarea>
            <label for="MarketDetailLinkText" class="form_label"><span>'.AdminText::get('SETTINGS_PLATFORM_DETAIL_LINK_LABEL').'</span></label>
            <div class="admin_onethird left">
                <input type="text"
                       name="MarketDetailLinkText"
                       class="form_element"
                       placeholder="'.AdminText::get('SETTINGS_PLATFORM_DETAIL_LINK_TEXT_PLACEHOLDER').'"
                       value="'.$settings->MarketDetailLinkText.'">
            </div>
            <div class="admin_twothird right">
                <select id="platformDetailLink"
                        class="form_element"
                        name="MarketDetailLink">';
                foreach ($pages as $page) {
                    echo '
                    <option value="'.$page->id.'"';
                    if ($settings->MarketDetailLink == $page->id) { echo ' selected'; }
                    echo '>'.$page->title.'</option>';
                }
                echo '
                </select>
            </div>
            <div class="clear"></div>
            <label for="companyContactPerson" class="form_label"><span>'.AdminText::get('SETTINGS_PLATFORM_CONTACTPERSON_LABEL').'</span></label>
            <input type="text"
                   name="MarketContactPerson"
                   class="form_element"
                   placeholder="'.AdminText::get('SETTINGS_PLATFORM_CONTACTPERSON_PLACEHOLDER').'"
                   value="'.$settings->MarketContactPerson.'">
            <label for="companyPhone" class="form_label"><span>'.AdminText::get('SETTINGS_PLATFORM_TEL_LABEL').'</span></label>
            <input type="text"
                   name="MarketContactTel"
                   class="form_element"
                   placeholder="'.AdminText::get('SETTINGS_PLATFORM_TEL_PLACEHOLDER').'"
                   value="'.$settings->MarketContactTel.'">
            <label for="companyFax" class="form_label"><span>'.AdminText::get('SETTINGS_PLATFORM_FAX_LABEL').'</span></label>
            <input type="text"
                   name="MarketContactFax"
                   class="form_element"
                   placeholder="'.AdminText::get('SETTINGS_PLATFORM_FAX_PLACEHOLDER').'"
                   value="'.$settings->MarketContactFax.'">
            <label for="companyEmail" class="form_label"><span>'.AdminText::get('SETTINGS_PLATFORM_EMAIL_LABEL').'</span></label>
            <input type="email"
                   name="MarketContactEmail"
                   class="form_element"
                   placeholder="'.AdminText::get('SETTINGS_PLATFORM_EMAIL_PLACEHOLDER').'"
                   value="'.$settings->MarketContactEmail.'">
            <label for="companyWebsite" class="form_label"><span>'.AdminText::get('SETTINGS_PLATFORM_WEB_LABEL').'</span></label>
            <input type="url"
                   name="MarketContactWeb"
                   class="form_element"
                   placeholder="'.AdminText::get('SETTINGS_PLATFORM_WEB_PLACEHOLDER').'"
                   value="'.$settings->MarketContactWeb.'">
            <label for="companyAddressStreet" class="form_label"><span>'.AdminText::get('SETTINGS_PLATFORM_ADRESS_LABEL').'</span></label>
            <div class="admin_twothird left">
                <input type="text"
                       name="MarketAddressStreet"
                       class="form_element"
                       placeholder="'.AdminText::get('SETTINGS_PLATFORM_STREET_PLACEHOLDER').'"
                       value="'.$settings->MarketAddressStreet.'">
            </div>
            <div class="admin_onethird right">
                <input type="text"
                       name="MarketAddressNumber"
                       class="form_element"
                       placeholder="'.AdminText::get('SETTINGS_PLATFORM_STREETNO_PLACEHOLDER').'"
                       value="'.$settings->MarketAddressNumber.'">
            </div>
            <div class="clear"></div>
            <div class="admin_onethird left">
                <input type="text"
                       name="MarketAddressZipcode"
                       class="form_element"
                       placeholder="'.AdminText::get('SETTINGS_PLATFORM_ZIP_PLACEHOLDER').'"
                       value="'.$settings->MarketAddressZipcode.'">
            </div>
            <div class="admin_twothird right">
                <input type="text"
                       name="MarketAddressCity"
                       class="form_element"
                       placeholder="'.AdminText::get('SETTINGS_PLATFORM_TOWN_PLACEHOLDER').'"
                       value="'.$settings->MarketAddressCity.'">
            </div>
            <div class="clear"></div>
            <div class="admin_half left">
                <input type="text"
                       name="MarketAddressState"
                       class="form_element"
                       placeholder="'.AdminText::get('SETTINGS_PLATFORM_STATE_PLACEHOLDER').'"
                       value="'.$settings->MarketAddressState.'">
            </div>
            <div class="admin_half right">
                <input type="text"
                       name="MarketAddressCountry"
                       class="form_element"
                       placeholder="'.AdminText::get('SETTINGS_PLATFORM_COUNTRY_PLACEHOLDER').'"
                       value="'.$settings->MarketAddressCountry.'">
            </div>
            <label for="MarketContactLinkText" class="form_label"><span>'.AdminText::get('SETTINGS_PLATFORM_CONTACT_LINK_LABEL').'</span></label>
            <div class="admin_onethird left">
                <input type="text"
                       name="MarketContactLinkText"
                       class="form_element"
                       placeholder="'.AdminText::get('SETTINGS_PLATFORM_CONTACT_LINK_TEXT_PLACEHOLDER').'"
                       value="'.$settings->MarketContactLinkText.'">
            </div>
            <div class="admin_twothird right">
                <select id="platformContactLink"
                        class="form_element"
                        name="MarketContactLink">';
                    foreach ($pages as $page) {
                        echo '
                        <option value="'.$page->id.'"';
                        if ($settings->MarketContactLink == $page->id) { echo ' selected'; }
                        echo '>'.$page->title.'</option>';
                    }
                    echo '
                </select>
            </div>
            <div class="clear"></div>
            <label for="platformTheme"
                   class="form_label"><span>'.AdminText::get('SETTINGS_PLATFORM_THEME_LABEL').'</span></label>
            <select id="platformTheme"
                    class="form_element"
                    name="MarketUsedTheme">';
                $themes_available = PA::getThemes();
                foreach( $themes_available as $theme )
                {
                    echo '
                    <option value="'.$theme.'"';
                    if (PA::getThemeName() == $theme) { echo ' selected'; }
                    echo '>'.$theme.'</option>';
                }
                echo '
            </select>

            <label for="platformShareStatistics" class="form_label">
                <span>'.AdminText::get('SETTINGS_SHARE_STATISTICS_LABEL').'</span>
            </label>';
            $selected = Config::getFromDB('MarketShareStatistics');
            echo '
            <select id="platformShareStatistics"
                    class="form_element"
                    name="MarketShareStatistics">
                <option value="0">'.AdminText::get('SETTINGS_DONT_SHARE_STATISTICS').'</option>';
                foreach (ConnectionsModel::listConnectedPlatforms() as $connection)
                {
                    echo '<option value="'.$connection->id.'"';
                         if ($connection->id == $selected) { echo ' selected'; }
                         echo '>'
                            .AdminText::get('SETTINGS_SHARE_STATISTICS_YES')
                            .$connection->name.' ('.rtrim($connection->url,'/').')'.
                         '</option>';
                }
            echo '
            </select>

            <label for="platformRegistration" class="form_label">
                <span>'.AdminText::get('SETTINGS_PLATFORM_REGISTER_LABEL').'</span>
            </label>
            <select id="platformRegistration"
                    class="form_element"
                    name="MarketRegistrationStatus">';
                echo '<option value="2"';
                if ($settings->MarketRegistrationStatus == 2) {
                    echo ' selected';
                }
                echo '>'.AdminText::get('SETTINGS_PLATFORM_REGISTER_2').'</option>';
                echo '<option value="1"';
                if ($settings->MarketRegistrationStatus == 1) {
                    echo ' selected';
                }
                echo '>'.AdminText::get('SETTINGS_PLATFORM_REGISTER_1').'</option>';
                echo '<option value="0"';
                if ($settings->MarketRegistrationStatus == 0) {
                    echo ' selected';
                }
                echo '>'.AdminText::get('SETTINGS_PLATFORM_REGISTER_0').'</option>';
                echo '
            </select>

            <label for="MarketAdminEmail"
                   class="form_label"><span>'.AdminText::get('SETTINGS_PLATFORM_ADMIN_EMAIL').'</span></label>
            <input type="text"
                   name="MarketAdminEmail"
                   id="platformAdminEmail"
                   class="form_element"
                   placeholder="'.AdminText::get('SETTINGS_PLATFORM_ADMIN_EMAIL_PLACEHOLDER').'"
                   value="'.$settings->MarketAdminEmail.'" />

            <input type="submit"
                   value="'.AdminText::get('SETTINGS_PLATFORM_SUBMIT_BUTTON').'"
                   class="form_submit">
        </form>
    </div>
    <div class="clear"></div>';
PA::showFooter();
?>
