<?php

/**
 * Class PA//ADMIN
 *
 */
class Admin
{

    public static function adminGetLink($type, $id = '')
    {
        switch ($type)
        {
            //  ADMIN NAVI
            case 'index':
                $link = PA::getHomeURL().'admin/';
                break;
            case 'settings':
                $link = PA::getHomeURL().'admin/settings';
                break;
            case 'connections':
                $link = PA::getHomeURL().'admin/connections';
                break;
            case 'users':
                $link = PA::getHomeURL().'admin/users';
                break;
            case 'offers':
                $link = PA::getHomeURL().'admin/offers';
                break;
            case 'pages':
                $link = PA::getHomeURL().'admin/pages';
                break;

            //USER ADMINISTRATION
            case 'user_edit':
                $link = PA::getHomeURL().'profiles/edit/'.$id;
                break;
            case 'user_view':
                $link = PA::getHomeURL().'profiles/view/'.$id;
                break;
            case 'user_delete_profile':
                $link = PA::getHomeURL().'update/delete/profile/'.$id;
                break;
            case 'user_delete':
                $link = PA::getHomeURL().'update/delete/user/'.$id;
                break;
            case 'new_offer':
                $link = PA::getHomeURL().'offers/add/'.$id;
                break;
            case 'approve_user':
                $link = PA::getHomeURL().'update/approve/'.$id;
                break;
            case 'disapprove_user':
                $link = PA::getHomeURL().'update/disapprove/'.$id;
                break;

            //OFFER ADMINISTARTION
            case 'offer_edit':
                $link = PA::getHomeURL().'offers/edit/'.$id;
                break;
            case 'offer_view':
                $link = PA::getHomeURL().'offers/view/'.$id;
                break;
            case 'offer_delete':
                $link = PA::getHomeURL().'update/delete/offer/'.$id;
                break;
        }
        return $link;
    }

    public static function adminGetCSS()
    {
        $path_to_css = Config::get('PATH_VIEW').'admin/style.css';
        $css_as_string = file_get_contents($path_to_css);
        // Remove comments
        $css_as_string = preg_replace('!/\*[^*]*\*+([^/][^*]*\*+)*/!', '', $css_as_string);
        // Remove space after colons
        $css_as_string = str_replace(': ', ':', $css_as_string);

        $img_path = Config::get('PATH_VIEW').'admin/';

        $css_as_string = str_replace('[adminimg]', $img_path, $css_as_string);

        // Remove whitespace
        $css_as_string = str_replace(array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '),
                                     ' ', $css_as_string);
        return '
        <style>'.$css_as_string.'</style>';
    }

    public static function adminShowEditMenu($data)
    {
        if (!PA::isAdmin()) { return false; }
        elseif (PA::isAdmin()) {
            echo '<div id="admin_edit_menu">';

            $featuredimg = 'icn_featured.png';
            $featured = false;
            
            $other_featuredimg = 'icn_other_featured.png';
            $other_featured = false;

            if (PA::isProfilePage()) {
                $details = $data;
                $edit_id = $details->id;
                $edit_type = 'editUser';
                if ($details->admin_featured == 1) {
                    $featuredimg = 'icn_featured_ok.png';
                    $featured = true;
                }
                if ($details->other_featured == 1) {
                    $other_featuredimg = 'icn_other_featured_ok.png';
                    $other_featured = true;
                }
            } elseif (PA::isOfferPage()) {
                $details = $data['profile'];
                $offer = $data['offer'];
                $edit_id = $offer->id;
                $edit_type = 'editOffer';
                if ($offer->admin_featured == 1) {
                    $featuredimg = 'icn_featured_ok.png';
                    $featured = true;
                }
            } elseif (PA::isPage()) {
                $page = $data['page'];
                $edit_id = $page->id;
                $edit_type = 'editPage';
            }

            if (PA::isEditable()) {

                //FEATURE PAGE OR OFFER
                if (PA::isOfferPage()) {
                    $edit_text = Text::get('ADMIN_EDIT_MENU_EDIT_OFFER');
                    $feature_link = PA::getlink('feature_offer_admin',$edit_id);
                    if ($featured == true) {
                        $feature_text = Text::get('ADMIN_EDIT_MENU_UNFEATURE_OFFER');
                    } else {
                        $feature_text = Text::get('ADMIN_EDIT_MENU_FEATURE_OFFER');
                    }
                    $delete_text = Text::get('ADMIN_EDIT_MENU_DELETE_OFFER');
                    $delete_link = PA::getLink('delete_offer',$edit_id);
                } elseif (PA::isProfilePage()) {
                    $edit_text = Text::get('ADMIN_EDIT_MENU_EDIT_PROFILE');
                    $feature_link = PA::getlink('feature_profile',$edit_id);
                    $other_feature_link = PA::getlink('other_feature_profile',$edit_id);
                    if ($featured == true) {
                        $feature_text = Text::get('ADMIN_EDIT_MENU_UNFEATURE_PROFILE');
                    } else {
                        $feature_text = Text::get('ADMIN_EDIT_MENU_FEATURE_PROFILE');
                    }
                    
                    if ($other_featured == true) {
                        $other_feature_text = Text::get('ADMIN_EDIT_MENU_OTHER_UNFEATURE_PROFILE');
                    } else {
                        $other_feature_text = Text::get('ADMIN_EDIT_MENU_OTHER_FEATURE_PROFILE');
                    }
                    $delete_text = Text::get('ADMIN_EDIT_MENU_DELETE_PROFILE');
                    $delete_link = PA::getLink('delete_profile',$edit_id);
                }
                $edit_link = PA::getEditLink($edit_type,$edit_id);

                echo '
                <ul class="menu">
                    <li>
                        <a href="'.$feature_link.'">
                            <img src="'.PA::getThemeURL().'img/'.$featuredimg.'" class="menuhead_img" alt="'.$feature_text.'">
                        </a>
                        <ul>
                            <li>
                                <a href="'.$feature_link.'">
                                    '.$feature_text.'
                                </a>
                            </li>
                        </ul>
                    </li>
                </ul>';
                
                echo '
                <ul class="menu">
                    <li>
                        <a href="'.$other_feature_link.'">
                            <img src="'.PA::getThemeURL().'img/'.$other_featuredimg.'" class="menuhead_img" alt="'.$other_feature_text.'">
                        </a>
                        <ul>
                            <li>
                                <a href="'.$other_feature_link.'">
                                    '.$other_feature_text.'
                                </a>
                            </li>
                        </ul>
                    </li>
                </ul>';

                //EDIT PAGE
                echo '
                <ul class="menu">
                    <li>
                        <a href="'.$edit_link.'">
                            <img src="'.PA::getThemeURL().'img/icn_edit.png" class="menuhead_img" alt="'.$edit_text.'">
                        </a>
                        <ul>
                            <li><a href="'.$edit_link.'">'.$edit_text.'</a></li>
                        </ul>
                    </li>
                </ul>';
            }

            //NEW OFFER FOR USER
            if (PA::isProfilePage()) {
                $new_offer_link = PA::adminGetLink('new_offer',$edit_id);
                $new_offer_text = Text::get('ADMIN_EDIT_MENU_NEW_OFFER');
                echo '
                    <ul class="menu">
                        <li>
                            <a href="'.$new_offer_link.'">
                                <img src="'.PA::getThemeURL().'img/icn_new_offer.png" class="menuhead_img" alt="'.$new_offer_text.'">
                            </a>
                            <ul>
                                <li><a href="'.$new_offer_link.'">'.$new_offer_text.'</a></li>
                            </ul>
                        </li>
                    </ul>';
            }

            //DELETE PROFILE/OFFER
            echo '
                <ul class="menu">
                    <li>
                        <a href="'.$delete_link.'" class="delete_button">
                            <img src="'.PA::getThemeURL().'img/icn_delete.png" class="menuhead_img" alt="'.$delete_text.'">
                        </a>
                        <ul>
                            <li><a href="'.$delete_link.'" class="delete_button">'.$delete_text.'</a></li>
                        </ul>
                    </li>
                </ul>
                <div class="clear"></div>
            </div>';
        }
    }

    public static function adminShowUserList($users)
    {
        echo '
        <table id="admin_users_table">
            <tr>
                <th class="admin_users_table_td1">'.AdminText::get('USERS_NAME').'</th>
                <th class="admin_users_table_td2">'.AdminText::get('USERS_REGISTER_DATE').'</th>
                <th class="admin_users_table_td3">'.AdminText::get('USERS_LASTLOGIN_DATE').'</th>
                <th class="admin_users_table_td42">
                    <div class="admin_table_button admin_button_offers">
                        <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAntJREFUeNrsmFuITVEYx/eZM2hKSpKRGS/EeGByotOgkSjl8kaJB08e3J6nqZmmNA8eXBKaRErut0jxKjSlhIk0kTeTW1JKDHPG8Vv6Tn3tyNqX9rSn76tfZ31773X57/Wt9a2zC9VqNRgPVheMEzMhJsSEmBATYkJMiAkxIX9sLnTByjQbLWR8+i3ALdgAr2A5fMrjjOwQEc7mwfw8zsh0GIRp4g/AMvietxnpVCKc9aQlIssZaYMHUBT/MmzJ22KfAA+hJL5b3K3wNm/b7zYlwtmhtEVEnZEzMNnz2dtwGmbBY5gh159DWdbGTljzn3a+wnavHp0QT4ar/rZV6nSoa7+gXa63wohHO8O+44sSWoUIz86U36fuXUn5ItyXWT0L9Wn2GSW0VsEi6FUhdhxuhtaa6/wdPBN/KTTBHfgBU2AFVHRgSJbvEX8E9kE/3E07tGrsVlPfH6P+v7iu2j0QtX6cDhvgpep0c+j+YngNm8Q/Ao9gEjTDIOwK1SlDRdr7DI1RxxVn+3U7zlHld8NE5bfAHLXlupBZIuHYLPfLoTa7VbI8Bu+zyiOX4KOUF8J6da+i4jyQdVFbB6NS/qmeb1f13Us6mWVCdNn5sPL3Jshle1T5PLzJOrP3wZDa0dZKuaiOJs4a/tJfLRQXwEYpf4P9sUeTcKfpDO1gdTAbrkKbPOMW9gkowlS4AOvk3jlVvy/JWJIKaYIvajCrI9RtUdl9FEpJxlIfJLMhCbEO8Q/CPc+6JZXdb8CTsT7GuwPhi9CfpihWkew/MNbH+A9yjopr15KKCDwPbj52SuWNqHYlj5+D7EujCTEhJsSEmBATYkJMSA7ttwADANRGjTnzjPlwAAAAAElFTkSuQmCC">
                    </div>
                </th><th class="admin_users_table_td4">
                    <div class="admin_table_button admin_button_offers">
                        <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAttJREFUeNrsmc9LFVEUx+eZZb+o8EU/sCxDQdHoWVCEuXChRQuDiCKC2rlwEVjoH+BagqhVLSKIoLIkCNoUKRT0EPpNJeLCoKQSgrQIE6fvgRM8hnNn5s7c133EPfBZvPPm3nnfO+eec+68jO/73v9gGSfECXFCnBAnxAlJYWWG51sMToPHYBrMA1qpn2AcXAINRVFCT8QQnWDKj7YFcAusMnhvY0LOgHlfzybAOlNCTOyRTnAblCcY+xS0gAXbm30ZGAObU8xxAly3LeQsGBD8c2CYRdKGrwZtoFK49hnYZVtIHuwO5g9wFUwG/MtBF1gd8JPQFSzeSvrNgjrB/04Q4XEKzgt+2ltNNuvIJrBGIURl0wr/RptC1lNoCv4vIWOWKvw/0gopTzGWbv5W8M+EjGlQzDNpU8gLcFPxVCSrVwgZi3iKRQ8tWsmPMa/dBg5LHRK4ayK00jaN+RjX1ILj3FAGbRQMlUL3+wZ8CPmeCuExRQh/Bld4DutCKDQGwXfhu5XgqEIEJYTL3Jr4pSDEYxG0sl8D/nau2EH7BS6Ac4oFsH5CpD3QCvZw1e8RFopu1gfOg9+ldrAqC3xeAnoVZ5CLEWMTk6aOZLhrbeNa8ID7qTlu7z2hOewvaCDbuVd7CJ7bKogV4EhB07gTNPIPeil0uH8LKN3vAGjmOcgO8TxDacItyR6h1T4Z0eh1gL0B33twI2QMpfFrSdt5XSGLwCmuD2GWE1r8T+BJxLjxpClZV8hB4SBl2kbAo2LWkZp/IMLjFF5VrCdCgrvBWo256YXEDq4vE+C1RshM8cs837SQZs4ucS3Hr4kKW3wSckdjjkGdPixOaGX43ZNOSt8vnFO2gy0a8+wzvUeqNUMqG3Kk1Yn9DfxewJiQRs19NxsS2zOaczWZFLI1wcnxleD/xkVRx2pMtijZBCn0HvdduYKsdT9BCxI7pN0/Vk6IE+KEOCFOiBMC+yPAAD+0qEzOrxdPAAAAAElFTkSuQmCC">
                    </div>
                </th>
                <th class="admin_users_table_td5">
                    <div class="admin_table_button admin_button_new_offer">
                        <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAlNJREFUeNrsmUsoRUEYxx3ksdBVuBuFDRvJrWsla/JYWFmyIisWrGQlS+VaKGUjsbAjkaxQFspzoyiUR0ld180zcY//1CxupzmaOeebc+s2//ptpjlz5n+a+eab71i2bedkg3JzskTGiDFijBgjxogx4kf5xOMVgBbQDqKgCoSABV7BPTgG22AHvJO9maUoBJSCfnBqy+sCjIAKijlQmOjkk/KqW9CbaSPjNp1ioDATRuZseq2CvCCNjNv6FPMyJ8vDfYRFpE2JfpdgKD2ugAYwJfHsAJjXGbVC4Ebyyx4Inm+SfDYBKlXmpnog9oAaH4dtseSzpWBQ18leCIYDPKzZ8irXYaQZ1AdoJAw6dRjpUpxIEUFuJ/1OlVwr+k90SvJ8Kl3ngr6s36Eo5oBavjfSVacjal27RJhWonxtTTD2nY6oVaJ5T9g+opySEUuxXVW+xlEx8ubS/kVk5NfP2Cqb/QFUC9qbQErwddlF6sTRzi5ZjS7LKCxoS+gwcsTPEqfccqczEHG0RfjNUFZXOpbWluJS+RG0pRTH2NJhZBfc+IxCKmJnzroOI6xQMBtgirLI96WWctACeAzAxAeY1lnXioNRyb4pH+F0UnEZe7ohMs04bn8ivYA9x54p43Wv/7QM+lzOFXIjrBC3ArqJl9Q+aPNSuPNaMv3mt8UYoYklXg/wVn0kyFoHwJOPqkkSjAEr05VGRhWYAA8KBuK89FNLMQeL+Pd0mC+PDn5RKuepOMu9PsEzTztYEXsD3FG92DL/2Y0RY8QYMUaMEWMki4z8CTAAE8027VDVa2oAAAAASUVORK5CYII=">
                    </div>
                </th>
                <th class="admin_users_table_td6">
                    <div class="admin_table_button admin_button_edit">
                        <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAwRJREFUeNrsmE9IFFEcx11bKTEsoqJISQxNE8oOKQQWdIqgQOgSHfp3MKJDERS1FQWSYHUIgiQIyg5CHgokKENJkywPZhld+mNSh7SygrWo1Onz6LcwPGbWnXVnR+T94MPsvH+z35n3+73feyHLsjJmgmVmzBAzQowQI8QIMUKMECMkxULy4CF0QzNkpVNIOIVjVcNG2/0l6JruX6QKIlAo9xVwRGtTJ19J2To4Dct8U6KyX49UwRfrv/2A5/DbcjbV7gWMy/0zKEzimZPitUMmPLKmZvV+CPE6tSbgsvqQSU6AUbjpx8wKJbGxmgeDctXtA0RhISxyqO+Byuni7GsgRysbgu2wCsqgFA7DuNauABYH7ew5sA3eaXN+Ara69Klz8JF2WA9ZQTl7n4vzPonTZwEMu/S7EpSzF7mU98fpMwLvXeoKgvKRny7ly+P0yYYlHsfz3UfK4AyMalNELYZrXfrUOEypATgAeUEuiIqdtpU6Zr2amFmwGUa0dioTWO0wZlhW/Ox0CpkL3xze9Bh0QbOkJU7W7TLmXvgF59IpZAP8TTI9+QxLZZwdIvwiDEm9mrYX4AEchJCfuVbbFHOtWhmrYZJ29+R5vuRaKp9pkpwrZtEE8quYfYX78rvXVq42ZEfhtq3sqfaclKfxij3QBFsk+uyC79obfQObIB92wy2olP6HbBlCuwSH2Nh3bdMw4qePuFGrCal2aTdfa3dSqz+m1addSAm8gtfixNni2MVwHMphhS2Ev5Q/2iOpjCqfDZ1SPgj7gxASCwZh+a2EnJewasm1A3Klfp/trb+F61o+d8rv8JsoZyEqi2crfJKw3Sr1NyaJWl2a78QlnOGPqU3XStm31MBVKIY+yIcSaIQxeCwHF6Wyr1GHGuXQ4SVq+SVkji1ZHJDrR/gj4tQOsk1QNgwNUA/X0nWKkigRmSLK+U/AHbnvdGmf62UlT6ePFEGjNu/7JXqFUv28ZA4fvFiFHOKp/XyLbLRapsspijmNN0KMECPECDFCjBAjxGf7J8AA1yBq1Xbt28kAAAAASUVORK5CYII=">
                    </div>
                </th>
                <th class="admin_users_table_td7">
                    <div class="admin_table_button admin_button_preview">
                        <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAsFJREFUeNrsl0tIVUEYgL3XwjKxXBhBCpHVokWWKRHRJgIp6bnQoBbVXYZQG1u4KKKoFkVhbSKCHrYKBKOgTS3TyMAiei2iB/QwNDIf2b339E38B36Gi+mJU5f6Bz5G58yZ+b9zz/wzJxEEQcG/UBImYiImYiImYiImYiImYiIm8t+JBJmM31QJK2EpVEEZJGEQXkEvdMGTnwEUFuaVyFTYBClYDTN+cZu7qQeuQDsy/fkgspHqANR4l8ZgAIYgC8UwS2pdXsNJOIfQyB8XQWA+VRusV8190Akd8sSdSAkUyavlXrEl0ABbYaG69xHsReZ2tIAQmSzZdHoNfIBAGICDMAcKhGq4Bm+hD3pgj7o+HXbBCzVOGlJRYooisQW+qslvwiIVoGMnfFN9NJ0wTfUtg1MiEfZpjVWECTZDViZz9T5PwLF4HImQM2F/NfY6+KT67I9FhIFXwBeZZBCapN2nTQXzHhqhFtpV+zBUahEZa5n3ym6LQ+SemuCQavfpVv1Sqr3Ue+INvoiM16h+9ZcTjS85ibxwWNKoK02StXIVvcMNqb+/y/4Rlik5MqGLZ7fLptJ0NpasxRNqUU/0OVTl+EUuqD4uI62CCjih2sdggbdGEnBe9elwbXFmLR3oM1juidRBxlvcw97/l/Ripy72xn0K5bGmX5n4tJp0FJo9mZZxMtZdWS9h3xrZY8LrD90vGPs+omSOegHekuwUBlgPXTAii9dtjMehSK7PdPuFZMBwjN4oEo7fOmuxOHdQHYO50pSG63AVuuEjzJYjSr9cr4Z62A7z1HAX5Yjy+W8dGl2gRyTbJL0T7ht4JxmrXI74Jd4Q7ljfisCNfPkeqXVPFDZA6QRuve9OvHAZidF8/LByr9laqIMKkUrKnuJetcdwBx642/Pmw8q+2U3EREzEREzEREzEREzEREwkYvkhwAD4ho8lKnZL5AAAAABJRU5ErkJggg==">
                    </div>
                </th>
                <th class="admin_users_table_td8">
                    <div class="admin_table_button admin_button_delete">
                        <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAbZJREFUeNrsmE1KAzEYhiftWBUrqCAURRAvIXgDEcWtC7cqLt14AcG9Sw8gLl0KnsGtK6GrgpTWH9BarTa+wSximGFoTMaxvIGH0sxP5pl8mSSfkFJGw1BK0ZAUilCEIhShCEWKKLIB3kDbogf2QzQoHJYoY6ACki7sg1lwDpZTrr8Fm6AOyknPBN5BN7TIMdgFnZTjM2A84x6qt1opxybAKTgc5KFih16cNnAto2A+o40otMirDqGXQOOrOmhYuYbWlG4s1PpfjZFn8BhapJAldrxuBJyBGvjwOBWokNoC93mJqEZXwJznF9vVH4LcJsRQ8Shd7+1zZv8EV6Bh1d+Aa6tOhc6ly9cp/RVgsDtQAQ35s1zoY6tGXQ8sgipoGvU7+twT6x4dUHN5Jp890ta/LWsGf9KfU3PeaSac+y9WvyLjP5fxFKEIRShCEYpQ5A9EZOhtgE+ROGGzVjIoWzvM32zsvO0Qk8oa2APrRp3Kbx3pRMKCUX8AJsG2t1WpY/JBZRrrAba6KtW0BO7yCi0RcDyJPENLdeND9J3f8plFUWnYfp6hxXmEIhShCEUoQpEili8BBgAwzfiS5i1EyAAAAABJRU5ErkJggg==">
                    </div>
                </th>
            </tr>';

        foreach($users as $user)
        {

            // NAME
            if (!$user->company_name) {
                $user_name = '['.$user->user_name.']';
            } else {
                $user_name = $user->company_name;
            }

            // DATES
            if (!$user->user_last_login_timestamp) {
                $user_login_date = '[x]';
            } else {
                $user_login_date = date('d.m.Y',$user->user_last_login_timestamp);
            }
            $user_register_date = date('d.m.Y',$user->user_creation_timestamp);

            // Status
            if ($user->user_active == 0) {
                $user_status = '<span class="status_red">&bull;</span>';
            } else {
                $user_status = '<span class="status_green">&bull;</span>';
            }

            echo '
            <tr>
                <td class="admin_users_table_td1">'.$user_status.' '.$user_name.'<br>&nbsp; &nbsp;<a href="mailto: '.$user->user_email.'">'.$user->user_email.'</a></td>
                <td class="admin_users_table_td2">'.$user_register_date.'</td>
                <td class="admin_users_table_td3">'.$user_login_date.'</td>
                <td class="admin_users_table_td4" title="'.AdminText::get('USERS_BUTTON_OFFERS').'">'.$user->offers_number.'/'.$user->request_number.'</div></td>
                <td class="admin_users_table_td5">';
                if ($user->user_approved == 1) {
                    echo '
                    <a href="'.PA::adminGetLink('disapprove_user',$user->id).'" title="'.AdminText::get('USERS_BUTTON_USER_DISAPPROVE').'">
                        <div class="admin_table_button admin_button_new_offer">
                            <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAfhJREFUeNrsmc1qAjEUhbWL0mU33fYJ+hwuRGQQEbEiIl3OSqaDzEKwIiJSitiHKPSJuu0TdFf6m96hkQ7tOHOS3KiVHDgrkzDfmJzcZIpCiMI+6KCwJ3IgDsSBOBAH8m9AAnLJwrMsyb5273hnV3AovvVMLiv2zfJC/MjXGUMHYqUXcoUB4lr8lW8LJBTpimGqBhBzsV4+N0goshXDeBoQU5EvGAZZ7Cc5vx+S78l1haU5IQ9y2rySH7kX+wx4e2/kBjDWCBzLs7XYJ+ADtDLGGIJj1GymVuwx+CDtlL4R2LduO35VpsYHuaMQGCpTkw0EnSIxTI8cgBBNk/3IZCOLQBikTct0YzXdlQfCTL+n4NZA0Pm/DqLLVa9xFX2BBkSPsehkA4ndV4C44IRASxRUT+RP8Ax0zH6aYXojHTChkgp3bWq1NSBWinYFpCk3MxMNtw3SACGQf2u0LZA6CNGXCYXATDYN4oEQQaJPD4SZbgqkKo+2OonUBWHmtkEqIMSAIaZvbIGUQQgkTlvg1Fxwg5TkhRxnjKKxveQsUc7IRzltrqRR3ZHPye857R64S5SsUn1sEJtZMe6LDV2ZGme/dC0Fxrcdv0mYGWPR5yXCROsSu6jxnT2Ut4+XzIV4lXxKvtXprAPivlg5EAfiQByIA9k7kC8BBgCKs4YFhJC+fgAAAABJRU5ErkJggg==">
                        </div>
                    </a>';
                } else {
                    echo '
                    <a href="'.PA::adminGetLink('approve_user',$user->id).'" title="'.AdminText::get('USERS_BUTTON_USER_APPROVE').'">
                        <div class="admin_table_button admin_button_new_offer">
                            <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAbhJREFUeNrsmbFKA0EQhpMjhCBi4VNYXiEWFiJiESGIpAhW2qSwEBEMCOlstLISC7EIFiJqkUKs1MLCh7FKREWD6PmvKGxxXGZn9/ZimIGvSXY2+2U3ezMkH0VRbhgiyA1JiIiIiIiIiIiIiIiIpBMjYPy/i5TAFbjjygQDItEGcyDkymQtUgSXoKy9xpLJUqQAzkAl5j1jmSBDiVNQTRgT/u7WwIqoz2yBWp9xXbBNnlW1uh4JQCvqH09gymRu3xJHBIlnMG06P2dBk2CCkXdAlJjhfFEciQ54BKFB3j5B4hXMcnecI/EXHeIR2CNIvIF5m6PLldCPQtICdogSZdvfoI2EvpDFmLwmQaIHKi4uE8qgG8KCPsCyltMgSiy5uhUpg8bAA2Fhn6AONojiVZfXO3XgKLiP3ISSqLl+TlFLlBewAG4ty5MvsAounBc+huYlcM3cCXX0VtKqHDhJRdBmSNTTLIG4iQVwbiCylnYtZ5OsZE4IEus+ilIXFe1xgsSmr+raVXl+GCPR8NnruJxMr3Cbnhu2n97ZVWyBd9ADu77757z8qysiIiIiIiIiIiIiIpJafAswAObe2SRr3ERmAAAAAElFTkSuQmCC">
                        </div>
                    </a>';
                }
                echo '
                </td>
                <td class="admin_users_table_td5">';
                if ($user->profile_id != '') {
                    echo '
                    <a href="'.PA::adminGetLink('new_offer',$user->profile_id).'" title="'.AdminText::get('USERS_BUTTON_NEW_OFFER').'">
                        <div class="admin_table_button admin_button_new_offer">
                            <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAlNJREFUeNrsmUsoRUEYxx3ksdBVuBuFDRvJrWsla/JYWFmyIisWrGQlS+VaKGUjsbAjkaxQFspzoyiUR0ld180zcY//1CxupzmaOeebc+s2//ptpjlz5n+a+eab71i2bedkg3JzskTGiDFijBgjxogx4kf5xOMVgBbQDqKgCoSABV7BPTgG22AHvJO9maUoBJSCfnBqy+sCjIAKijlQmOjkk/KqW9CbaSPjNp1ioDATRuZseq2CvCCNjNv6FPMyJ8vDfYRFpE2JfpdgKD2ugAYwJfHsAJjXGbVC4Ebyyx4Inm+SfDYBKlXmpnog9oAaH4dtseSzpWBQ18leCIYDPKzZ8irXYaQZ1AdoJAw6dRjpUpxIEUFuJ/1OlVwr+k90SvJ8Kl3ngr6s36Eo5oBavjfSVacjal27RJhWonxtTTD2nY6oVaJ5T9g+opySEUuxXVW+xlEx8ubS/kVk5NfP2Cqb/QFUC9qbQErwddlF6sTRzi5ZjS7LKCxoS+gwcsTPEqfccqczEHG0RfjNUFZXOpbWluJS+RG0pRTH2NJhZBfc+IxCKmJnzroOI6xQMBtgirLI96WWctACeAzAxAeY1lnXioNRyb4pH+F0UnEZe7ohMs04bn8ivYA9x54p43Wv/7QM+lzOFXIjrBC3ArqJl9Q+aPNSuPNaMv3mt8UYoYklXg/wVn0kyFoHwJOPqkkSjAEr05VGRhWYAA8KBuK89FNLMQeL+Pd0mC+PDn5RKuepOMu9PsEzTztYEXsD3FG92DL/2Y0RY8QYMUaMEWMki4z8CTAAE8027VDVa2oAAAAASUVORK5CYII=">
                        </div>
                    </a>';
                }
                echo '
                </td>
                <td class="admin_users_table_td6">';
                if ($user->profile_id != '') {
                    echo '
                    <a href="'.PA::adminGetLink('user_edit',$user->profile_id).'" title="'.AdminText::get('USERS_BUTTON_USER_EDIT').'">
                        <div class="admin_table_button admin_button_edit">
                            <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAwRJREFUeNrsmE9IFFEcx11bKTEsoqJISQxNE8oOKQQWdIqgQOgSHfp3MKJDERS1FQWSYHUIgiQIyg5CHgokKENJkywPZhld+mNSh7SygrWo1Onz6LcwPGbWnXVnR+T94MPsvH+z35n3+73feyHLsjJmgmVmzBAzQowQI8QIMUKMECMkxULy4CF0QzNkpVNIOIVjVcNG2/0l6JruX6QKIlAo9xVwRGtTJ19J2To4Dct8U6KyX49UwRfrv/2A5/DbcjbV7gWMy/0zKEzimZPitUMmPLKmZvV+CPE6tSbgsvqQSU6AUbjpx8wKJbGxmgeDctXtA0RhISxyqO+Byuni7GsgRysbgu2wCsqgFA7DuNauABYH7ew5sA3eaXN+Ara69Klz8JF2WA9ZQTl7n4vzPonTZwEMu/S7EpSzF7mU98fpMwLvXeoKgvKRny7ly+P0yYYlHsfz3UfK4AyMalNELYZrXfrUOEypATgAeUEuiIqdtpU6Zr2amFmwGUa0dioTWO0wZlhW/Ox0CpkL3xze9Bh0QbOkJU7W7TLmXvgF59IpZAP8TTI9+QxLZZwdIvwiDEm9mrYX4AEchJCfuVbbFHOtWhmrYZJ29+R5vuRaKp9pkpwrZtEE8quYfYX78rvXVq42ZEfhtq3sqfaclKfxij3QBFsk+uyC79obfQObIB92wy2olP6HbBlCuwSH2Nh3bdMw4qePuFGrCal2aTdfa3dSqz+m1addSAm8gtfixNni2MVwHMphhS2Ev5Q/2iOpjCqfDZ1SPgj7gxASCwZh+a2EnJewasm1A3Klfp/trb+F61o+d8rv8JsoZyEqi2crfJKw3Sr1NyaJWl2a78QlnOGPqU3XStm31MBVKIY+yIcSaIQxeCwHF6Wyr1GHGuXQ4SVq+SVkji1ZHJDrR/gj4tQOsk1QNgwNUA/X0nWKkigRmSLK+U/AHbnvdGmf62UlT6ePFEGjNu/7JXqFUv28ZA4fvFiFHOKp/XyLbLRapsspijmNN0KMECPECDFCjBAjxGf7J8AA1yBq1Xbt28kAAAAASUVORK5CYII=">
                        </div>
                    </a>';
                }
                echo '
                </td>
            <td class="admin_users_table_td7">';
                if ($user->user_active != 0 && $user->profile_id != '' && $user->company_name != '') {
                    echo '
                    <a href="'.PA::adminGetLink('user_view',$user->profile_id).'" title="'.AdminText::get('USERS_BUTTON_USER_VIEW').'">
                        <div class="admin_table_button admin_button_preview">
                            <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAsFJREFUeNrsl0tIVUEYgL3XwjKxXBhBCpHVokWWKRHRJgIp6bnQoBbVXYZQG1u4KKKoFkVhbSKCHrYKBKOgTS3TyMAiei2iB/QwNDIf2b339E38B36Gi+mJU5f6Bz5G58yZ+b9zz/wzJxEEQcG/UBImYiImYiImYiImYiImYiIm8t+JBJmM31QJK2EpVEEZJGEQXkEvdMGTnwEUFuaVyFTYBClYDTN+cZu7qQeuQDsy/fkgspHqANR4l8ZgAIYgC8UwS2pdXsNJOIfQyB8XQWA+VRusV8190Akd8sSdSAkUyavlXrEl0ABbYaG69xHsReZ2tIAQmSzZdHoNfIBAGICDMAcKhGq4Bm+hD3pgj7o+HXbBCzVOGlJRYooisQW+qslvwiIVoGMnfFN9NJ0wTfUtg1MiEfZpjVWECTZDViZz9T5PwLF4HImQM2F/NfY6+KT67I9FhIFXwBeZZBCapN2nTQXzHhqhFtpV+zBUahEZa5n3ym6LQ+SemuCQavfpVv1Sqr3Ue+INvoiM16h+9ZcTjS85ibxwWNKoK02StXIVvcMNqb+/y/4Rlik5MqGLZ7fLptJ0NpasxRNqUU/0OVTl+EUuqD4uI62CCjih2sdggbdGEnBe9elwbXFmLR3oM1juidRBxlvcw97/l/Ripy72xn0K5bGmX5n4tJp0FJo9mZZxMtZdWS9h3xrZY8LrD90vGPs+omSOegHekuwUBlgPXTAii9dtjMehSK7PdPuFZMBwjN4oEo7fOmuxOHdQHYO50pSG63AVuuEjzJYjSr9cr4Z62A7z1HAX5Yjy+W8dGl2gRyTbJL0T7ht4JxmrXI74Jd4Q7ljfisCNfPkeqXVPFDZA6QRuve9OvHAZidF8/LByr9laqIMKkUrKnuJetcdwBx642/Pmw8q+2U3EREzEREzEREzEREzEREwkYvkhwAD4ho8lKnZL5AAAAABJRU5ErkJggg==">
                        </div>
                    </a>';
                }
                if ($user->profile_id != '') {
                    $deleteLink = PA::adminGetLink('user_delete_profile',$user->profile_id);
                } else {
                    $deleteLink = PA::adminGetLink('user_delete',$user->id);
                }
                echo '
                </td>
                <td class="admin_users_table_td8">
                    <a href="'.$deleteLink.'" title="'.AdminText::get('USERS_BUTTON_USER_DELETE').'" class="delete_button">
                        <div class="admin_table_button admin_button_delete">
                            <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAbZJREFUeNrsmE1KAzEYhiftWBUrqCAURRAvIXgDEcWtC7cqLt14AcG9Sw8gLl0KnsGtK6GrgpTWH9BarTa+wSximGFoTMaxvIGH0sxP5pl8mSSfkFJGw1BK0ZAUilCEIhShCEWKKLIB3kDbogf2QzQoHJYoY6ACki7sg1lwDpZTrr8Fm6AOyknPBN5BN7TIMdgFnZTjM2A84x6qt1opxybAKTgc5KFih16cNnAto2A+o40otMirDqGXQOOrOmhYuYbWlG4s1PpfjZFn8BhapJAldrxuBJyBGvjwOBWokNoC93mJqEZXwJznF9vVH4LcJsRQ8Shd7+1zZv8EV6Bh1d+Aa6tOhc6ly9cp/RVgsDtQAQ35s1zoY6tGXQ8sgipoGvU7+twT6x4dUHN5Jp890ta/LWsGf9KfU3PeaSac+y9WvyLjP5fxFKEIRShCEYpQ5A9EZOhtgE+ROGGzVjIoWzvM32zsvO0Qk8oa2APrRp3Kbx3pRMKCUX8AJsG2t1WpY/JBZRrrAba6KtW0BO7yCi0RcDyJPENLdeND9J3f8plFUWnYfp6hxXmEIhShCEUoQpEili8BBgAwzfiS5i1EyAAAAABJRU5ErkJggg==">
                        </div>
                    </a>
                </td>
            </tr>';
        }
        echo '
        </table>';
    }

    public static function adminShowOfferList($offers)
    {
        $offers = $offers['offers'];

        echo '
        <table id="admin_offers_table">
            <tr>
                <th class="offer_location_what offer_location_kind admin_offers_table_td1" title="'.AdminText::get('OFFERS_KINDOFOFFER').'"></th>
                <th class="admin_offers_table_td2">'.AdminText::get('OFFERS_USERNAME').'</th>
                <th class="admin_offers_table_td3">'.AdminText::get('OFFERS_OFFER').'</th>
                <th class="admin_offers_table_td4">'.AdminText::get('OFFERS_OFFER_DATE').'</th>
                <th class="admin_offers_table_td5">'.AdminText::get('OFFERS_OFFER_CHANGE_DATE').'</th>
                <th class="admin_offers_table_td6">
                    <div class="admin_table_button admin_button_edit">
                        <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAwRJREFUeNrsmE9IFFEcx11bKTEsoqJISQxNE8oOKQQWdIqgQOgSHfp3MKJDERS1FQWSYHUIgiQIyg5CHgokKENJkywPZhld+mNSh7SygrWo1Onz6LcwPGbWnXVnR+T94MPsvH+z35n3+73feyHLsjJmgmVmzBAzQowQI8QIMUKMECMkxULy4CF0QzNkpVNIOIVjVcNG2/0l6JruX6QKIlAo9xVwRGtTJ19J2To4Dct8U6KyX49UwRfrv/2A5/DbcjbV7gWMy/0zKEzimZPitUMmPLKmZvV+CPE6tSbgsvqQSU6AUbjpx8wKJbGxmgeDctXtA0RhISxyqO+Byuni7GsgRysbgu2wCsqgFA7DuNauABYH7ew5sA3eaXN+Ara69Klz8JF2WA9ZQTl7n4vzPonTZwEMu/S7EpSzF7mU98fpMwLvXeoKgvKRny7ly+P0yYYlHsfz3UfK4AyMalNELYZrXfrUOEypATgAeUEuiIqdtpU6Zr2amFmwGUa0dioTWO0wZlhW/Ox0CpkL3xze9Bh0QbOkJU7W7TLmXvgF59IpZAP8TTI9+QxLZZwdIvwiDEm9mrYX4AEchJCfuVbbFHOtWhmrYZJ29+R5vuRaKp9pkpwrZtEE8quYfYX78rvXVq42ZEfhtq3sqfaclKfxij3QBFsk+uyC79obfQObIB92wy2olP6HbBlCuwSH2Nh3bdMw4qePuFGrCal2aTdfa3dSqz+m1addSAm8gtfixNni2MVwHMphhS2Ev5Q/2iOpjCqfDZ1SPgj7gxASCwZh+a2EnJewasm1A3Klfp/trb+F61o+d8rv8JsoZyEqi2crfJKw3Sr1NyaJWl2a78QlnOGPqU3XStm31MBVKIY+yIcSaIQxeCwHF6Wyr1GHGuXQ4SVq+SVkji1ZHJDrR/gj4tQOsk1QNgwNUA/X0nWKkigRmSLK+U/AHbnvdGmf62UlT6ePFEGjNu/7JXqFUv28ZA4fvFiFHOKp/XyLbLRapsspijmNN0KMECPECDFCjBAjxGf7J8AA1yBq1Xbt28kAAAAASUVORK5CYII=">
                    </div>
                </th>
                <th class="admin_offers_table_td7">
                    <div class="admin_table_button admin_button_preview">
                        <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAsFJREFUeNrsl0tIVUEYgL3XwjKxXBhBCpHVokWWKRHRJgIp6bnQoBbVXYZQG1u4KKKoFkVhbSKCHrYKBKOgTS3TyMAiei2iB/QwNDIf2b339E38B36Gi+mJU5f6Bz5G58yZ+b9zz/wzJxEEQcG/UBImYiImYiImYiImYiImYiIm8t+JBJmM31QJK2EpVEEZJGEQXkEvdMGTnwEUFuaVyFTYBClYDTN+cZu7qQeuQDsy/fkgspHqANR4l8ZgAIYgC8UwS2pdXsNJOIfQyB8XQWA+VRusV8190Akd8sSdSAkUyavlXrEl0ABbYaG69xHsReZ2tIAQmSzZdHoNfIBAGICDMAcKhGq4Bm+hD3pgj7o+HXbBCzVOGlJRYooisQW+qslvwiIVoGMnfFN9NJ0wTfUtg1MiEfZpjVWECTZDViZz9T5PwLF4HImQM2F/NfY6+KT67I9FhIFXwBeZZBCapN2nTQXzHhqhFtpV+zBUahEZa5n3ym6LQ+SemuCQavfpVv1Sqr3Ue+INvoiM16h+9ZcTjS85ibxwWNKoK02StXIVvcMNqb+/y/4Rlik5MqGLZ7fLptJ0NpasxRNqUU/0OVTl+EUuqD4uI62CCjih2sdggbdGEnBe9elwbXFmLR3oM1juidRBxlvcw97/l/Ripy72xn0K5bGmX5n4tJp0FJo9mZZxMtZdWS9h3xrZY8LrD90vGPs+omSOegHekuwUBlgPXTAii9dtjMehSK7PdPuFZMBwjN4oEo7fOmuxOHdQHYO50pSG63AVuuEjzJYjSr9cr4Z62A7z1HAX5Yjy+W8dGl2gRyTbJL0T7ht4JxmrXI74Jd4Q7ljfisCNfPkeqXVPFDZA6QRuve9OvHAZidF8/LByr9laqIMKkUrKnuJetcdwBx642/Pmw8q+2U3EREzEREzEREzEREzEREwkYvkhwAD4ho8lKnZL5AAAAABJRU5ErkJggg=="/>
                    </div>
                </th>
                <th class="admin_offers_table_td8">
                    <div class="admin_table_button admin_button_delete">
                        <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAbZJREFUeNrsmE1KAzEYhiftWBUrqCAURRAvIXgDEcWtC7cqLt14AcG9Sw8gLl0KnsGtK6GrgpTWH9BarTa+wSximGFoTMaxvIGH0sxP5pl8mSSfkFJGw1BK0ZAUilCEIhShCEWKKLIB3kDbogf2QzQoHJYoY6ACki7sg1lwDpZTrr8Fm6AOyknPBN5BN7TIMdgFnZTjM2A84x6qt1opxybAKTgc5KFih16cNnAto2A+o40otMirDqGXQOOrOmhYuYbWlG4s1PpfjZFn8BhapJAldrxuBJyBGvjwOBWokNoC93mJqEZXwJznF9vVH4LcJsRQ8Shd7+1zZv8EV6Bh1d+Aa6tOhc6ly9cp/RVgsDtQAQ35s1zoY6tGXQ8sgipoGvU7+twT6x4dUHN5Jp890ta/LWsGf9KfU3PeaSac+y9WvyLjP5fxFKEIRShCEYpQ5A9EZOhtgE+ROGGzVjIoWzvM32zsvO0Qk8oa2APrRp3Kbx3pRMKCUX8AJsG2t1WpY/JBZRrrAba6KtW0BO7yCi0RcDyJPENLdeND9J3f8plFUWnYfp6hxXmEIhShCEUoQpEili8BBgAwzfiS5i1EyAAAAABJRU5ErkJggg==">
                    </div>
                </th>
            </tr>';

        foreach ($offers as $offer)
        {
            $created = strtotime($offer->created);
            $modified = strtotime($offer->modified);

            // DATES
            $diff = 86400;
            $difference = $modified - $created;

            $offer_date = date('d.m.Y',$created);

            if (!$modified || $difference < $diff)
            {
                $offer_date_modified = '[x]';
            }
            else
            {
                $offer_date_modified =  date('d.m.Y',$modified);
            }

            // Status
            if ($offer->status == 1)
            {
            $offer_status = '<span class="status_red">&bull;</span>';
            }
            elseif ($offer->status == 2)
            {
            $offer_status = '<span class="status_yellow">&bull;</span>';
            }
            elseif ($offer->status == 3)
            {
            $offer_status = '<span class="status_green">&bull;</span>';
            }

            if ($offer->external == 1)
            {
                $offerlist_location_class = 'offer_location_extern';
                $offerlist_location_text = AdminText::get('OFFERS_EXTERN');
                $platform = ConnectionsModel::getPlatformDetailsByID($offer->external_platform_id);
                if (isset($platform->name) && $platform->name != false)
                {
                    $offerlist_user_text = '['.$platform->name.']';
                }
                else
                {
                    $offerlist_user_text = '['.AdminText::get('PLATFORM_DELETED').']';
                }
            }
            else
            {
                $offerlist_location_class = 'offer_location_intern';
                $offerlist_location_text = AdminText::get('OFFERS_INTERN');
                $offerlist_user_text = $offer->company_name;
            }

            echo '
            <tr>
                <td class="offer_location_what '.$offerlist_location_class.' admin_offers_table_td1" title="'.$offerlist_location_text.'"></td>
                <td class="admin_offers_table_td2">'.$offerlist_user_text.'</td>
                <td class="admin_offers_table_td3">'.$offer_status.' '.$offer->title.'</td>
                <td class="admin_offers_table_td4">'.$offer_date.'</td>
                <td class="admin_offers_table_td5">'.$offer_date_modified.'</div></td>
                <td class="admin_offers_table_td6">';
                if ($offer->external == 0)
                {
                    echo '
                    <a href="'.PA::adminGetLink('offer_edit',$offer->id).'" title="'.AdminText::get('OFFERS_BUTTON_EDIT').'">
                        <div class="admin_table_button admin_button_edit">
                        <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAwRJREFUeNrsmE9IFFEcx11bKTEsoqJISQxNE8oOKQQWdIqgQOgSHfp3MKJDERS1FQWSYHUIgiQIyg5CHgokKENJkywPZhld+mNSh7SygrWo1Onz6LcwPGbWnXVnR+T94MPsvH+z35n3+73feyHLsjJmgmVmzBAzQowQI8QIMUKMECMkxULy4CF0QzNkpVNIOIVjVcNG2/0l6JruX6QKIlAo9xVwRGtTJ19J2To4Dct8U6KyX49UwRfrv/2A5/DbcjbV7gWMy/0zKEzimZPitUMmPLKmZvV+CPE6tSbgsvqQSU6AUbjpx8wKJbGxmgeDctXtA0RhISxyqO+Byuni7GsgRysbgu2wCsqgFA7DuNauABYH7ew5sA3eaXN+Ara69Klz8JF2WA9ZQTl7n4vzPonTZwEMu/S7EpSzF7mU98fpMwLvXeoKgvKRny7ly+P0yYYlHsfz3UfK4AyMalNELYZrXfrUOEypATgAeUEuiIqdtpU6Zr2amFmwGUa0dioTWO0wZlhW/Ox0CpkL3xze9Bh0QbOkJU7W7TLmXvgF59IpZAP8TTI9+QxLZZwdIvwiDEm9mrYX4AEchJCfuVbbFHOtWhmrYZJ29+R5vuRaKp9pkpwrZtEE8quYfYX78rvXVq42ZEfhtq3sqfaclKfxij3QBFsk+uyC79obfQObIB92wy2olP6HbBlCuwSH2Nh3bdMw4qePuFGrCal2aTdfa3dSqz+m1addSAm8gtfixNni2MVwHMphhS2Ev5Q/2iOpjCqfDZ1SPgj7gxASCwZh+a2EnJewasm1A3Klfp/trb+F61o+d8rv8JsoZyEqi2crfJKw3Sr1NyaJWl2a78QlnOGPqU3XStm31MBVKIY+yIcSaIQxeCwHF6Wyr1GHGuXQ4SVq+SVkji1ZHJDrR/gj4tQOsk1QNgwNUA/X0nWKkigRmSLK+U/AHbnvdGmf62UlT6ePFEGjNu/7JXqFUv28ZA4fvFiFHOKp/XyLbLRapsspijmNN0KMECPECDFCjBAjxGf7J8AA1yBq1Xbt28kAAAAASUVORK5CYII=" />
                        </div>
                    </a>';
                }
                echo '
                </td>
                <td class="admin_offers_table_td7">
                    <a href="'.PA::adminGetLink('offer_view',$offer->id).'" title="'.AdminText::get('OFFERS_BUTTON_VIEW').'">
                        <div class="admin_table_button admin_button_preview">
                            <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAsFJREFUeNrsl0tIVUEYgL3XwjKxXBhBCpHVokWWKRHRJgIp6bnQoBbVXYZQG1u4KKKoFkVhbSKCHrYKBKOgTS3TyMAiei2iB/QwNDIf2b339E38B36Gi+mJU5f6Bz5G58yZ+b9zz/wzJxEEQcG/UBImYiImYiImYiImYiImYiIm8t+JBJmM31QJK2EpVEEZJGEQXkEvdMGTnwEUFuaVyFTYBClYDTN+cZu7qQeuQDsy/fkgspHqANR4l8ZgAIYgC8UwS2pdXsNJOIfQyB8XQWA+VRusV8190Akd8sSdSAkUyavlXrEl0ABbYaG69xHsReZ2tIAQmSzZdHoNfIBAGICDMAcKhGq4Bm+hD3pgj7o+HXbBCzVOGlJRYooisQW+qslvwiIVoGMnfFN9NJ0wTfUtg1MiEfZpjVWECTZDViZz9T5PwLF4HImQM2F/NfY6+KT67I9FhIFXwBeZZBCapN2nTQXzHhqhFtpV+zBUahEZa5n3ym6LQ+SemuCQavfpVv1Sqr3Ue+INvoiM16h+9ZcTjS85ibxwWNKoK02StXIVvcMNqb+/y/4Rlik5MqGLZ7fLptJ0NpasxRNqUU/0OVTl+EUuqD4uI62CCjih2sdggbdGEnBe9elwbXFmLR3oM1juidRBxlvcw97/l/Ripy72xn0K5bGmX5n4tJp0FJo9mZZxMtZdWS9h3xrZY8LrD90vGPs+omSOegHekuwUBlgPXTAii9dtjMehSK7PdPuFZMBwjN4oEo7fOmuxOHdQHYO50pSG63AVuuEjzJYjSr9cr4Z62A7z1HAX5Yjy+W8dGl2gRyTbJL0T7ht4JxmrXI74Jd4Q7ljfisCNfPkeqXVPFDZA6QRuve9OvHAZidF8/LByr9laqIMKkUrKnuJetcdwBx642/Pmw8q+2U3EREzEREzEREzEREzEREwkYvkhwAD4ho8lKnZL5AAAAABJRU5ErkJggg==
" />
                        </div>
                    </a>
                </td>
                <td class="admin_offers_table_td8">
                    <a href="'.PA::adminGetLink('offer_delete',$offer->id).'" title="'.AdminText::get('OFFERS_BUTTON_DELETE').'" class="delete_button">
                        <div class="admin_table_button admin_button_delete">
                            <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAbZJREFUeNrsmE1KAzEYhiftWBUrqCAURRAvIXgDEcWtC7cqLt14AcG9Sw8gLl0KnsGtK6GrgpTWH9BarTa+wSximGFoTMaxvIGH0sxP5pl8mSSfkFJGw1BK0ZAUilCEIhShCEWKKLIB3kDbogf2QzQoHJYoY6ACki7sg1lwDpZTrr8Fm6AOyknPBN5BN7TIMdgFnZTjM2A84x6qt1opxybAKTgc5KFih16cNnAto2A+o40otMirDqGXQOOrOmhYuYbWlG4s1PpfjZFn8BhapJAldrxuBJyBGvjwOBWokNoC93mJqEZXwJznF9vVH4LcJsRQ8Shd7+1zZv8EV6Bh1d+Aa6tOhc6ly9cp/RVgsDtQAQ35s1zoY6tGXQ8sgipoGvU7+twT6x4dUHN5Jp890ta/LWsGf9KfU3PeaSac+y9WvyLjP5fxFKEIRShCEYpQ5A9EZOhtgE+ROGGzVjIoWzvM32zsvO0Qk8oa2APrRp3Kbx3pRMKCUX8AJsG2t1WpY/JBZRrrAba6KtW0BO7yCi0RcDyJPENLdeND9J3f8plFUWnYfp6hxXmEIhShCEUoQpEili8BBgAwzfiS5i1EyAAAAABJRU5ErkJggg==" />
                        </div>
                    </a>
                </td>
            </tr>';
        }
    echo '
    </table>';
    }

    public static function adminGetCategoryKeys()
    {
        $categories = Text::get('CATEGORY2');
        return array_keys($categories);
    }

    public static function adminShowCategories($type='',$prefix='',$category_selected='')
    {
        $categories = Text::get('CATEGORY2');

        if ($type == 'checkbox')
        {
            if (in_array('0',$category_selected))
            {
                $checked = ' checked';
            } else {
                $checked = '';
            }
            echo '
                <script language="JavaScript">
                    function '.$prefix.'_toggle(source) {
                        checkboxes = document.getElementsByName("'.$prefix.'[]");
                        for(var i=0, n=checkboxes.length;i<n;i++) {
                            checkboxes[i].checked = source.checked;
                        }
                    }
                    </script>
                <input type="checkbox"
                       value="0"
                       name="'.$prefix.'[]"
                       id="'.$prefix.'_all"
                       class="css-checkbox"
                       onClick="'.$prefix.'_toggle(this)"'.$checked.'>
                <label for="'.$prefix.'_all" class="css-label">Alle auswählen</label>';

            foreach ($categories as $key => $category)
            {
                if (in_array($key,$category_selected))
                {
                    $checked = ' checked';
                } else {
                    $checked = '';
                }
                echo '
                    <input type="checkbox"
                           value="'.$key.'"
                           name="'.$prefix.'[]"
                           id="'.$prefix.'_cat_'.$key.'"'.$checked.'>
                    <label for="'.$prefix.'_cat_'.$key.'">'.$category[0].'</label>';
            }
        }
        elseif ($type == 'select')
        {
            echo '
                <select id="'.$prefix.'_select" class="form_element" name="'.$prefix.'">
                <option value="0">Bitte wählen</option>';

            foreach ($categories as $key => $category)
            {
                echo '<option value="'.$key.'"';
                if ($category_selected == $key) { echo ' selected'; }
                echo '>'.$category[0].'</option>';
            }
            echo '</select>';
        }
    }

    public static function adminShowPageUsers($users)
    {
        echo '
        <h1 class="headline">
            Nutzerverwaltung
            <div id="admin_new_button">
                <a href="'.PA::getLink('register').'">
                    <img src="'.PA::getImageURL('core').'/icn_newuser.png">
                </a>
            </div>
        </h1>';
        PA::adminShowUserList($users);
    }

    public static function adminShowPageSettings($settings)
    {

        if ($settings->MarketLogo == '') { $settings->MarketLogo = null; }
        if ($settings->MarketHeader == '') { $settings->MarketHeader = null; }
        if ($settings->MarketBackground == '') { $settings->MarketBackground = null; }

        echo '
        <h1 class="headline">Plattformverwaltung</h1>
        <div id="admin_sidebar" class="right onethird">';
        PA::showImageUploader('platformlogo','logo_medium','',
                              $settings->MarketLogo,'Logo');

        PA::showImageUploader('platformheader','header_small','',
                              $settings->MarketHeader,'Headerbild');

        PA::showImageUploader('platformbackground','background_small','',
                              $settings->MarketBackground,'Hintergrundbild');

        echo '
        <div class="admin_sidebar_box">
            lore ipsum, lore ipsum, hier ist ein Blindtext
            lore ipsum, lore ipsum, hier ist ein Blindtext
            lore ipsum, lore ipsum, hier ist ein Blindtext
            lore ipsum, lore ipsum, hier ist ein Blindtext
        </div>
    </div>

    <div class="admin_box left twothird">
        <form action="'.PA::getURL().'admin/save_settings"
              name="saveSettings"
              method="post">
            <label for="platformTitle" class="form_label">
                <span>Plattform Name</span>
            </label>
            <input type="text"
                   name="MarketName"
                   id="platformTitle"
                   class="form_element"
                   placeholder="Plattformname"
                   value="'.$settings->MarketName.'" />
            <label for="platformClaim" class="form_label">
                <span>Plattform Claim/Slogan</span>
            </label>
            <input type="text"
                   name="MarketClaim"
                   id="platformClaim"
                   class="form_element"
                   placeholder="Plattform Claim/Slogan"
                   value="'.$settings->MarketClaim.'" />
            <label for="plattformDetailShort" class="form_label">
                <span>Wie kann man Ihre Plattform kurz beschreiben?</span>
            </label>
            <textarea type="text"
                   name="MarketDetailShort"
                   id="plattformDetailShort"
                   class="form_element"
                   placeholder="Kurzer Beschreibungstext zur Plattform"
                   rows="5">'.$settings->MarketDetailShort.'</textarea>
            <label for="plattformDetail" class="form_label">
                <span>Was kann man noch zur Plattform sagen?</span>
            </label>
            <textarea type="text"
                   name="MarketDetail"
                   id="plattformDetail"
                   class="form_element"
                   placeholder="Längerer Beschreibungstext zur Plattform"
                   rows="7">'.$settings->MarketDetail.'</textarea>
            <label for="companyContactPerson" class="form_label">
                <span>'.Text::get('PROFILE_LABEL_CONTACT_PERSON').'</span>
            </label>
            <input type="text"
                   name="MarketContactPerson"
                   class="form_element"
                   placeholder="'.Text::get('PROFILE_INPUT_PLACEHOLDER_CONTACT_PERSON').'"
                   value="'.$settings->MarketContactPerson.'">
            <label for="companyPhone" class="form_label">
                <span>'.Text::get('PROFILE_LABEL_CONTACT_TEL').'</span>
            </label>
            <input type="text"
                   name="MarketContactTel"
                   class="form_element"
                   placeholder="'.Text::get('PROFILE_INPUT_PLACEHOLDER_CONTACT_TEL').'"
                   value="'.$settings->MarketContactTel.'">
            <label for="companyFax" class="form_label">
                <span>'.Text::get('PROFILE_LABEL_CONTACT_FAX').'</span>
            </label>
            <input type="text"
                   name="MarketContactFax"
                   class="form_element"
                   placeholder="'.Text::get('PROFILE_INPUT_PLACEHOLDER_CONTACT_FAX').'"
                   value="'.$settings->MarketContactFax.'">
            <label for="companyEmail" class="form_label">
                <span>'.Text::get('PROFILE_LABEL_CONTACT_EMAIL').'</span>
            </label>
            <input type="email"
                   name="MarketContactEmail"
                   class="form_element"
                   placeholder="'.Text::get('PROFILE_INPUT_PLACEHOLDER_CONTACT_EMAIL').'"
                   value="'.$settings->MarketContactEmail.'">
            <label for="companyWebsite" class="form_label">
                <span>'.Text::get('PROFILE_LABEL_CONTACT_WEB').'</span>
            </label>
            <input type="url"
                   name="MarketContactWeb"
                   class="form_element"
                   placeholder="'.Text::get('PROFILE_INPUT_PLACEHOLDER_CONTACT_WEB').'"
                   value="'.$settings->MarketContactWeb.'">
            <label for="companyAddressStreet" class="form_label">
                <span>'.Text::get('PROFILE_LABEL_CONTACT_ADDRESS').'</span>
            </label>
            <div class="twothird left">
                <input type="text"
                       name="MarketAddressStreet"
                       class="form_element"
                       placeholder="'.Text::get('PROFILE_INPUT_PLACEHOLDER_ADDRESS_STREET').'"
                       value="'.$settings->MarketAddressStreet.'">
            </div>
            <div class="onethird right">
                <input type="text"
                       name="MarketAddressNumber"
                       class="form_element"
                       placeholder="'.Text::get('PROFILE_INPUT_PLACEHOLDER_ADDRESS_NUMBER').'"
                       value="'.$settings->MarketAddressNumber.'">
            </div>
            <div class="clear"></div>
            <div class="onethird left">
                <input type="text"
                       name="MarketAddressZipcode"
                       class="form_element"
                       placeholder="'.Text::get('PROFILE_INPUT_PLACEHOLDER_ADDRESS_ZIPCODE').'"
                       value="'.$settings->MarketAddressZipcode.'">
            </div>
            <div class="twothird right">
                <input type="text"
                       name="MarketAddressCity"
                       class="form_element"
                       placeholder="'.Text::get('PROFILE_INPUT_PLACEHOLDER_ADDRESS_TOWN').'"
                       value="'.$settings->MarketAddressCity.'">
            </div>
            <div class="clear"></div>
            <div class="half left">
                <input type="text"
                       name="MarketAddressState"
                       class="form_element"
                       placeholder="'.Text::get('PROFILE_INPUT_PLACEHOLDER_ADDRESS_STATE').'"
                       value="'.$settings->MarketAddressState.'">
            </div>
            <div class="half right">
                <input type="text"
                       name="MarketAddressCountry"
                       class="form_element"
                       placeholder="'.Text::get('PROFILE_INPUT_PLACEHOLDER_ADDRESS_COUNTRY').'"
                       value="'.$settings->MarketAddressCountry.'">
            </div>
            <div class="clear"></div>
                <label for="plattformTheme"
                       class="form_label"><span>Plattform Theme</span></label>
                <select id="plattformTheme"
                        class="form_element"
                        name="MarketUsedTheme">';

            $themes_available = PA::getThemes();
            foreach ($themes_available as $theme)
            {
                echo '
                <option value="'.$theme.'"';
                if (PA::getThemeName() == $theme) { echo ' selected'; }
                echo '>'.$theme.'</option>';
            }
            echo '
            </select>

            <label for="platformRegistration"
                   class="form_label"><span>Wer kann sich anmelden?</span></label>
            <select id="platformRegistration"
                    class="form_element"
                    name="MarketRegistrationStatus">
                <option value="2">Jeder kann mitmachen</option>
                <option value="1">Jeder kann mitmachen &amp; muss freigeschaltet werden</option>
                <option value="0">Niemand kann sich registrieren</option>
            </select>

            <input type="submit"
                   value="Speichern"
                   class="form_submit">
        </form>
    </div>
    <div class="clear"></div>';
    }

    public static function adminShowPagePages($pages)
    {
        echo '
        <h1 class="headline">Seitenverwaltung</h1>
        <div class="half left">
            <h3 class="headline">Neue Seite erstellen</h3>
            <div class="adminpagebox">
                <a href="'.PA::getURL().'admin/pages/add'.'" class="button">Neue Seite erstellen</a>
            </div>
        </div>
        <div class="half right">
            <h3 class="headline">Vorhandene Seiten bearbeiten</h3>
            <ul class="adminpagebox">';
                foreach ($pages as $page)
                {
                    echo '
                    <li>
                        <a href="'.PA::getURL().'admin/pages/edit/'.$page->id.'">
                            '.$page->title.'
                        </a>
                    </li>';
                }
                echo '
            </ul>
        </div>
        <div class="clear"></div>
        ';
    }

    public static function adminShowPagePagesEdit($page)
    {
        if ($page->title == '')
        {
            $headline = 'Neue Seite erstellen';
        } else {
            $headline = 'Seite bearbeiten';
        }
        echo '
        <form action="'.PA::getURL().'admin/save_page/'.$page->id.'"
              name="savePage"
              method="post">

            <h1 class="headline">'.$headline.'</h1>
            <div class="admin_box">

                <label for="newPageTitle" class="form_label">
                    <span>Seiten Titel</span>
                </label>
                <input type="text"
                       id="newPageTitle"
                       name="pageTitle"
                       value="'.$page->title.'"
                       class="form_element"
                       placeholder="Seiten Titel">
            </div>
            ';

            PA::showEditor($page->body);

            echo '
            <div class="admin_box">
                <div class="half left">
                    <label for="offerStatus" class="form_label">
                        <span>An welcher Stelle soll die Seite im Menu erscheinen?</span>
                    </label>
                    <input type="text"
                           id="newPageIndex"
                           name="pageSortIndex"
                           value="'.$page->sort_index.'"
                           maxlength="2"
                           placeholder="Index Nummer"
                           class="form_element">
                    <label for="offerStatus" class="form_label">
                        <span>Was ist der Status?</span>
                    </label>
                    <select id="offerStatus"
                            class="form_element"
                            name="pageStatus">
                        <option value="1"';
                            if ($page->status == 1) { echo ' selected'; }
                            echo '>
                            Entwurf
                        </option>
                        <option value="2"';
                            if ($page->status == 2) { echo ' selected'; }
                            echo '>
                            Veröffentlicht
                        </option>
                    </select>
                </div>
                <div class="half right">
                    <label for="offerStatus"
                           class="form_label"><span>Wie lautet der Slug der Seite?</span></label>
                    <input type="text"
                           name="pageSlug"
                           id="newPageSlug"
                           value="'.$page->slug.'"
                           maxlength="20"
                           placeholder="Slug"
                           class="form_element">
                    <label for="admin_page_submit"
                           class="form_label"><span>Jetzt speichern?</span></label>
                    <input type="submit" value="Seite Speichern" class="form_submit" id="admin_page_submit">
                    <a href="" class="delete_button">
                        <div class="admin_delete_button"></div>
                    </a>
                </div>
                <div class="clear"></div>
            </div>
        </form>';
    }

    public static function adminShowPageOffers($offers)
    {
        echo '
        <h1 class="headline">
        Angebotsverwaltung
        </h1>';

        $args = array('page' => 1,
                      'active' => true,
                      'type' => 1,
                      'howMany' => 20,
                      'orderBy' => 'created',
                      'order' => 'DESC');

        $offers = PA::getOffersWithProfile($args);

        PA::adminShowOfferList($offers);

        echo '
        <h1 class="headline">
            Gesucheverwaltung
        </h1>';

        $args = array('page' => 1,
                      'active' => true,
                      'type' => 2,
                      'howMany' => 20,
                      'orderBy' => 'created',
                      'order' => 'DESC');
        $offers = PA::getOffersWithProfile($args);

        PA::adminShowOfferList($offers);
    }

    public static function adminShowPageIndex($settings)
    {
        echo '
        <div id="admin_welcome_news">';
        $news_url = 'http://subphisticated.com/maerkte/get.php?version_no=1';
        $central_news = file_get_contents($news_url);
        echo $central_news;
        echo '
        </div>
        <h1 class="headline">Hallo '.Session::get('user_name').', schön, dass Sie hier sind</h1>

        <ul id="admin_overview">
            <li class="overview_user">
                <a href="'.PA::adminGetLink('users').'">
                    <div class="admin_overview_alert">10</div>
                    <div class="admin_overview_title"><span>123</span>Akteure</div>
                </a>
            </li>
            <li class="overview_offer">
                <a href="'.PA::adminGetLink('offers').'">
                    <div class="admin_overview_alert">7</div>
                    <div class="admin_overview_title"><span>4567</span>Angebote</div>
                </a>
            </li>
            <li class="overview_offer">
                <a href="'.PA::adminGetLink('offers').'">
                    <div class="admin_overview_alert">5</div>
                    <div class="admin_overview_title"><span>890</span>Gesuche</div>
                </a>
            </li>
            <li class="overview_connection">
                <a href="'.PA::adminGetLink('connections').'">
                    <div class="admin_overview_alert">4</div>
                    <div class="admin_overview_title"><span>12</span>Verbindungen</div>
                </a>
            </li>
            <div class="clear"></div>
        </ul>';
    }

    public static function isAdminArea()
    {
        if (View::getAdminStatus())
        {
            return true;
        } else {
            return false;
        }
    }
}
?>
