<?php

class Theme
{
    private static $theme;

    public static function get($key)
    {
        if (!self::$theme) {
            self::$theme['NAME'] = Config::getFromDB('MarketUsedTheme');
            self::$theme['PATH'] = Config::get('PATH_THEMES')
                .Config::getFromDB('MarketUsedTheme').'/';
            self::$theme['URL'] = Config::get('URL').'themes/'
                .Config::getFromDB('MarketUsedTheme').'/';
            self::$theme['BASEURL'] = Config::get('URL').'themes/';
        }

        return self::$theme[$key];
    }

    public static function getConfig($key = '')
    {
        $path = Config::get('PATH_THEMES').Config::getFromDB('MarketUsedTheme').'/config.php';
        if (file_exists($path)) {
            include($path);
            if ($key == '') {
                return $theme_config;
            } else {
                return $theme_config[$key];
            }
        }
    }

    public static function loadFile($file, $data = '')
    {
        $path       = Config::get('PATH_THEMES');
        $used_theme = Config::getFromDB('MarketUsedTheme');

        if (file_exists($path.$used_theme.'/'.$file)) {
            require $path.$used_theme.'/'.$file;
        } else {
            $parent = self::getConfig('PARENT');
            require $path.$parent.'/'.$file;
        };
    }

    public static function getThemes()
    {
        foreach (glob('../public/themes/*', GLOB_ONLYDIR) as $dir) {
            $dirs[] = basename($dir);
        }
        return $dirs;
    }

}
