<?php

class SearchController extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    public function __construct()
    {
        parent::__construct();
    }

    public function index()
    {
        $searchTerm = SearchModel::clean();
        Redirect::to('search/q/'.$searchTerm);
    }

    public function q($query = '')
    {
        $this->View->render('search', array(
            'results'           => SearchModel::getResults($query),
            'results_profile'   => SearchModel::getProfileResults($query),
            'searchterm'        => $query)
        );
    }
}
