<?php
echo '<h1 class="headline">'.Text::get('PLUGINS_HEADLINE').'</h1>';
echo '<div class="admin_plugin_box" style="padding-left: 10px;"><b>Coming soon...</b></div>';
foreach ($data['plugins'] as $plugin) {
    $url = Config::getURL().'admin/plugins/';
    switch ($plugin->status) {
        case 0:
            $status = 'found';
            $link = '<a href="'.$url.'activate/'.$plugin->id.'">activate</a>';
            $color = '#ff5500';
            break;
        case 1:
            $status = 'deactivated';
            $link = '<a href="'.$url.'activate/'.$plugin->id.'">activate</a>';
            $color = '#ff0000';
            break;
        case 2:
            $status = 'active';
            $link = '<a href="'.$url.'deactivate/'.$plugin->id.'">deactivate</a>';
            $color = '#4d9c07';
            break;
        default:
            $status = 'unknown';
            $link = '';
            break;
    }
    echo '<div class="admin_plugin_box">';
    echo '
            <div class="admin_plugin_about_box left">
                <div class="admin_plugin_logobox" style="background-color: '.$color.';">
                    <img src="'.Plugin::getLogoPath($plugin->name).'">
                </div>
                <div class="admin_plugin_text_box">
                    <div class="admin_plugin_text_name">'.$plugin->name.'</div>
                    <div class="admin_plugin_text_text">
                        <form action="'.PA::getURL().'admin/plugins/edit/'.$plugin->id.'"
                              name="editPlugin'.$plugin->id.'"
                              method="post">
                            '.Plugin::getPluginPlacingDropdown("header",$plugin->header).'
                            '.Plugin::getPluginPlacingDropdown("menu",$plugin->menu).'
                            '.Plugin::getPluginPlacingDropdown("sidebar",$plugin->sidebar).'
                            '.Plugin::getPluginPlacingDropdown("footer",$plugin->footer).'
                            <input type="submit"
                                   value="'.Text::get("PLUGIN_SAVE_CHANGES").'"
                                   class="plugin_form_submit" />
                        </form>
                    </div>
                </div>
            </div>
            <div class="admin_plugin_settings_box right">
                '.$link.'
            </div>
    ';

    echo '</div>';
}

PA::showFooter();
?>
