<?php

if (Config::get('COMPRESS_HTML')) {
    ob_start("Helper::compressHTML");
}

if (PA::isProfilePage()) {
    $details    = $data['profile'];
    $edit_id    = $details->id;
    $edit_type  = 'editUser';
} elseif (PA::isOfferPage()) {
    $details    = $data['profile'];
    $offer      = $data['offer'];
    $edit_id    = $offer->id;
    $edit_type  = 'editOffer';
} elseif (PA::isPage()) {
    $page       = $data['page'];
    $edit_id    = $page->id;
    $edit_type  = 'editPage';
}
?>
<!DOCTYPE html>
<html>
<head>
    <?php echo PA::head(array('style' => 'screen'),$data); ?>
</head>
<body>
    <div id="meta_box"></div>
    <?php
    $backgroundImage = Config::getFromDB('MarketBackground');
    if ($backgroundImage != '')
    {
        $img = explode(':', $backgroundImage);
        $platformBackground = ' style="background-image: url('.PA::getImageURL().$img[0].'background_medium'.$img[1].');"';
    } else {
        $platformBackground = '';
    }
    ?>
    <div id="bg"<?php echo $platformBackground; ?>></div>
    <nav>
        <div id="nav_top">
            <a href="<?php echo PA::getHomeURL(); ?>">
                <?php
                $platformLogoSmall = Config::getFromDB('MarketLogo');
                if ($platformLogoSmall != '') {
                    $img = explode(':', $platformLogoSmall);
                    $logoSmall = ' style="background-image: url('.PA::getImageURL()
                        .$img[0].'logo_small'.$img[1].');"';
                } else {
                    $logoSmall = '';
                }
                ?>
                <div id="logo_small"<?php echo $logoSmall; ?>>
                </div>
            </a>
            <?php PA::showMarketName('h1',true); ?>
            <div id="menu_box">
                <div class="menu">
                    <?php
                    if (PA::isLoggedin()) {
                        $user_icon = PA::getThemeURL().'img/icn_user_loggedin.png';
                    } else {
                        $user_icon = PA::getThemeURL().'img/icn_user.png';
                    }
                    ?>
                    <?php PA::showMenu('mainmenu', PA::getThemeURL().'img/icn_home.png'); ?>
                    <?php PA::showMenu('adminmenu', PA::getThemeURL().'img/icn_admin.png'); ?>
                    <?php
                    if (!PA::isAdminArea()) {
                        PA::showMenu('sharemenu', PA::getThemeURL().'img/icn_share.png');
                    }
                    ?>
                    <?php PA::showMenu('usermenu', $user_icon);?>
                    <?php PA::showMenu('pagesmenu', PA::getThemeURL().'img/icn_pagemenu.png'); ?>
                </div>
            </div>
        </div>
    </nav>
    <div id="wrapper">
        <?php
        $headerImage = Config::getFromDB('MarketHeader');
        $showerror = 0;
        $header_error = 'ACHTUNG: ';

        if (PA::isOfferPage() || PA::isProfilePage()) {
            if (isset($details->company_header_path) && $details->company_header_path !='') {
                $headerImage = $details->company_header_path;
            } else {
                $header_error .= Text::get("HEADER_ERROR_HEADERBG").' // ';
                $showerror = 1;
            }

            $img = explode(':',$headerImage);
            ?>
            <header style="background-image: url('<?php echo PA::getImageURL()
                .$img[0].'header_medium'.$img[1]; ?>');">
                <?php
                if (isset($details->company_logo_path) && $details->company_logo_path !='') {
                    PA::showUserLogo($details);
                } else {
                    PA::showMarketLogo();
                    $header_error .= Text::get("HEADER_ERROR_LOGO").' // ';
                    $showerror = 1;
                }
                if (isset($details->company_name) && $details->company_name !='') {
                    PA::showUserName($details);
                } else {
                    PA::showMarketName();
                    $header_error .= Text::get("HEADER_ERROR_NAME").' // ';
                    $showerror = 1;
                }
                if (isset($details->company_claim) && $details->company_claim !='') {
                    PA::showUserClaim($details);
                } else {
                    PA::showMarketClaim();
                    $header_error .= Text::get("HEADER_ERROR_CLAIM").' // ';
                    $showerror = 1;
                }
                if ($showerror == 1 && PA::isOwner($edit_id)) {
                    $header_error = substr($header_error, 0, -4);
                    $header_error .= Text::get("HEADER_ERROR_CHANGE");
                    echo '<a href="'.PA::getLink('editUser').'"><div id="header_error">'.$header_error.'</div></a>';
                }
                ?>
            </header>
            <?php
        } else {
            if ($headerImage != '') {
                $img = explode(':', $headerImage);
                $headerimg = ' style="background-image: url('.PA::getImageURL()
                    .$img[0].'header_medium'.$img[1].');"';
            } else {
                $headerimg = '';
            }
            ?>
            <header<?php echo $headerimg; ?>>
                <?php PA::showMarketLogo(); ?>
                <?php PA::showMarketName(); ?>
                <?php PA::showMarketClaim(); ?>
            </header>
            <?php
        }
        ?>

<?php
PA::showFeedback();
?>
