<?php

/**
 * PluginModel
 */

class PluginModel
{
    public static function getPlugin($pluginID)
    {
        $prefix = Config::get('DB_PREFIX');
        $database = DatabaseFactory::getFactory()->getConnection();

        $sql = "SELECT id,
                       name,
                       status,
                       header,
                       menu,
                       sidebar,
                       footer,
                       created,
                       modified
                FROM ".$prefix."plugins
                WHERE id = :pluginID
                LIMIT 1";
        $query = $database->prepare($sql);
        $query->bindParam(':pluginID', $pluginID, PDO::PARAM_INT);
        if ($query->execute() && $query->rowCount() > 0) {
            return $query->fetch();
        } else {
            return false;
        }
    }

    public static function getPlugins($active = false)
    {
        $prefix = Config::get('DB_PREFIX');
        $database = DatabaseFactory::getFactory()->getConnection();

        if ($active === true) {
            $status = 2;
        } else {
            $status = 0;
        }

        $sql = "SELECT id,
                       name,
                       status,
                       header,
                       menu,
                       sidebar,
                       footer,
                       created,
                       modified
                FROM ".$prefix."plugins
                WHERE status >= :status";
        $query = $database->prepare($sql);
        $query->bindParam(':status', $status, PDO::PARAM_INT);
        $query->execute();

        $plugins = array();
        $pluginsArray = array();

        foreach ($query->fetchAll() as $plugin) {
            $plugins[$plugin->id]           = new stdClass();
            $plugins[$plugin->id]->id       = $plugin->id;
            $plugins[$plugin->id]->name     = $plugin->name;
            $plugins[$plugin->id]->status   = $plugin->status;
            $plugins[$plugin->id]->header   = $plugin->header;
            $plugins[$plugin->id]->menu     = $plugin->menu;
            $plugins[$plugin->id]->sidebar  = $plugin->sidebar;
            $plugins[$plugin->id]->footer   = $plugin->footer;
            $plugins[$plugin->id]->created  = $plugin->created;
            $plugins[$plugin->id]->modified = $plugin->modified;

            $pluginsArray[] = $plugin->name;
        }

        if ($active === false) {
            $pluginFolder = Plugin::getPlugins();
            foreach ($pluginFolder as $pluginName) {
                if (!in_array($pluginName, $pluginsArray)) {
                    $plugin = self::insertPlugin($pluginName);
                    $plugins[$plugin->id]           = new stdClass();
                    $plugins[$plugin->id]->id       = $plugin->id;
                    $plugins[$plugin->id]->name     = $plugin->name;
                    $plugins[$plugin->id]->status   = $plugin->status;
                    $plugins[$plugin->id]->header   = $plugin->header;
                    $plugins[$plugin->id]->menu     = $plugin->menu;
                    $plugins[$plugin->id]->sidebar  = $plugin->sidebar;
                    $plugins[$plugin->id]->footer   = $plugin->footer;
                    $plugins[$plugin->id]->created  = $plugin->created;
                    $plugins[$plugin->id]->modified = $plugin->modified;
                }
            }
        }

        return $plugins;
    }

    public static function insertPlugin($pluginName)
    {
        $prefix = Config::get('DB_PREFIX');
        $database = DatabaseFactory::getFactory()->getConnection();

        $sql = "INSERT INTO ".$prefix."plugins
                    (name, created, modified)
                VALUES
                    (:name, NOW(), NOW())";
        $query = $database->prepare($sql);
        $query->bindParam(':name',   $pluginName,   PDO::PARAM_STR);
        if ($query->execute()) {
            $plugin             = new stdClass();
            $plugin->id         = $database->lastInsertId();
            $plugin->name       = $pluginName;
            $plugin->status     = 0;
            $plugin->header     = 0;
            $plugin->menu       = 0;
            $plugin->sidebar    = 0;
            $plugin->footer     = 0;
            $plugin->created    = date('Y-m-d H:i:s');
            $plugin->modified   = '';
            return $plugin;
        } else {
            return false;
        }
    }

    public static function savePlugin($pluginID)
    {
        $values = array('header'                        => 'header',
                        'menu'                          => 'menu',
                        'sidebar'                       => 'sidebar',
                        'footer'                        => 'footer');
        $i = 0; $saved = 0;
        foreach ($values as $postName => $DBName) {
            if (self::updatePage($DBName, Request::post($postName), $pluginID)) {
                $saved++;
            }
            $i++;
        }
        if ($i == $saved) {
            Session::add('feedback_positive',
                         Text::get('FEEDBACK_PLUGIN_UPDATED'));
        } else {
            Session::add('feedback_negative',
                         Text::get('FEEDBACK_PLUGIN_UPDATE_FAILED'));
        }
    }

    public static function activatePlugin($pluginID)
    {
        $plugin = self::getPlugin($pluginID);
        if ($plugin === false) {
            return false;
        }
        $pluginConfig = Plugin::getConfig($plugin->name);
        $success = false;
        if (isset($pluginConfig['database'])) {
            if (UpgradeModel::createTable($plugin->name, $pluginConfig['database']['fields'], 'filter')) {
                $success = true;
            }
        } else {
            $success = true;
        }
        if ($success === true) {
            if (PluginModel::updatePlugin('status', 2, $pluginID)) {
                Session::add('feedback_positive',
                             Text::get('FEEDBACK_PLUGIN_ACTIVATED'));
            } else {
                Session::add('feedback_negative',
                             Text::get('FEEDBACK_PLUGIN_ACTIVATION_FAILED'));
            }
        }
    }

    public static function deactivatePlugin($pluginID)
    {
        $plugin = self::getPlugin($pluginID);
        if (PluginModel::updatePlugin('status', 1, $pluginID)) {
            Session::add('feedback_positive',
                         Text::get('FEEDBACK_PLUGIN_DEACTIVATED'));
        } else {
            Session::add('feedback_negative',
                         Text::get('FEEDBACK_PLUGIN_DEACTIVATION_FAILED'));
        }
    }

    public static function updatePlugin($dbName,$value,$pluginID)
    {
        $prefix = Config::get('DB_PREFIX');
        $database = DatabaseFactory::getFactory()->getConnection();

        $sql = "UPDATE ".$prefix."plugins
                SET ".$dbName." = :value,
                    modified = NOW()
                WHERE id = :plugin_id
                LIMIT 1";
        $query = $database->prepare($sql);
        $query->bindParam(':value',     $value,    PDO::PARAM_STR);
        $query->bindParam(':plugin_id', $pluginID, PDO::PARAM_INT);
        if ($query->execute() && $query->rowCount() > 0) {
            return true;
        } else {
            return false;
        }
    }
}
