<?php

class Plugin
{
    private static $plugin;

    public static function get($key, $plugin_name = '')
    {
        if (!self::$plugin) {
            self::$plugin['PATH'] = Config::get('PATH_PLUGINS');
            if ($plugin_name != '') {
                self::$plugin['PATH'] .= $plugin_name.'/';
            }
            self::$plugin['URL'] = Config::get('URL').'plugins/';
            if ($plugin_name != '') {
                self::$plugin['URL'] .= $plugin_name.'/';
            }
            self::$plugin['BASEURL'] = Config::get('URL').'plugins/';
        }
        return self::$plugin[$key];
    }

    public static function getFilePath($plugin, $filename)
    {
        return self::get('PATH', $plugin).$filename;
    }

    public static function getFileURL($plugin, $filename)
    {
        return self::get('URL', $plugin).$filename;
    }

    public static function getFile($plugin, $filename)
    {
        return Config::get('URL').'plugin/p/'.$plugin.'/'.$filename;
    }

    public static function getPlugins()
    {
        foreach (glob('../public/plugins/*', GLOB_ONLYDIR) as $dir) {
            $dirs[] = basename($dir);
        }
        return $dirs;
    }

    public static function getConfig($pluginName, $key = '')
    {
        $path = Config::get('PATH_PLUGINS').$pluginName.'/config.php';
        if (file_exists($path)) {
            $config = include($path);
            if ($key == '') {
                return $config;
            } else {
                if (isset($config[$key])) {
                    return $config[$key];
                } else {
                    return false;
                }
            }
        } else {
            return false;
        }
    }

    public static function getLogoPath($pluginName)
    {
        $path = Plugin::getFilePath($pluginName,'logo.png');
        $url = PA::getBaseURL().'plugins/'.$pluginName.'/logo.png';
        if (!file_exists($path)) {
            $url = PA::getBaseURL().'plugins/plugin_icon.png';
        }
        return $url;
    }

    public static function showPluginLinks($context)
    {
        $plugins = array();
        foreach (PluginModel::getPlugins(true) as $plugin) {
            $linkID = Plugin::getConfig($plugin->name, 'linkID');
            if ($linkID != false) {
                $link = 'href="#" id="'.$linkID.'"';
            } else {
                $link = 'href="'.PA::getHomeURL().'admin/plugins/'.$plugin->name.'"';
            }
            $show = false;
            switch ($context) {
                case 'mainmenu':
                    if ($plugin->menu == 4) {
                        $show = true;
                    }
                    break;
                case 'adminmenu':
                    if ($plugin->menu == 3) {
                        $show = true;
                    }
                    break;
                case 'usermenu':
                    if ($plugin->menu == 2) {
                        $show = true;
                    }
                    break;
                case 'pagesmenu':
                    if ($plugin->menu == 1) {
                        $show = true;
                    }
                    break;
            }
            if ($show === true) {
                echo '<li><a '.$link.'>'.$plugin->name.'</a></li>';
            }
        }
    }

    public static function getPluginPlacingDropdown($type, $selected)
    {
        $ucType = ucfirst($type);
        $upperType = strtoupper($type);
        $textTemplate = "PLUGIN_".$upperType."_DROPDOWN";
        $pluginDropdown = '<select id="plugin'.$ucType.'Dropdown"
                                   class="plugin_form_element"
                                   name="plugin'.$ucType.'Dropdown">';
        foreach (Text::get($textTemplate) as $key => $value) {
            if ($selected == $key) {
                $sel = " selected";
            } else {
                $sel = "";
            }
            $pluginDropdown .= '<option value="'.$key.'"'.$sel.'>'
                                    .$value.
                               '</option>';
        }
        $pluginDropdown .= '</select>';
        return $pluginDropdown;
    }

    public static function loadPluginJS()
    {
        $paths = array();
        foreach (PluginModel::getPlugins($active = true) as $key => $value) {
            if (file_exists(Plugin::get('PATH',$value->name).'js/load.php')) {
                $paths[] = Plugin::get('PATH',$value->name).'js/load.php';
            }
        }
        $returnScripts = '';
        foreach ($paths as $path) {
            $script = include($path);
            $returnScripts .= $script;
        }

        return $returnScripts;
    }
}
