<?php

/**
 * Class DatabaseArgs
 */
class DatabaseArgs
{
    private static $pageNumber      = 1;
    private static $howMany         = 12;
    private static $orderBy         = 'modified DESC';
    private static $userOrder       = true;
    private static $userFeatured    = false;
    private static $adminFeatured   = false;
    private static $otherFeatured   = false;
    private static $active          = true;
    private static $type            = 1;
    private static $profileID       = false;
    private static $context         = '';
    private static $prefix          = '';

    public static function setArgs($args, $context)
    {
        self::resetArgs();
        foreach($args as $key => $value) {
            switch($key) {
                case 'page':
                    if (self::$pageNumber == 1) {
                        self::setPageNumber($value);
                    }
                    break;
                case 'howMany':
                    self::setHowMany($value);
                    break;
                case 'orderBy':
                    self::setOrderBy($value);
                    break;
                case 'userOrder':
                    self::setUserOrder($value);
                    break;
                case 'active':
                    self::setActive($value);
                    break;
                case 'userFeatured':
                    self::setUserFeatured($value);
                    break;
                case 'otherFeatured':
                    self::setOtherFeatured($value);
                    break;
                case 'adminFeatured':
                    self::setAdminFeatured($value);
                    break;
                case 'profile':
                    self::setProfileID($value);
                    break;
                case 'type':
                    self::setType($value);
                    break;
                default:
                    echo '<br><br>key: '.$key.' is not set!<br>';
                    break;
            }
        }
        self::$context = $context;

        switch ($context) {
            case 'offers':
                self::$prefix = 'O.';
                break;
            case 'profiles':
                self::$prefix = 'P.';
                break;
        }
    }

    public static function resetArgs()
    {
        self::setHowMany(12);
        self::setOrderBy(array('modified','DESC'));
        self::setUserOrder(true);
        self::setActive(true);
        self::setUserFeatured(false);
        self::setAdminFeatured(false);
        self::setOtherFeatured(false);
        self::setProfileID(false);
        self::setType(1);
    }

    public static function setActive($active)
    {
        if (in_array($active,array(true,false))) {
            self::$active = $active;
            return true;
        } else {
            return false;
        }
    }

    public static function setUserFeatured($featured)
    {
        if (in_array($featured,array(true,false))) {
            self::$userFeatured = $featured;
        }
    }

    public static function setAdminFeatured($featured)
    {
        if (in_array($featured,array(true,false))) {
            self::$adminFeatured = $featured;
        }
    }

    public static function setOtherFeatured($featured)
    {
        if (in_array($featured,array(true,false))) {
            self::$otherFeatured = $featured;
        }
    }

    public static function setPageNumber($page)
    {
        self::$pageNumber = (int) $page;
    }

    public static function setHowMany($howMany)
    {
        self::$howMany = (int) $howMany;
    }

    public static function setOrderBy($orderBy, $user = false)
    {
        if ($orderBy == 'random') {
            $orderBy = 'rand()';
        }
        elseif (in_array($orderBy[0], array('created','modified','company_name',
                                            'company_address_zipcode',
                                            'company_address_city','id',
                                            'price','title','distance')) &&
                in_array($orderBy[1], array('ASC','DESC'))) {
            $orderBy = $orderBy[0].' '.$orderBy[1];
        } else {
            $orderBy = 'modified DESC';
        }
        self::$orderBy = $orderBy;

        if ($user === true) {
            Session::init();
            Session::set('sort', $orderBy);
        }
    }

    public static function setUserOrder($userOrder)
    {
        if (in_array($userOrder, array(true,false))) {
            self::$userOrder = $userOrder;
        }
    }

    public static function setType($typeName)
    {
        switch ($typeName)
        {
            case 1:
            case 'offer':
                $type = 1;
                break;
            case 2:
            case 'search':
                $type = 2;
                break;
            case false:
                $type = false;
                break;
        }
        self::$type = $type;
    }

    public static function setProfileID($profileID)
    {
        self::$profileID = (int) $profileID;
    }

    public static function getPageNumber()
    {
        return self::$pageNumber;
    }

    public static function getHowMany()
    {
        return self::$howMany;
    }

    public static function getUserOrder()
    {
        return self::$userOrder;
    }

    public static function getOrderBy()
    {
        if (self::$orderBy === 'rand()') {
            return self::$orderBy;
        } elseif (Session::get('sort') && self::getUserOrder()) {
            self::$orderBy = Session::get('sort');
        }
        $orderBy = explode(' ', self::$orderBy);
        switch (self::$context) {
            case 'profiles':
                if (in_array($orderBy[0], array('created','modified',
                                                'company_name','distance','id',
                                                'company_address_zipcode',
                                                'company_address_city'))) {
                    return self::$orderBy;
                } else {
                    return 'company_name DESC';
                }
                break;
            case 'offers':
                if (in_array($orderBy[0], array('created','modified',
                                                'distance','id', 'title',
                                                'price'))) {
                    return self::$orderBy;
                } else {
                    return 'modified DESC';
                }
                break;
            case 'search':
                if (in_array($orderBy[0], array('created','modified',
                                                'distance','id', 'title',
                                                'price'))) {
                    return self::$orderBy;
                } else {
                    return 'modified DESC';
                }
                break;
            default:
                return 'implement it stupid';
                break;
        }
    }

    public static function getStart()
    {
        return (self::getPageNumber()-1) * self::getHowMany();
    }

    public static function getWhereStmt()
    {
        $where = array();
        switch (self::$context) {
            case 'offers':
                if (self::$active === true) {
                    $where[] = self::$prefix.'status > 1';
                } else {
                    $where[] = self::$prefix.'status > 0';
                }
                if (self::$type != false) {
                    $where[] = self::$prefix.'type = '.self::$type;
                }
                if (self::$profileID != false) {
                    $where[] = self::$prefix.'profile_id = '.self::$profileID;
                }
                break;
            case 'profiles':
                $where[] = self::$prefix.'company_name IS NOT NULL';
                if (self::$otherFeatured === true) {
                    $where[] = self::$prefix.'other_featured = 1';
                }
                break;
            case 'search':
                if (Session::get('search_offers') == 'y' &&
                    Session::get('search_requests') == 'y')
                {
                } else {
                    if (Session::get('search_offers') == 'y')
                    {
                        $where[] = 'O.type = 1';
                    }
                    if (Session::get('search_requests') == 'y')
                    {
                        $where[] = 'O.type = 2';
                    }
                }
                if (Session::get('search_internal') == 'y' &&
                    Session::get('search_external') == 'y')
                {
                } else {
                    if (Session::get('search_internal') == 'y')
                    {
                        $where[] = 'O.external = 0';
                    }
                    if (Session::get('search_external') == 'y')
                    {
                        $where[] = 'O.external = 1';
                    }
                }
                $where[] = 'O.status > 1';
                break;
            default:
                return 'implement it stupid';
                break;
        }
        if (self::$userFeatured === true) {
            $where[] = 'user_featured = 1';
        }
        if (self::$adminFeatured === true) {
            $where[] = 'admin_featured = 1';
        }

        if (self::$context === 'search') {
            return implode(' AND ', $where);
        } else {
            return 'WHERE '.implode(' AND ', $where);
        }
    }
}
