<?php

class UploadController extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    public function __construct()
    {
        parent::__construct();
        Auth::checkAuthentication();
    }

    public function headerimage($user_id)
    {
        UploadModel::processHeaderImage($user_id);
    }

    public function logoimage($user_id)
    {
        UploadModel::processLogoImage($user_id);
    }

    public function offerimage($offer_id)
    {
        UploadModel::processOfferImage($offer_id);
    }

    public function platformlogo()
    {
        Auth::checkForSuperAdmin();
        AdminModel::processLogoImage();
    }

    public function platformheader()
    {
        Auth::checkForSuperAdmin();
        AdminModel::processHeaderImage();
    }

    public function platformbackground()
    {
        Auth::checkForSuperAdmin();
        AdminModel::processBackgroundImage();
    }
}
