<?php

class ProfilesController extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * This method controls what happens when you move to /overview/index in your app.
     * Shows a list of all users.
     */
    public function index()
    {
        Auth::checkAuthentication();
        $user_id = Session::get('user_id');
        $profiles = UserProfileModel::getUserProfilesByUserId($user_id);
        $this->View->render('ownProfile', array(
            'user' => UserModel::getUser($user_id),
            'profile' => $profiles[0])
        );
    }

    public function all()
    {
        $this->View->render('profiles');
    }

    /**
     * This method controls what happens when you move to /profiles/view in your app.
     * Shows the (public) details of the selected profile.
     * @param $profile_id int id of the profile
     */
    public function view($profile_id = null)
    {
        if (isset($profile_id))
        {
            $profile = UserProfileModel::getUserProfile($profile_id);
            if (isset($profile->company_name) && $profile->company_name != '')
            {
                $this->View->render('profile', array(
                    'user' => UserModel::getPublicProfileOfUser($profile->user_id),
                    'profile' => $profile
                ));
            }
            else
            {
                Redirect::home();
            }
        }
        else
        {
            Redirect::home();
        }
    }

    public function gastronomy()
    {
        $this->View->render('gastronomy');
    }

    /**
     * This method controls what happens when you move to /profiles/edit in your app.
     * @param $profile_id int id of the profile
     */
    public function edit($profile_id = null)
    {
        Auth::checkAuthentication();
        if (!isset($profile_id))
        {
            $profiles = UserProfileModel::getUserProfilesByUserId(Session::get('user_id'));
            $profile_id = $profiles[0]->id;
        }
        $profile = UserProfileModel::getUserProfile($profile_id);
        $this->View->renderAdmin('editProfile', array(
            'user' => UserModel::getPublicProfileOfUser($profile->user_id),
            'profile' => $profile
        ));
    }

    public function view_own()
    {
        $profiles = UserProfileModel::getUserProfilesByUserId(Session::get('user_id'));
        Redirect::to('profiles/view/'.$profiles[0]->id);
    }

    public function update($profile_id)
    {
        Auth::checkAuthentication();
        if (isset($profile_id))
        {
            UserProfileModel::saveProfile($profile_id);
        }
        Redirect::to('profiles/edit/'.$profile_id);
    }

    public function changePassword($user_id = NULL)
    {
        Auth::checkAuthentication();
        if ($user_id === NULL) {
            $user_id = Session::get('user_id');
        }
        if (UserModel::checkOwnership($user_id)) {
            $this->View->renderAdmin('changeUserPassword', array(
                'userID' => $user_id
            ));
        }
    }

    public function changePassword_action($user_id = NULL)
    {
        Auth::checkAuthentication();
        if ($user_id === NULL) {
            $user_id = Session::get('user_id');
        }
        if (!UserModel::checkOwnership($user_id)) {
            Session::add('feedback_negative','not your profile');
            Redirect::to('profiles/changePassword/'.$user_id);
            return false;
        }

        if (UserModel::changePassword($user_id,
                                      Request::post('user_password_old'),
                                      Request::post('user_password_new'),
                                      Request::post('user_password_repeat'))) {
            Session::add('feedback_positive',
                         Text::get('FEEDBACK_PASSWORD_CHANGE_SUCCESSFUL'));
            Redirect::to('profiles/view_own');
        } else {
            Redirect::to('profiles/changePassword/'.$user_id);
        }
    }

    /**
     * The logout action
     * Perform logout, redirect user to main-page
     */
    public function logout()
    {
        LoginModel::logout();
        Session::add('feedback_positive', Text::get('FEEDBACK_LOGOUT_SUCCESSFUL'));
        Redirect::home();
    }
}
