<?php
$profile = $data['profile'];
?>

<h1 class="headline"><?php echo PA::filter(Text::get('USER_WELCOME'),$data['user']->user_name); ?></h1>
<div id="profile_box" class="half left">
    <h2 class="headline"><?php echo Text::get('USER_OWN_PROFILE');?></h2>
    <div class="profile_subbox">
        <?php
        echo Text::get('USER_USERNAME').': '.$data['user']->user_name.'<br>';
        echo Text::get('USER_EMAIL').': '.$data['user']->user_email.'<br><br>';
        echo Text::get('USER_CREATED').': '.date("d.m.Y // H:i", $data['user']->user_creation_timestamp).'<br>';
        echo Text::get('USER_LASTLOGIN').': '.date("d.m.Y // H:i", $data['user']->user_last_login_timestamp);
        ?>
        <hr>
        <?php
        echo '<strong>'.$profile->company_name.'</strong>  ';
        echo $profile->company_claim.'<br><br>';
        echo nl2br($profile->company_short_info).'<br>';
        ?>
        <a href="<?php echo PA::getLink('changePassword'); ?>">
            <div class="button button_left"><?php echo AdminText::get('USERS_CHANGE_PASSWORD'); ?></div>
        </a>
        <a href="<?php echo PA::getLink('editOwnProfile',$profile->id); ?>">
            <div class="button"><?php echo Text::get('USER_OWN_EDITPROFILE');?></div>
        </a>
    </div>
    <div class="profile_subbox">
        <?php echo Text::get('USER_OWN_NEW_OFFER_TEXT');?>
        <a href="<?php echo PA::getLink('newOffer'); ?>">
            <div class="button"><?php echo Text::get('USER_OWN_NEW_OFFER');?></div>
        </a>
    </div>
</div>

<div id="profile_box" class="half right">
    <?php
    $args = array('profile' => $profile->id,
                  'type' => 1,
                  'howMany' => 100,
                  'orderBy' => 'created',
                  'order' => 'DESC');
    $offers = PA::getOffers($args);

    if ($offers['number'] > 0)
    {
        echo '<h2 class="headline">'.Text::get('USER_OWN_OFFERS').' ('.$offers['number'].')</h2>';
        PA::showOfferList($offers,false,false,false,false);
    }
    else
    {
        echo '
            <div class="profile_subbox">
                '.Text::get('USER_NO_OFFER').'
                 <a href="'.PA::getLink('newOffer').'" class="profile_subbox_newoffer">'.Text::get('USER_NO_OFFER_NEW_TEXT').'</a>
            </div>';
    }

    $args = array('profile' => $profile->id,
                  'type' => 2,
                  'howMany' => 100,
                  'orderBy' => 'created',
                  'order' => 'DESC');
    $offers = PA::getOffers($args);

    if ($offers['number'] > 0)
    {
        echo '<h2 class="headline">'.Text::get('USER_OWN_REQUESTS').' ('.$offers['number'].')</h2>';
        PA::showOfferList($offers,false,false,false,false);
    }
?>
</div>
<div class="clear"></div>
<?php
PA::showFooter();
?>
