<?php

require_once BASE.'public/api/controller/APIControllerAbstract.php';
require_once BASE.'public/api/model/PlatformModel.php';
require_once BASE.'public/api/model/OfferModel.php';
require_once BASE.'public/api/model/StatisticsModel.php';

class MarktAPIController extends APIControllerAbstract
{
    protected $user = null;
    protected $offer = null;
    protected $search = null;
    protected $platform = null;

    public function __construct($request, $origin)
    {
        parent::__construct($request);
    }

    /**
    * Platforms Endpoint
    */
    protected function platforms()
    {
        $platformModel = new PlatformModel();

        $response = array();
        $response_data = array();
        switch ($this->method)
        {
            case 'POST':
                if ($this->verb == "")
                {
                    return $platformModel->insertPlatform(json_decode($this->input));
                }
                else if ($this->verb == "confirm")
                {
                    $response_data['message'] = "confirmation received! verifying data...";

                    $result = $platformModel->verifyData($this->input);
                    if ($result['status'] == 'secure')
                    {
                        $response = $platformModel->confirmPlatform($result['secure_data']);
                    }
                    else
                    {
                        $response_data['status'] = array("error",$result['error']);
                        $response['statusCode'] = 401;
                        $response['data'] = $response_data;
                    }
                    return $response;
                }
                else
                {
                    $signature = $_SERVER['HTTP_X_SIGNATURE'];
                    $data = array("status" => "error",
                                  "error" => array("type" => "Unauthorized",
                                                   "code" => "ERR-0401",
                                                   "message" => "Authentication Problem!"
                                                                ." Signature: ".$signature));
                    return $data;
                }
                break;
            case 'PUT':
                $result = $platformModel->verifyData($this->input);
                if ($result['status'] == 'secure')
                {
                    $response = $platformModel->updatePlatform($result['secure_data']);
                }
                else
                {
                    $response = array("status" => "error",
                                      "error"  => array("type" => "Unauthorized",
                                                        "code" => "ERR-0401",
                                                        "message" => "Authentication failed! Message: "
                                                        .$result['error']));
                }
                return $response;
                break;
            default:
                $data = array("status" => "error",
                              "error" => array("type" => "Method Not Allowed",
                                               "code" => "ERR-0405",
                                               "message" => "Invalid Method"));
                return $data;
                break;
        }
    }

    /**
    * Offers Endpoint
    */
    protected function offers()
    {
        $offerModel = new OfferModel();

        switch ($this->method)
        {
            case 'POST':
                $result = $offerModel->verifyData($this->input);
                if ($result['status'] == 'secure')
                {
                    return $offerModel->insertOffer($result['secure_data']);
                }
                else
                {
                    return array("status" => "error",
                                 "error" => array("type" => "Unauthorized",
                                                  "code" => "ERR-0401",
                                                  "message" => $result['error']));
                }
                break;
            case 'PUT':
                $result = $offerModel->verifyData($this->input);
                if ($result['status'] == 'secure')
                {
                    return $offerModel->updateOffer($result['secure_data']);
                }
                else
                {
                    return array("status" => "error",
                                 "error" => array("type" => "Unauthorized",
                                                  "code" => "ERR-0401",
                                                  "message" => $result['error']));
                }
                break;
            case 'DELETE':
                $result = $offerModel->verifyData($this->input);
                if ($result['status'] == 'secure')
                {
                    return $offerModel->deleteOffer($result['secure_data']);
                }
                else
                {
                    return array("status" => "error",
                                 "error" => array("type" => "Unauthorized",
                                                  "code" => "ERR-0401",
                                                  "message" => $result['error']));
                }
                break;
            default:
                return array("status" => "error",
                             "error" => array("type" => "MethodNotAllowed",
                                              "code" => "ERR-0405",
                                              "message" => "Invalid Method"));
                break;
        }
    }

    /**
    * Statistics Endpoint
    */
    protected function statistics()
    {
        $statisticsModel = new StatisticsModel();

        switch ($this->method)
        {
            case 'POST':
                $result = $statisticsModel->verifyData($this->input);
                if ($result['status'] == 'secure')
                {
                    return $statisticsModel->insertStatistic($result['secure_data']);
                }
                else
                {
                    return array("status" => "error",
                                 "error" => array("type" => "Unauthorized",
                                                  "code" => "ERR-0401",
                                                  "message" => $result['error']));
                }
                break;
            default:
                return array("status" => "error",
                             "error" => array("type" => "MethodNotAllowed",
                                              "code" => "ERR-0405",
                                              "message" => "Invalid Method"));
                break;
        }
    }
}
?>
