<?php
$data = $data['installStatus'];
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
        <title><?php echo AdminText::get('INSTALL_TITLE'); ?></title>
    <style>
    html,body{padding:0;margin:0;font-family:sans-serif;font-size:20px;color:#2b2b2b}a{color:inherit;text-decoration:none}*{-webkit-box-sizing:border-box;-moz-box-sizing:border-box;box-sizing:border-box}#logo{position:relative;left:0;right:0;margin:auto;top:0;width:300px;height:auto}#logo img{width:100%;height:auto}#content{position:relative;width:950px;left:0;right:0;margin:50px auto}.error{padding:20px;background-color:red;color:#fff}.success{padding:20px;background-color:#127f00;color:#fff}h1{text-align:center;font-size:40px}p{text-align:justify;line-height:1.5;color:#555}footer{position:fixed;bottom:0;left:0;width:100%;background-color:rgba(0,0,0,0.5);padding:5px;font-size:14px;text-align:center;color:#fff}.form_box{position:relative;left:0;right:0;margin:20px auto;width:85%}.form_label{width:40%;display:inline-block;font-size:14px;color:#555;vertical-align:middle}.form_label span{margin-top:10px;display:block;color:#ccc}.form_element{display:inline-block;width:50%;padding:20px;border:2px solid #ccc;background-color:#eee;margin-bottom:20px;font-size:inherit;}.form_element:FOCUS{border:2px solid #2b2b2b}#submit{position:relative;left:50%;width:400px;margin-left:-200px;margin-top:50px;padding:20px;background-color:rgba(0,0,0,0.5);color:#fff;border:0;font-size:inherit;cursor:pointer;text-align:left;background-image:url(data:image/svg+xml;base64,PHN2ZyB2ZXJzaW9uPSIxLjEiIGlkPSJFYmVuZV8xIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHhtbG5zOnhsaW5rPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hsaW5rIiB4PSIwcHgiIHk9IjBweCINCgkgd2lkdGg9IjUwcHgiIGhlaWdodD0iNTBweCIgdmlld0JveD0iMCAwIDUwIDUwIiBlbmFibGUtYmFja2dyb3VuZD0ibmV3IDAgMCA1MCA1MCIgeG1sOnNwYWNlPSJwcmVzZXJ2ZSI+DQo8cG9seWdvbiBpZD0iYXJyb3ctMjQtaWNvbiIgZmlsbD0iI0ZGRkZGRiIgcG9pbnRzPSI4LjcyMiw1MCAwLDQxLjMxOSAxNi4yNDMsMjQuOTk5IDAsOC42NzcgOC43MjIsLTAuMDAzIDMzLjYwNCwyNC45OTkgIi8+DQo8L3N2Zz4NCg==);background-position:center right;background-repeat:no-repeat;background-size:auto 70%}#submit:HOVER{background-color:#2b2b2b}@media (max-width: 955px){#content{width:100%;padding:10px}.form_label,.form_element,.form_box{display:block;width:100%}}
    </style>
</head>
<body>
    <div id="content">
        <div id="logo">
            <img src="data:image/png;base64,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">
        </div>
        <h1><?php echo AdminText::get('INSTALL_HEADLINE'); ?></h1>
        <p><?php echo AdminText::get('INSTALL_DESCRIPTION'); ?></p>
        <?php
        PA::showFeedback();

        if (!is_bool($data)) {
        ?>
        <form method="post" accept-charset="utf-8" target="_self">
            <div class="form_box">
                <label for="adminName" class="form_label">
                    <?php echo AdminText::get('INSTALL_ADMIN_NAME_LABEL'); ?>
                </label>
                <input type="text"
                       name="adminName"
                       id="adminName"
                       class="form_element"
                       value="<?php echo $data->userName; ?>"
                       placeholder="<?php echo AdminText::get('INSTALL_ADMIN_NAME_PLACEHOLDER'); ?>">
                <label for="adminPW" class="form_label">
                    <?php echo AdminText::get('INSTALL_ADMIN_PASSWORD_LABEL'); ?>
                </label>
                <input type="password"
                       name="adminPW"
                       id="adminPW"
                       class="form_element"
                       value="<?php echo $data->userPassword; ?>"
                       placeholder="<?php echo AdminText::get('INSTALL_ADMIN_PASSWORD_PLACEHOLDER'); ?>">
                <label for="adminPW2" class="form_label">
                    <?php echo AdminText::get('INSTALL_ADMIN_PASSWORD_REPEAT_LABEL'); ?>
                </label>
                <input type="password"
                       name="adminPW2"
                       id="adminPW2"
                       class="form_element"
                       value="<?php echo $data->userPasswordRepeat; ?>"
                       placeholder="<?php echo AdminText::get('INSTALL_ADMIN_PASSWORD_REPEAT_PLACEHOLDER'); ?>">
                <label for="adminEmail" class="form_label">
                    <?php echo AdminText::get('INSTALL_ADMIN_EMAIL_LABEL'); ?>
                </label>
                <input type="email"
                       name="adminEmail"
                       id="adminEmail"
                       class="form_element"
                       value="<?php echo $data->userEmail; ?>"
                       placeholder="<?php echo AdminText::get('INSTALL_ADMIN_EMAIL_PLACEHOLDER'); ?>">

                <label for="platformName" class="form_label">
                    <?php echo AdminText::get('INSTALL_PLATFORM_NAME_LABEL'); ?>
                </label>
                <input type="text"
                       name="platformName"
                       id="platformName"
                       class="form_element"
                       value="<?php echo $data->marketName; ?>"
                       placeholder="<?php echo AdminText::get('INSTALL_PLATFORM_NAME_PLACEHOLDER'); ?>">
                <input type="hidden" name="installNow" value="1">
            </div>
            <p><?php echo AdminText::get('INSTALL_DESCRIPTION_BELOW'); ?></p>
            <input type="submit" value="<?php echo AdminText::get('INSTALL_BUTTON'); ?>" id="submit">
        </form>
        <?php } ?>
    </div>
    <footer>
        &copy; <?php echo date('Y')?> peeragora // licensed under the <a href="https://en.wikipedia.org/wiki/MIT_License" target="_blank">MIT license</a> // <a href="http://peeragora.org" target="_blank">http://peeragora.org</a>
    </footer>

</body>
</html>
