<?php
PA::showHeader();

$user = $data['user'];

echo '
<h1 class="headline">
    '.AdminText::get('USERS_HEADLINE').': '.$user->name.'
</h1>';

if (in_array($user->company_logo_path,array(NULL,''))) {
    $img = false;
} else {
    $img = explode(':', $user->company_logo_path);
}

// DATES
if (!$user->last_login_timestamp) {
    $user_login_date = '[x]';
} else {
    $user_login_date = date('d.m.Y',$user->last_login_timestamp);
}
$user_register_date = date('d.m.Y',$user->creation_timestamp);

echo '
<div id="admin_edit_sidebar" class="admin_onethird right admin_box">';

    if ($img != false) {
        echo '
    <div id="admin_edituser_logo_box">
        <img src="'.PA::getImageURL().$img[0].'logo_medium'.$img[1].'" id="admin_edituser_logo">
    </div>';
    }

    if ($user->company_name != '') {
        echo '<b>'.$user->company_name.'</b><br>';
    }

    if ($user->company_claim != '') {
        echo '<i>'.$user->company_claim.'</i>';
    }

    echo '
    <ul id="admin_edituser_ul">
        <li>
            '.AdminText::get('USERS_REGISTER_DATE').':
            <span>'.$user_register_date.'</span>
        </li>
        <li>
            '.AdminText::get('USERS_LASTLOGIN_DATE').':
            <span>'.$user_login_date.'</span>
        </li>
        <li>
            '.AdminText::get('INDEX_OFFER').':
            <span>'.$user->offers_number.'</span>
        </li>
        <li>
            '.AdminText::get('INDEX_REQUEST').':
            <span>'.$user->request_number.'</span>
        </li>
    </ul>';

    echo '
    <ul id="admin_edituser_buttons">';


// APPROVE / DISAPPROVE USER

    if ($user->approved == 1) {
        echo '
        <li>
            <a href="'.PA::adminGetLink('disapprove_user_detail',$user->id).'" title="'.AdminText::get('USERS_BUTTON_USER_DISAPPROVE').'">'.AdminText::get('USERS_BUTTON_USER_DISAPPROVE').'
                <span>
                    <div class="admin_table_button admin_button_new_offer">
                        <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAfhJREFUeNrsmc1qAjEUhbWL0mU33fYJ+hwuRGQQEbEiIl3OSqaDzEKwIiJSitiHKPSJuu0TdFf6m96hkQ7tOHOS3KiVHDgrkzDfmJzcZIpCiMI+6KCwJ3IgDsSBOBAH8m9AAnLJwrMsyb5273hnV3AovvVMLiv2zfJC/MjXGUMHYqUXcoUB4lr8lW8LJBTpimGqBhBzsV4+N0goshXDeBoQU5EvGAZZ7Cc5vx+S78l1haU5IQ9y2rySH7kX+wx4e2/kBjDWCBzLs7XYJ+ADtDLGGIJj1GymVuwx+CDtlL4R2LduO35VpsYHuaMQGCpTkw0EnSIxTI8cgBBNk/3IZCOLQBikTct0YzXdlQfCTL+n4NZA0Pm/DqLLVa9xFX2BBkSPsehkA4ndV4C44IRASxRUT+RP8Ax0zH6aYXojHTChkgp3bWq1NSBWinYFpCk3MxMNtw3SACGQf2u0LZA6CNGXCYXATDYN4oEQQaJPD4SZbgqkKo+2OonUBWHmtkEqIMSAIaZvbIGUQQgkTlvg1Fxwg5TkhRxnjKKxveQsUc7IRzltrqRR3ZHPye857R64S5SsUn1sEJtZMe6LDV2ZGme/dC0Fxrcdv0mYGWPR5yXCROsSu6jxnT2Ut4+XzIV4lXxKvtXprAPivlg5EAfiQByIA9k7kC8BBgCKs4YFhJC+fgAAAABJRU5ErkJggg==">
                    </div>
                </span>
            </a>
        </li>';
    } else {
        echo '
        <li>
            <a href="'.PA::adminGetLink('approve_user_detail',$user->id).'" title="'.AdminText::get('USERS_BUTTON_USER_APPROVE').'">'.AdminText::get('USERS_BUTTON_USER_APPROVE').'
                <span>
                    <div class="admin_table_button admin_button_new_offer">
                        <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAbhJREFUeNrsmbFKA0EQhpMjhCBi4VNYXiEWFiJiESGIpAhW2qSwEBEMCOlstLISC7EIFiJqkUKs1MLCh7FKREWD6PmvKGxxXGZn9/ZimIGvSXY2+2U3ezMkH0VRbhgiyA1JiIiIiIiIiIiIiIiIpBMjYPy/i5TAFbjjygQDItEGcyDkymQtUgSXoKy9xpLJUqQAzkAl5j1jmSBDiVNQTRgT/u7WwIqoz2yBWp9xXbBNnlW1uh4JQCvqH09gymRu3xJHBIlnMG06P2dBk2CCkXdAlJjhfFEciQ54BKFB3j5B4hXMcnecI/EXHeIR2CNIvIF5m6PLldCPQtICdogSZdvfoI2EvpDFmLwmQaIHKi4uE8qgG8KCPsCyltMgSiy5uhUpg8bAA2Fhn6AONojiVZfXO3XgKLiP3ISSqLl+TlFLlBewAG4ty5MvsAounBc+huYlcM3cCXX0VtKqHDhJRdBmSNTTLIG4iQVwbiCylnYtZ5OsZE4IEus+ilIXFe1xgsSmr+raVXl+GCPR8NnruJxMr3Cbnhu2n97ZVWyBd9ADu77757z8qysiIiIiIiIiIiIiIpJafAswAObe2SRr3ERmAAAAAElFTkSuQmCC">
                    </div>
                </span>
            </a>
        </li>';
    }


// ADD NEW OFFER

    if ($user->profile_id != '') {
        echo '
        <li>
            <a href="'.PA::adminGetLink('new_offer',$user->profile_id).'" title="'.AdminText::get('USERS_BUTTON_NEW_OFFER').'">'.AdminText::get('USERS_BUTTON_NEW_OFFER').'
                <span>
                    <div class="admin_table_button admin_button_new_offer">
                        <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAlNJREFUeNrsmUsoRUEYxx3ksdBVuBuFDRvJrWsla/JYWFmyIisWrGQlS+VaKGUjsbAjkaxQFspzoyiUR0ld180zcY//1CxupzmaOeebc+s2//ptpjlz5n+a+eab71i2bedkg3JzskTGiDFijBgjxogx4kf5xOMVgBbQDqKgCoSABV7BPTgG22AHvJO9maUoBJSCfnBqy+sCjIAKijlQmOjkk/KqW9CbaSPjNp1ioDATRuZseq2CvCCNjNv6FPMyJ8vDfYRFpE2JfpdgKD2ugAYwJfHsAJjXGbVC4Ebyyx4Inm+SfDYBKlXmpnog9oAaH4dtseSzpWBQ18leCIYDPKzZ8irXYaQZ1AdoJAw6dRjpUpxIEUFuJ/1OlVwr+k90SvJ8Kl3ngr6s36Eo5oBavjfSVacjal27RJhWonxtTTD2nY6oVaJ5T9g+opySEUuxXVW+xlEx8ubS/kVk5NfP2Cqb/QFUC9qbQErwddlF6sTRzi5ZjS7LKCxoS+gwcsTPEqfccqczEHG0RfjNUFZXOpbWluJS+RG0pRTH2NJhZBfc+IxCKmJnzroOI6xQMBtgirLI96WWctACeAzAxAeY1lnXioNRyb4pH+F0UnEZe7ohMs04bn8ivYA9x54p43Wv/7QM+lzOFXIjrBC3ArqJl9Q+aPNSuPNaMv3mt8UYoYklXg/wVn0kyFoHwJOPqkkSjAEr05VGRhWYAA8KBuK89FNLMQeL+Pd0mC+PDn5RKuepOMu9PsEzTztYEXsD3FG92DL/2Y0RY8QYMUaMEWMki4z8CTAAE8027VDVa2oAAAAASUVORK5CYII=">
                    </div>
                </span>
            </a>
        </li>';
    }


// EDIT USER

    if ($user->profile_id != '') {
        echo '
        <li>
            <a href="'.PA::adminGetLink('profile_edit',$user->profile_id).'" title="'.AdminText::get('USERS_BUTTON_USER_EDIT').'">'.AdminText::get('USERS_BUTTON_USER_EDIT').'
                <span>
                    <div class="admin_table_button admin_button_edit">
                        <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAnBJREFUeNrsmcsrRFEcx2e884iJpEQoj6xGVjaU8SiPDbKwURYW/AUW/gF/gB15FCUsJPYI2dAgEkNeU0IhFuNxfY9+U8d053HPzL1zjfOrT7r3nnPP+d7f75zfbw6roiiWWLA4S4yYFCKFSCFSiBQihcSCkG4wA6yiL0gQ6FMKEoHW2oZNMhm4wBN3vw6MgXTwBgaAR/OsWK2lkXPgEYDZFsjm3tUCXpXfNiswJyEhN4qYbYNC7j2N4NFP2wmQomVeIqH1RX8/wX4IYcBC6g70gge61wCWQIqfPqxtEujRc414jcVzC3Br7NcKpgKI8Fql3os9HGMLez4EEWeg08jtV0v/9iDh5LUDUE9iTOeROsoT6UHaHZMnLo3IIxaBNTEHUoO0OwEOcGu2zG6lzWA6BBH7FHq3ooPp6REbZWxbkHYuEnxt1lrrkeI90FfeA02ciGbKIaYRMkJ5YJMKwgeVNqegg9ud7GARlAmNKFCiXFEZ8QzyVZ5nUv10BorpXhW440oQJyjg+tQANz0bEqm19PBIMeWKErBC17ugi8LNm+yuuD7MM3ncJmGKxV7NhWwFWAVtYA3UgheVPOEJd1A9POLwuS4HCyAXHIoku2h4JIMq21dwBHbABuWJZz2zbqSFMA/3Ub10YWQ1Gmkh7Cfs8n8+fPCYzSOhfjyWwTO5Awz7XxUyCor8PE/6S6H1FuA8wBkNIR+CffydifVRvWVoaLFSIge8a+wXrzIuO5EZBJPRWCNpYJ07HtJiWT7X/WDc6MWewHnEFmZofkZChKiQe9GdRWVhD0dCxM9Xlf9nl0KkEClECpFCpJAYEvItwACdD1Yi76gx9AAAAABJRU5ErkJggg==">
                    </div>
                </span>
            </a>
        </li>';
    }


//VIEW USER

    if ($user->active != 0 && $user->profile_id != '' && $user->company_name != '') {
        echo '
        <li>
            <a href="'.PA::adminGetLink('user_view',$user->profile_id).'" title="'.AdminText::get('USERS_BUTTON_USER_VIEW').'">'.AdminText::get('USERS_BUTTON_USER_VIEW').'
                <span>
                    <div class="admin_table_button admin_button_preview">
                        <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAsFJREFUeNrsl0tIVUEYgL3XwjKxXBhBCpHVokWWKRHRJgIp6bnQoBbVXYZQG1u4KKKoFkVhbSKCHrYKBKOgTS3TyMAiei2iB/QwNDIf2b339E38B36Gi+mJU5f6Bz5G58yZ+b9zz/wzJxEEQcG/UBImYiImYiImYiImYiImYiIm8t+JBJmM31QJK2EpVEEZJGEQXkEvdMGTnwEUFuaVyFTYBClYDTN+cZu7qQeuQDsy/fkgspHqANR4l8ZgAIYgC8UwS2pdXsNJOIfQyB8XQWA+VRusV8190Akd8sSdSAkUyavlXrEl0ABbYaG69xHsReZ2tIAQmSzZdHoNfIBAGICDMAcKhGq4Bm+hD3pgj7o+HXbBCzVOGlJRYooisQW+qslvwiIVoGMnfFN9NJ0wTfUtg1MiEfZpjVWECTZDViZz9T5PwLF4HImQM2F/NfY6+KT67I9FhIFXwBeZZBCapN2nTQXzHhqhFtpV+zBUahEZa5n3ym6LQ+SemuCQavfpVv1Sqr3Ue+INvoiM16h+9ZcTjS85ibxwWNKoK02StXIVvcMNqb+/y/4Rlik5MqGLZ7fLptJ0NpasxRNqUU/0OVTl+EUuqD4uI62CCjih2sdggbdGEnBe9elwbXFmLR3oM1juidRBxlvcw97/l/Ripy72xn0K5bGmX5n4tJp0FJo9mZZxMtZdWS9h3xrZY8LrD90vGPs+omSOegHekuwUBlgPXTAii9dtjMehSK7PdPuFZMBwjN4oEo7fOmuxOHdQHYO50pSG63AVuuEjzJYjSr9cr4Z62A7z1HAX5Yjy+W8dGl2gRyTbJL0T7ht4JxmrXI74Jd4Q7ljfisCNfPkeqXVPFDZA6QRuve9OvHAZidF8/LByr9laqIMKkUrKnuJetcdwBx642/Pmw8q+2U3EREzEREzEREzEREzEREwkYvkhwAD4ho8lKnZL5AAAAABJRU5ErkJggg==">
                    </div>
                </span>
            </a>
        </li>';
    }


// FEATURE USER

    $feature_img = array(
    'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAoBJREFUeNrs2F9oTmEAx/Gz14v9lZRNJGZtF1otosg0Ui4oF9qd7AYX4lJLXMgNam5ccEGupCgpZUVZjRLyP4xy4+LVZlmjhM07x/ep3/J02ptTntP7mOepT2fPe87Z8/x29j5/TkUcx9F0KLlompQQJAQJQUKQECQE8TnINrxFAbuybKjC8RKlFV2YjSZsMW1Y5/vxXD9fwn0fg1ThhQKYMoE7eIgi2rAJlTo/pOAjTlo3QRzpiH+Xq1iMKrSiDXWYj/PWdTtdte8qRBOeqXMn9NkBDFud/oxjOrdPnxWw2pcgm/FJHbuhz07Hpcs1XXNO9R/Y4UOQXquTK9AZ/7l0o8Wq9/1tP1wMvwM6fsAb7E1xjxmK3+O16gUf5pHrOo5iBppT3LMEtXinep8PQRp0nImf+J7injENyZWJ31HWIJ061ivM3RT3PMU4lqu+0YcgX3Ssw3YctT4rVQ6j3XoS33yYEOs17E7OC/OwFeMlRqw9yOGJ6o/Q7MuEaJxUx16hUQGP4Bb60YNlmKu6KZcVKvIpiPmrjqmDo9iPRZgjDejCoPV01vu2RJl0MfFvNKFQIygmzvW6bNv1Mt4s31dhFpbiIFp0bhDHtUI2jT5OMSiUbT+SLGYk240anMXwv7KxMjP7Ws0nD/B1iie2RtfdczLsZrAfifSlHtJ3wIxM7ahBNVbiis4VNYI5azvv+AnHYkoHbmsnaJYuC5C3rnNa8lG2xawcFobXQSFICPJ/BDE7yDNZN5L1qNWDQ9oNms3UKVRn0lIGE+JHvc/aMMV587JuQJOi0wkxl8ETvol1es+bLC+1M7ygZYq3a60waoUgIUgIEoKEICFIOcsvAQYAohGFqiZVeVYAAAAASUVORK5CYII=',
    'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAv9JREFUeNrsmU1IVUEUx69fT81elJBCEeUzpUKQoiDBqBBaZLUId5EU1SJyGSG0iCBKqm2bPrAWQd8QJLRIkKAv+qanFpEUPdEkMSEq7dntf+D/aBjuzUtevZPMgR/XmbnjzN+558yZMct1XWc6WLYzTcwKsUKsECvECrFCTBayBbwFKbBrMgfKCjlFqQKNIB+Ug40yhtLeAV7y50vgoYlCCsErChAbA3fBY5AG1aAOFLC9n8IHQxldhITEWveP3QALQCGoAtUgDuaCc8p728MaPywR5eAFJ9fCuv1gQJn0MDjKtn2sS4FVpgjZAL5wYrdZd8r1t5t85wzLP8E2E4S0KZNcDhrc8e0AqFTK7ROdRxjht4vPT+A12Bugj4TiXtDNcsqEfeQWn0MgB1QE6LMQzATvWW43QUgpn3ngF/gRoM8IQ3KB9jsiFdLAZwnF3AvQ5zkYBctYXm+CkK98xsFWcFip87ODoFZZie8mbIglDLuZfaEY1INRn4i1B2SDZyw/ARWmbIjCSU6sE5RR4CFwB3SAEyABZrMsdpmiHJOEyF91hBMcAk1gPphFSkEj6FNWZ41pKUqGi9pnNEZRgyCttbWFOXbYabyk7ytBDCwCzaCSbX3gGDNkGfRpgKAQ2XlEN4lku0EROA0G/peDlezsNdxPHoFvHiu2mu898Am70rcFXAf3oziPOHTqfvqARKZaUARmgBXgGtvSjGB6/zxwXgnlNVE5e1yLSuLsveAj03VXSd0THiJatYAQOCvOnYLLjXmghzt+xpo9PifxoR1KnWTSTUEHmmwhDkVIPjYMdoIj4AMjl5+IN6CefSPxEf3TcnnQSigpyQUQ47sxxScy1s2jc6Qbop+Qq1pdKy8iznqISJiws/sJWQKSWn2PVu76l5UI86g7ntXRPzaDTqW+THPsTeCdCfdaXityHOSybQ6z4qTHSiw2LWmUDfEz77PWebTn0weSE3HsqRBSzAz4bwelHF4FXQFLTc1+7f9HrBArxAqxQqwQKyRK+y3AABOITItWZwXrAAAAAElFTkSuQmCC',
    'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyZJREFUeNrsmUloFTEYxzODdYGK0lZFD4ILuCBY9CSCZ0URkepBwYMelLogiK8qpcdWnx5KUVxKUdzwZlUQd0TEkyBYrLQKHvUkLi3FhTf+P/kGYkhmJvNm3quPBH7MTCbJy6+Z+ZJMvSAIRC0kX9RIciJOxIk4ESfiRKoqEq4MdCsEyguJaWMnDgd0df+nEdkC+kBz2X9RC+aAAjgO1lFeqVQS8lGG8kIM7W0HX0ARTAY9YLNcN2nfbCQWgDfBv+lgGSJ7uI1uvr4ARsFKruvlJXI60Kc2U2cjRNZy3T5Qh/u9OP4EzWAWuIO8xXmJ9AfmVLQQ2U8VkFfg62vgM1gOlvH5JeCTTB4inUF0aksgso3Lnufri+A7oA5PZ4lbfK8DfMtDhF70xzEyJyNEwhf7Pbd1nTu+GiwFg6CXyx4DP8DezEX4B6aBZ1EmKNeuqb9bKvILvAMfwBIwj0flNpc9Cn6DjTYR1VaEWAjexowMdcaT6u8CY5rRo5EZ4PdP8ONJqdVyWkglQswE92Jkikoba8An6T5Fqa/gnCRBeS22EuWIEI1gKEbmsFKHJruSUoaCyCE+32oTcrMSEfyMP4+R6VLqtigjQ2kMZVptZ/PMRJIGAKQjSv1VYITvjeLehgTLmdxFiEUcPo3BTDPP7AAfwT5ZotoigpcWd2NG5oRSZ4bFArNiImEAGLRdAVRdRL3HR3rMniYIzZ5JJI1UpiISUxMEgPZxJwKm8Gw8W9m/hI/ZCC9JdCuAyovIj5B0TY/IZe7YK35P5ABwE2wCTeCJRubUeBE5q3SMOtsg1fWl8/lgWLcCqKZIHe8n1NSPe00RnTAFg06185UQ8TUjEfB+ZWLUX5PzaRP1WvfOVFKERuKMphMP+D0QCUQE7woHNO0Ucv2Kwg1PkF5sOV0Fk3SjFxX9cN5o2A505fk5yDd8SXnEj4pIIULM1awGaIe4PpeZnffParqiSqQQEbzdfRg1YWYp0qH80H2aQ3SdTiFC1IOXuKa2XyghPFORev6gRkvvG/jBBlOnU4r8XQ3jekUYNGzw3P/ZnYgTcSJOxIk4kRoS+SPAAD1/oqrEgLSSAAAAAElFTkSuQmCC',
    'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA4dJREFUeNrsmUloFEEUhntG4xoXYuKGCKK4Rkz05IKoJ0XxIFFBxYMiSlwQxEQlBLy4jBcRxWUISqKSSzAacENFRLwIGlETJaIeBJeDuCQEF6b9H/wNZVG9mekJhn7w0dO1vK4/Vf3qVSdh27bVEyxp9RCLhcRCYiGxkFhILKRbhTiZgSlDkDIHHx8bcNlh6vs/zchKUANKuvwXDcFoUAEOgSVSlslkLPWqImUOLv7Wgi8gBfqBY2CF2jfo2MKIGA+e23/bzi4I2UIfR3l/BnSAWeybiErIcdtslW6D9RCymH1rQB7q07j+BCVgBGhC2eSohDTa7pYKIWS7dEBZBe8vgM9gBijm73MgKWKiEHLA9rbKAELWsO1p3p8F34EMeChFXGZdNfgWhRB50W/7iDniIcR5sV/R10UOfC6YClpAmm33gR9ga9aF8AFDwD0vJWhXZei/WWnyC7SBN2AKGMdZucK2e8FvsDxMRA0rRJgAWn1mRgaTUPpvBJ2G2ZOZecr3z+LyFCsPuS38kxBhOLjuIyal+ZgPPij1EqW+glOKCCkrCyuiK0KEYeClj5jdWh/Z7DJaGwkiu/h7VZiQmy0hFtf4fR8xB7W+ZdrMiHWiTXnY3TxrQoIGANgerf9s0M66DtQtC5DORC5EmMTw6RrMDPvMevAebFNFdLcQi6nFVZ+ZOaz1KQqRYOZMiBMAWsJmAN0uRK/jVZbZ3QChOWESEvSZkQpRGBQgAFS5+BjMRHJhzmcE9OduPEo7vzjLrJ0piSkDUP3kg2us+wgWRSJEXULKvSyRWj78Md8TNQBcAvPAAEaqanX/ANPZdiDzLdWacinkpPbwO6BA6Zsw+NvEdGQ17+WY26D5eQjG5EJIHs8TujWirtCwFBeA/cr9Ol7FT73m45G2TCMTkjTMhM3zSh9DBJKl9Ylt5GyeZHkvUKf5aGZWHF3UomP5C54wiLgJCl1CabPWtpZt01r5EzA20q8odNxbebFVOw/6euwJc8A7rc9b7f4ZD1nSfmSUn4OSLl9SbvG87bm5gVLD4B1r5YFN2k3jCXJpJO8Iz8+61ekifJZFMc/sqrUxG7D4EaLNtGFmU0i1NoAbElrdUguPZSGDfkEfrzl4Z8Yb0E/KH2ghPKtC8vlBTVLvejywwCtH8lnfE7nZlWrlReg30wkaYUjE/2ePhcRCYiGxkFhILKQHCfkjwAAM377CPygTTwAAAABJRU5ErkJggg=='
    );

    if ($user->admin_featured != 1) {
        $feature_text = AdminText::get('USERS_BUTTON_USER_FEATURE');
        $feature_image = $feature_img[0];
    } else {
        $feature_text = AdminText::get('USERS_BUTTON_USER_UNFEATURE');
        $feature_image = $feature_img[1];
    }

    if ($user->other_featured != 1) {
        $other_feature_text = AdminText::get('USERS_BUTTON_USER_FAETURE_OTHER');
        $other_feature_image = $feature_img[2];
    } else {
        $other_feature_text = AdminText::get('USERS_BUTTON_USER_UNFAETURE_OTHER');
        $other_feature_image = $feature_img[3];
    }

    echo '
        <li class="admin_user_buttonlist_gab">
            <a href="'.PA::adminGetLink('feature_profile_detail',$user->profile_id).'" title="'.$feature_text.'">'.$feature_text.'
                <span>
                    <div class="admin_table_button admin_button_delete">
                        <img src="'.$feature_image.'">
                    </div>
                </span>
            </a>
        </li>';

    echo '
        <li>
            <a href="'.PA::adminGetLink('other_feature_profile_detail',$user->profile_id).'" title="'.$other_feature_text.'">'.$other_feature_text.'
                <span>
                    <div class="admin_table_button admin_button_delete">
                        <img src="'.$other_feature_image.'">
                    </div>
                </span>
            </a>
        </li>';


// DELETE USER

    if ($user->profile_id != '') {
        $deleteLink = PA::adminGetLink('user_delete_profile',$user->profile_id);
    } else {
        $deleteLink = PA::adminGetLink('user_delete',$user->id);
    }
    echo '
        <li class="admin_user_buttonlist_gab">
            <a href="'.$deleteLink.'" title="'.AdminText::get('USERS_BUTTON_USER_DELETE').'" class="delete_button">'.AdminText::get('USERS_BUTTON_USER_DELETE').'
                <span>
                    <div class="admin_table_button admin_button_delete">
                        <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAAyCAYAAAAeP4ixAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAbZJREFUeNrsmE1KAzEYhiftWBUrqCAURRAvIXgDEcWtC7cqLt14AcG9Sw8gLl0KnsGtK6GrgpTWH9BarTa+wSximGFoTMaxvIGH0sxP5pl8mSSfkFJGw1BK0ZAUilCEIhShCEWKKLIB3kDbogf2QzQoHJYoY6ACki7sg1lwDpZTrr8Fm6AOyknPBN5BN7TIMdgFnZTjM2A84x6qt1opxybAKTgc5KFih16cNnAto2A+o40otMirDqGXQOOrOmhYuYbWlG4s1PpfjZFn8BhapJAldrxuBJyBGvjwOBWokNoC93mJqEZXwJznF9vVH4LcJsRQ8Shd7+1zZv8EV6Bh1d+Aa6tOhc6ly9cp/RVgsDtQAQ35s1zoY6tGXQ8sgipoGvU7+twT6x4dUHN5Jp890ta/LWsGf9KfU3PeaSac+y9WvyLjP5fxFKEIRShCEYpQ5A9EZOhtgE+ROGGzVjIoWzvM32zsvO0Qk8oa2APrRp3Kbx3pRMKCUX8AJsG2t1WpY/JBZRrrAba6KtW0BO7yCi0RcDyJPENLdeND9J3f8plFUWnYfp6hxXmEIhShCEUoQpEili8BBgAwzfiS5i1EyAAAAABJRU5ErkJggg==">
                    </div>
                </span>
            </a>
        </li>
    </ul>
</div>';

echo '
<div class="admin_twothird left admin_box">';
?>
    <form method="post" action="<?php echo PA::adminGetLink('user_edit_action',$user->id); ?>" name="edit_user_form">
        <label for="userName" class="form_label">
            <span>
                <?php echo AdminText::get('REGISTER_INPUT_PLACEHOLDER_USERNAME'); ?>
            </span>
        </label>
        <input type="text"
               name="userName"
               class="form_element"
               placeholder="<?php echo AdminText::get('REGISTER_INPUT_PLACEHOLDER_USERNAME'); ?>"
               value="<?php echo PA::formValue($user->name); ?>">

        <label for="userEmail" class="form_label">
            <span>
                <?php echo AdminText::get('REGISTER_INPUT_PLACEHOLDER_EMAIL'); ?>
            </span>
        </label>
        <input type="text"
               name="userEmail"
               class="form_element"
               placeholder="<?php echo AdminText::get('REGISTER_INPUT_PLACEHOLDER_EMAIL'); ?>"
               value="<?php echo PA::formValue($user->email); ?>">

        <a href="<?php echo PA::adminGetLink('user_change_password',$user->id); ?>">
            <div class="button"><?php echo AdminText::get('USERS_CHANGE_PASSWORD'); ?></div>
        </a>

        <input type="submit"
               name="saveProfile"
               value="<?php echo AdminText::get('PROFILE_SUBMIT_VALUE'); ?>"
               class="form_submit">
    </form>
</div>
<?php
PA::showFooter();
?>
