<?php

class Theme
{
    private static $theme;

    public static function get($key)
    {
        if (!self::$theme)
        {
            self::$theme['NAME'] = Config::getFromDB('MarketUsedTheme');
            self::$theme['PATH'] = Config::get('PATH_THEMES')
                .Config::getFromDB('MarketUsedTheme').'/';
            self::$theme['URL'] = Config::get('URL') . 'themes/'
                .Config::getFromDB('MarketUsedTheme').'/';
        }

        return self::$theme[$key];
    }

    public static function getThemes()
    {
        foreach(glob('../public/themes/*', GLOB_ONLYDIR) as $dir)
        {
            $dirs[] = basename($dir);
        }
        return $dirs;
    }

}
