<?php

require_once(BASE."public/api/model/BaseModel.php");

class StatisticsModel extends BaseModel {

    public $error = null;

    public function __construct()
    {
        parent::__construct();
    }

    public function insertStatistic($statistics)
    {
        if ($this->createStatisticsTableIfNotExists())
        {
            $statistics->platform_id = $this->getPlatformIDByUUID($statistics->own_uuid);
            $prefix = $this->get('db_prefix');
            $query = $this->connection->prepare("INSERT INTO ".$prefix."statistics
                                                    (platform_id,
                                                     users,
                                                     offers,
                                                     requests,
                                                     connections,
                                                     searches,
                                                     created)
                                                 VALUES
                                                    (:platform_id,
                                                     :users,
                                                     :offers,
                                                     :requests,
                                                     :connections,
                                                     :searches,
                                                     NOW())");
            $query->bindParam(':platform_id',    $statistics->platform_id,   PDO::PARAM_INT);
            $query->bindParam(':users',          $statistics->users,         PDO::PARAM_INT);
            $query->bindParam(':offers',         $statistics->offers,        PDO::PARAM_INT);
            $query->bindParam(':requests',       $statistics->requests,      PDO::PARAM_INT);
            $query->bindParam(':connections',    $statistics->connections,   PDO::PARAM_INT);
            $query->bindParam(':searches',       $statistics->searches,      PDO::PARAM_INT);

            if ($query->execute() && $query->rowCount() > 0)
            {
                $status = array("status" => "success");
                $this->updateSuccessfulSyncStatus($statistics->platform_id);
            }
            else
            {
                $status = array("status" => "error: ".json_encode($query->errorInfo()));
            }
        }
        else
        {
            $status = array("status" => "error");
        }
        return $status;
    }

    private function createStatisticsTableIfNotExists()
    {
        $tablename = "`".$this->get('db_prefix')."statistics`";
        if ($this->connection->query("SHOW TABLES LIKE '".$tablename."'")->rowCount() > 0)
        {
            return true;
        } else {
            $created = $this->connection->query("
                CREATE TABLE IF NOT EXISTS ".$tablename." (
                  `id` int(11) NOT NULL AUTO_INCREMENT,
                  `platform_id` int(10) NOT NULL,
                  `users` int(10) NOT NULL,
                  `offers` int(10) NOT NULL,
                  `requests` int(10) NOT NULL,
                  `connections` int(10) NOT NULL,
                  `searches` int(10) NOT NULL,
                  `created` datetime NOT NULL,
                  PRIMARY KEY (`id`)
                ) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;");
            return $created;
        }
    }
}
?>
