<?php

require_once(BASE."public/api/model/BaseModel.php");

class OfferModel extends BaseModel {

    public $error = null;

    public function __construct()
    {
        parent::__construct();
    }

    public function insertOffer($offer)
    {
        if ($this->isNotDuplicate($offer))
        {
            $offer->platform_id = $this->getPlatformIDByUUID($offer->own_uuid);
            $prefix = $this->get('db_prefix');
            $query = $this->connection->prepare("INSERT INTO ".$prefix."offers
                                                    (type,
                                                     title,
                                                     detail,
                                                     tags,
                                                     price,
                                                     currency,
                                                     unit,
                                                     image,
                                                     status,
                                                     cat1,
                                                     cat2,
                                                     cat3,
                                                     zipcode,
                                                     external,
                                                     external_url,
                                                     external_id,
                                                     external_platform_id,
                                                     created,
                                                     modified)
                                                 VALUES
                                                    (:type,
                                                     :title,
                                                     :detail,
                                                     :tags,
                                                     :price,
                                                     :currency,
                                                     :unit,
                                                     :image,
                                                     3,
                                                     :cat1,
                                                     :cat2,
                                                     :cat3,
                                                     :zipcode,
                                                     1,
                                                     :external_url,
                                                     :external_id,
                                                     :external_platform_id,
                                                     :created,
                                                     :modified)");
            $query->bindParam(':type',                  $offer->type,                 PDO::PARAM_INT);
            $query->bindParam(':title',                 $offer->title,                PDO::PARAM_STR);
            $query->bindParam(':detail',                $offer->detail,               PDO::PARAM_STR);
            $query->bindParam(':tags',                  $offer->tags,                 PDO::PARAM_STR);
            $query->bindParam(':price',                 $offer->price,                PDO::PARAM_STR);
            $query->bindParam(':currency',              $offer->currency,             PDO::PARAM_INT);
            $query->bindParam(':unit',                  $offer->unit,                 PDO::PARAM_INT);
            $query->bindParam(':image',                 $offer->image,                PDO::PARAM_STR);
            $query->bindParam(':cat1',                  $offer->cat1,                 PDO::PARAM_INT);
            $query->bindParam(':cat2',                  $offer->cat2,                 PDO::PARAM_INT);
            $query->bindParam(':cat3',                  $offer->cat3,                 PDO::PARAM_INT);
            $query->bindParam(':zipcode',               $offer->zipcode,              PDO::PARAM_STR);
            $query->bindParam(':external_url',          $offer->external_url,         PDO::PARAM_STR);
            $query->bindParam(':external_id',           $offer->id,                   PDO::PARAM_INT);
            $query->bindParam(':external_platform_id',  $offer->platform_id,          PDO::PARAM_INT);
            $query->bindParam(':created',               $offer->created,              PDO::PARAM_STR);
            $query->bindParam(':modified',              $offer->modified,             PDO::PARAM_STR);

            if ($query->execute() && $query->rowCount() > 0)
            {
                $status = array("status" => "success");
                $this->updateSuccessfulSyncStatus($offer->platform_id);
            }
            else
            {
                $status = array("status" => "error: ".json_encode($query->errorInfo()));
            }
        }
        else
        {
            $status = array("status" => "success");
        }
        return $status;
    }

    public function updateOffer($offer)
    {
        $offer->platform_id = $this->getPlatformIDByUUID($offer->own_uuid);
        $prefix = $this->get('db_prefix');
        $query = $this->connection->prepare("UPDATE ".$prefix."offers
                                             SET type                   = :type,
                                                 title                  = :title,
                                                 detail                 = :detail,
                                                 tags                   = :tags,
                                                 price                  = :price,
                                                 currency               = :currency,
                                                 unit                   = :unit,
                                                 image                  = :image,
                                                 cat1                   = :cat1,
                                                 cat2                   = :cat2,
                                                 cat3                   = :cat3,
                                                 zipcode                = :zipcode,
                                                 external_url           = :external_url,
                                                 external_id            = :external_id,
                                                 external_platform_id   = :external_platform_id,
                                                 created                = :created,
                                                 modified               = :modified
                                             WHERE external_id = :external_id
                                               AND external_platform_id = :external_platform_id
                                             LIMIT 1");
        $query->bindParam(':type',                  $offer->type,                 PDO::PARAM_INT);
        $query->bindParam(':title',                 $offer->title,                PDO::PARAM_STR);
        $query->bindParam(':detail',                $offer->detail,               PDO::PARAM_STR);
        $query->bindParam(':tags',                  $offer->tags,                 PDO::PARAM_STR);
        $query->bindParam(':price',                 $offer->price,                PDO::PARAM_STR);
        $query->bindParam(':currency',              $offer->currency,             PDO::PARAM_INT);
        $query->bindParam(':unit',                  $offer->unit,                 PDO::PARAM_INT);
        $query->bindParam(':image',                 $offer->image,                PDO::PARAM_STR);
        $query->bindParam(':cat1',                  $offer->cat1,                 PDO::PARAM_INT);
        $query->bindParam(':cat2',                  $offer->cat2,                 PDO::PARAM_INT);
        $query->bindParam(':cat3',                  $offer->cat3,                 PDO::PARAM_INT);
        $query->bindParam(':zipcode',               $offer->zipcode,              PDO::PARAM_STR);
        $query->bindParam(':external_url',          $offer->external_url,         PDO::PARAM_STR);
        $query->bindParam(':external_id',           $offer->id,                   PDO::PARAM_INT);
        $query->bindParam(':external_platform_id',  $offer->platform_id,          PDO::PARAM_INT);
        $query->bindParam(':created',               $offer->created,              PDO::PARAM_STR);
        $query->bindParam(':modified',              $offer->modified,             PDO::PARAM_STR);

        if ($query->execute() && $query->rowCount() > 0)
        {
            $status = array("status" => "success");
            $this->updateSuccessfulSyncStatus($offer->platform_id);
        } else {
            $status = array("status" => "error: ".json_encode($query->errorInfo()));
        }
        return $status;
    }

    public function deleteOffer($offer)
    {
        $offer->platform_id = $this->getPlatformIDByUUID($offer->own_uuid);
        $prefix = $this->get('db_prefix');
        $query = $this->connection->prepare("DELETE
                                             FROM ".$prefix."offers
                                             WHERE external_id = :external_id
                                               AND external_platform_id = :external_platform_id
                                             LIMIT 1");
        $query->bindParam(':external_id',           $offer->id,                   PDO::PARAM_INT);
        $query->bindParam(':external_platform_id',  $offer->platform_id,          PDO::PARAM_INT);

        if ($query->execute() && $query->rowCount() >= 0)
        {
            $status = array("status" => "success");
            $this->updateSuccessfulSyncStatus($offer->platform_id);
        } else {
            $status = array("status" => "error: ".json_encode($query->errorInfo()));
        }
        return $status;
    }

    private function isNotDuplicate($offer)
    {
        $offer->platform_id = $this->getPlatformIDByUUID($offer->own_uuid);
        $prefix = $this->get('db_prefix');
        $query = $this->connection->prepare("SELECT id
                                             FROM ".$prefix."offers
                                             WHERE external_id = :external_id
                                               AND external_platform_id = :external_platform_id
                                             LIMIT 1");
        $query->bindParam(':external_id',           $offer->id,                   PDO::PARAM_INT);
        $query->bindParam(':external_platform_id',  $offer->platform_id,          PDO::PARAM_INT);
        if ($query->execute() && $query->rowCount() > 0)
        {
            return false;
        }
        else
        {
            return true;
        }
    }
}
?>
