<?php

/**
 * PageModel
 *
 */
class PageModel
{
    public static function getPage($page_slug)
    {
        $prefix = Config::get('DB_PREFIX');
        $database = DatabaseFactory::getFactory()->getConnection();

        $sql = "SELECT id,
                       slug,
                       title,
                       body,
                       sort_index,
                       status,
                       created,
                       modified
                FROM ".$prefix."pages
                WHERE (slug = :page_slug OR id = :page_id)
                  AND status > 0
                LIMIT 1";
        $query = $database->prepare($sql);
        $query->bindParam(':page_slug', $page_slug, PDO::PARAM_STR);
        $query->bindParam(':page_id'  , $page_slug, PDO::PARAM_INT);
        $query->execute();
        $page = $query->fetch();
        return $page;
    }

    public static function getPages($active = true)
    {
        if ($active === true)
        {
            $status = 1;
        } else {
            $status = 0;
        }
        $prefix = Config::get('DB_PREFIX');
        $database = DatabaseFactory::getFactory()->getConnection();

        $sql = "SELECT id,
                       slug,
                       title,
                       body,
                       sort_index,
                       status,
                       created,
                       modified
                FROM ".$prefix."pages
                WHERE status > :status";
        $query = $database->prepare($sql);
        $query->bindParam(':status',    $status,    PDO::PARAM_INT);
        $query->execute();

        $pages = array();

        foreach ($query->fetchAll() as $page) {
            $pages[$page->id]               = new stdClass();
            $pages[$page->id]->id           = $page->id;
            $pages[$page->id]->slug         = $page->slug;
            $pages[$page->id]->title        = $page->title;
            $pages[$page->id]->body         = $page->body;
            $pages[$page->id]->sort_index   = $page->sort_index;
            $pages[$page->id]->status       = $page->status;
            $pages[$page->id]->created      = $page->created;
            $pages[$page->id]->modified     = $page->modified;
        }

        return $pages;
    }

    public static function savePage($page_id)
    {
        $values = array('pageSlug'                      => 'slug',
                        'pageTitle'                     => 'title',
                        'pageBody'                      => 'body',
                        'pageSortIndex'                 => 'sort_index',
                        'pageStatus'                    => 'status');
        $i = 0; $saved = 0;
        foreach($values as $postName => $DBName)
        {
            if (self::updatePage($DBName,
                                  Request::post($postName),
                                  $page_id))
            {
                //echo $postName . ' = ' . Request::post($postName, true).' saved!';
                $saved++;
            }
            $i++;
        }
        if ($i == $saved)
        {
            Session::add('feedback_positive',
                            AdminText::get('FEEDBACK_PAGE_SAVED'));
        } else {
            Session::add('feedback_negative',
                            AdminText::get('FEEDBACK_PAGE_SAVING_FAILED'));
        }
    }

    public static function getEmptyPage()
    {
        $prefix = Config::get('DB_PREFIX');
        $database = DatabaseFactory::getFactory()->getConnection();

        $sql = "SELECT *
                FROM ".$prefix."pages
                WHERE title IS NULL
                  AND body IS NULL
                  AND status = 0
                LIMIT 1";

        $query = $database->prepare($sql);
        $query->execute();
        if ($query->rowCount() == 1)
        {
            $result = $query->fetch();
            $result->status = 2;
            return $result;
        } else {
            return self::createEmptyPage();
        }
    }

    public static function createEmptyPage()
    {
        $prefix = Config::get('DB_PREFIX');
        $database = DatabaseFactory::getFactory()->getConnection();

        $sql = "INSERT INTO ".$prefix."pages
                    (created)
                VALUES
                    (NOW())";
        $query = $database->prepare($sql);
        if ($query->execute())
        {
            $page               = new stdClass();
            $page->id           = $database->lastInsertId();
            $page->slug         = '';
            $page->title        = '';
            $page->body         = '';
            $page->sort_index   = '';
            $page->status       = '';
            $page->created      = '';
            $page->modified     = '';
            return $page;
        } else {
            return false;
        }
    }

    public static function updatePage($db_name,$value,$page_id)
    {
        $prefix = Config::get('DB_PREFIX');
        $database = DatabaseFactory::getFactory()->getConnection();

        $sql = "UPDATE ".$prefix."pages
                SET ".$db_name." = :value,
                    modified = NOW()
                WHERE id = :page_id
                LIMIT 1";
        $query = $database->prepare($sql);
        $query->bindParam(':value',         $value,                 PDO::PARAM_STR);
        $query->bindParam(':page_id',       $page_id,               PDO::PARAM_INT);
        if ($query->execute())
        {
            return true;
        } else {
            return false;
        }
    }
}
