<?php

/**
 * Class Auth
 * Checks if user is logged in, if not then sends the user to "yourdomain.com/login".
 * Auth::checkAuthentication() can be used in the constructor of a controller (to make the
 * entire controller only visible for logged-in users) or inside a controller-method to make only this part of the
 * application available for logged-in users.
 */
class Auth
{
    public static function checkAuthentication()
    {
        // initialize the session (if not initialized yet)
        Session::init();

        // if user is not logged in...
        if (!Session::userIsLoggedIn()) {
            // ... then treat user as "not logged in", destroy session, redirect to login page
            Session::destroy();
            if (Helper::getCurrentPath()) {
                header('location: ' . Config::getURL() . 'login?redirect='
                    .Helper::getCurrentPath());
            } else {
                header('location: ' . Config::getURL() . 'login');
            }
            exit();
        }
    }

    public static function checkForAdmin()
    {
        self::checkAuthentication();
        if (!Session::userIsAdmin()) {
            header('location: ' . Config::getURL());
            exit();
        }
    }

    public static function checkForSuperAdmin()
    {
        self::checkAuthentication();
        if (!Session::userIsSuperAdmin()) {
            header('location: ' . Config::getURL());
            exit();
        }
    }
}
