<div id="new-connection">
    <h1 class="headline">
        <?php echo AdminText::get('CONNECTION_HEADLINE'); ?>
        <a href="#new-connection">
            <div id="admin_new_button">
                <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADkAAAA5CAYAAACMGIOFAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA+JJREFUeNrsmmtIFFEUx3dXk7IUKx89sMieJlak9BILpKgoIl9IkCQ9vhgIQX4Iq099iIIwQSKwyIqIMiRK6Ev4QFGQojRIKixLSDOr1cKK1el/6ywdppl1pnWGUe6BHzuze+698597595z7qxbURTXRDe3FClFSpFSpBQpRUqRUqSd7UWAA6AH3LStVSHSRoqUP9YG1tvVrp0Cd4M3yl97AOInksh08FT51yrBpIkgciGoU7RtGJwe7yIjwR0lsH0AB8ezyMuKMXsNMq26Do+FE3cR2AwGwJCOjw94QRwoBPPG2xIyHcykieWiTg+KpWQrCAMxIMKKawm1sCc/s+Pvo/TkT9Bn1YV4bIo59Npx23ENY92Amwi2jhCniRR1JIAToAIsDrK+yWAPqAIZFO8GZf/7TIqGU0AWSAfLQRgoA/1BXpOYiTvBdpANukEzqAZ14L2Vs2sCyAZXwVuKVrgNgdU6Zct1ZtcnIE3DX8zK51W+I+ATqAEFYJkVwcAF4AuwoAvRN0CyRtlSnTKtIFXlOw0cAq8CtCUEv7NC5FLQayB68VI8GsvKzgbXVX7dYB/z8YBNoN5AGz4aHZaEdafAD4Oh2mO6aH/ZcDYERS9tY7+JICAFJIE4EM1YBHaCS2CAerELzLFKZBR4SQ0ZsS8UfHtYj54EeSrxZkbTLVBidYC+H3xTjJu4IcUgRKOuUHa8BVSAdtAD+uiG3qM2ecgXZkcW0mqiN/2T0lFVHX7RieC+gTo6aHfBtlRrFw1Fhe7yNQO9W0PPl4sN342UT5qxYjvzyRbKIubSeaZqD0e9hu5VlV9CQ1LrOa4lHunUl2+XyB0gC0xl34nZsVlnLyeG+blpI0vLGpjfCh2fj1bOrkaYDxpVa1oeEyc+MwIMx0ZWV0oAP8N7Q1akOV3gCHhG57WgjY6n0Gf+KAG63wJlI7lWB+ijWSuoBGdBPXjO0ihha5ivl90QYe3sWGydNLHzSJBMxzOcsP0hguzbIJcNY/9ax2fUWhN1rmXl+p2wkSVSrhJKj4QlsfyVD8MRE3X67MwnjdoLdrwStLAh6h9uUSCV+X0FHXQcTrnq70EHVql2EBz1wieEspAFdF4TYNZsYuVSA/j1OmG4cpsFokEinVeNQZ0NTtuti6VhmcNEdur4Dqu2QjQHIDjnNJHxJDSHNr0GaS3VMnEz0sAGsE7Hp4z2fRz1TBaCQXqW7rLvixXzVm1XqmWWY6qNrzPstwLKH42ka6VmBVr9msClWgu99HgM0/8GxKuB4+AKeAgOg0yaoFyqVwxikikHjfLfH1KkFClFSpFSpBQpRUqRWvZLgAEAsKx0VA6gwfEAAAAASUVORK5CYII=">
            </div>
        </a>
    </h1>
    <div id="admin_connection_new" class="transition">
        <form action="<?php echo PA::getURL(); ?>admin/connections_add" method="post">
            <label for="admin_new_connection_input" class="form_label">
                <span><?php echo AdminText::get('CONNECTION_LABEL'); ?></span>
            </label>
            <div id="admin_new_connection_box">
                <input type="text"
                       placeholder="http://someexamplecluster.com"
                       id="admin_new_connection_input"
                       name="url"
                       class="form_element">
                <input type="submit" value="<?php echo AdminText::get('CONNECTION_CONNECT'); ?>" id="admin_new_connection_send" class="form_element">
            </div>
            <p><?php echo AdminText::get('CONNECTION_EXPLAIN'); ?></p>
        </form>
    </div>
</div>

<?php
$status = array(0,0,0,0);

$number_connections = count($data['connections']);

if ($number_connections == 0)
{
    echo '<div class="feedback error">'.AdminText::get('CONNECTION_NO_CONNECTION_YET').'</div>';
}

foreach($data['connections'] as $connection) {
    switch ($connection->status) {
        case 0:
            $class_status = 'status_red';
            $button_status = array(' checked disabled',
                                   ' disabled',
                                   ' disabled');
            break;
        case 1:
            $class_status = 'status_red';
            $button_status = array(' checked disabled',
                                   ' disabled',
                                   ' disabled');
            break;
        case 2:
            $class_status = 'status_yellow';
            $button_status = array(' disabled',
                                   ' checked',
                                   '');
            break;
        case 3:
            $class_status = 'status_green';
            $button_status = array(' disabled',
                                   '',
                                   ' checked');
            break;
    }
    $status[$connection->status]++;
    if ($status[$connection->status] == 1) {
        echo '<h2 class="headline">
                '.AdminText::get('CONNECTION_STATUS_'.$connection->status).'
              </h2>';
    }
    ?>
    <div class="admin_connection_box transition">
        <div class="admin_connection_head">
            <div class="admin_connection_logo">
                <img src="<?php echo $connection->url; ?>data/platform/logo.png">
            </div>
            <div class="admin_connection_detail">
                <div class="admin_connection_name">
                    <span class="<?php echo $class_status; ?> admin_connection_status_bull">&bull;</span>
                    <?php echo $connection->name; ?>
                    <div class="admin_connection_url">
                        &raquo; <a href="<?php echo $connection->url; ?>" target="_blank">
                            <?php echo $connection->url; ?>
                        </a>
                    </div>
                </div>
                <div class="admin_connection_location">
                    <?php echo $connection->location; ?>
                </div>
                <div class="admin_connection_since">
                    <?php echo AdminText::get('CONNECTION_ENQUIRED').' '.$connection->created; ?>
                </div>
                <?php
                switch ($connection->status) {
                    case 0:
                        echo AdminText::get('CONNECTION_NOT_CONNECTED_YET');
                        break;
                    case 2:
                    case 3:
                        echo '
                        <div class="admin_connection_connected">
                            '.AdminText::get('CONNECTION_CONNECTED_SINCE').' '.$connection->connected.'
                        </div>';
                        break;
                }
                ?>
            </div>
            <?php
                switch ($connection->status)
                {
                    case 0:
                        echo '
                        <div class="admin_connection_confirm">
                            <a href="'.PA::getURL().'admin/connection_confirm/'.$connection->uuid.'">
                                '.AdminText::get('CONNECTION_CONFIRM_CONNECTION').'
                            </a>
                        </div>';
                        break;
                    case 2:
                    case 3:
                        break;
                }
                ?>
            <div class="admin_connection_goto transition"></div>
        </div>
        <form action="<?php echo PA::getURL().'admin/connection_edit/'.$connection->id; ?>"
              name="connection_settings"
              method="post">
            <div class="admin_connection_body">
                <div class="admin_connection_settings">
                    <h4><?php echo AdminText::get('CONNECTION_STATUS_HEADLINE'); ?></h4>
                    <input type="radio"
                           id="status_initialised_<?php echo $connection->id; ?>"
                           name="connection_status_<?php echo $connection->id; ?>"<?php
                           echo $button_status[0]; ?> />
                    <label for="status_initialised" class="status_red">
                        <?php echo AdminText::get('CONNECTION_STATUS_RED'); ?>
                    </label>
                    <input type="radio"
                           id="status_paused_<?php echo $connection->id; ?>"
                           name="connection_status_<?php echo $connection->id; ?>"
                           value="2"<?php echo $button_status[1]; ?> />
                    <label for="status_paused" class="status_yellow">
                        <?php echo AdminText::get('CONNECTION_STATUS_YELLOW'); ?>
                    </label>
                    <input type="radio"
                           id="status_active_<?php echo $connection->id; ?>"
                           name="connection_status_<?php echo $connection->id; ?>"
                           value="3"<?php echo $button_status[2]; ?> />
                    <label for="status_active" class="status_green">
                        <?php echo AdminText::get('CONNECTION_STATUS_GREEN'); ?>
                    </label>
                    <a href="<?php echo PA::getURL().'admin/connection_delete/'.$connection->id; ?>" class="delete_button">
                        <div class="connection_delete">
                            <?php echo AdminText::get('CONNECTION_DELETE_CONNECTION'); ?>
                        </div>
                    </a>
                </div>
                <div class="admin_connection_send_offer">
                    <h4>
                        <?php echo AdminText::get('CONNECTION_CATEGORIES_SEND'); ?>
                    </h4>
                    <div class="admin_connection_groups_box">
                        <?php
                        $send_array = explode(',',$connection->send);
                        Admin::adminShowCategories('checkbox',
                                                   'send_'.$connection->id,
                                                   $send_array);
                        ?>
                    </div>
                </div>
                <div class="admin_connection_get_offer">
                    <h4>
                        <?php echo AdminText::get('CONNECTION_CATEGORIES_RECEIVE'); ?>
                    </h4>
                    <div class="admin_connection_groups_box">
                        <?php
                        $receive_array = explode(',',$connection->receive);
                        Admin::adminShowCategories('checkbox',
                                                   'receive_'.$connection->id,
                                                   $receive_array);
                        ?>
                    </div>
                </div>
                <div class="clear"></div>

                <input type="submit" value="<?php echo AdminText::get('CONNECTION_SAVE'); ?>" class="admin_connection_submit">
            </div>
        </form>
    </div>
<?php
}
PA::showFooter();
?>
