<?php

/**
 * Session class
 *
 * handles the session stuff. creates session when no one exists, sets and gets values, and closes the session
 * properly (=logout). Not to forget the check if the user is logged in or not.
 */
class Session
{
    /**
     * starts the session
     */
    public static function init()
    {
        // if no session exist, start the session
        if (session_id() == '') {
            session_set_cookie_params(0,
                                      Config::get('COOKIE_PATH'),
                                      Config::get('COOKIE_DOMAIN'),
                                      Config::get('COOKIE_SECURE'),
                                      Config::get('COOKIE_HTTP'));
            session_start();
        }
    }

    /**
     * sets a specific value to a specific key of the session
     *
     * @param mixed $key key
     * @param mixed $value value
     */
    public static function set($key, $value)
    {
        $_SESSION[$key] = $value;
    }

    /**
     * unsets a specific key of the session
     *
     * @param mixed $key key
     */
    public static function remove($key)
    {
        unset($_SESSION[$key]);
    }

    /**
     * gets/returns the value of a specific key of the session
     *
     * @param mixed $key Usually a string, right ?
     * @return mixed the key's value or nothing
     */
    public static function get($key)
    {
        if (isset($_SESSION[$key]))
        {
            return $_SESSION[$key];
        }
    }

    /**
     * adds a value as a new array element to the key.
     * useful for collecting error messages etc
     *
     * @param mixed $key
     * @param mixed $value
     */
    public static function add($key, $value)
    {
        $_SESSION[$key][] = $value;
    }

    /**
     * deletes the session (= logs the user out)
     */
    public static function destroy()
    {
        session_destroy();
    }

    /**
     * Checks if the user is logged in or not
     *
     * @return bool user's login status
     */
    public static function userIsLoggedIn()
    {
        return (Session::get('user_logged_in') ? true : false);
    }

    /**
     * Checks if the user is Admin or not
     *
     * @return bool user's admin status
     */
    public static function userIsAdmin()
    {
        return (in_array(Session::get('user_account_type'),array(1,2)) ? true : false);
    }

    /**
     * Checks if the user is SuperAdmin or not
     *
     * @return bool user's SuperAdmin status
     */
    public static function userIsSuperAdmin()
    {
        return (Session::get('user_account_type') == 2 ? true : false);
    }
}
