<?php

class UsersController extends Controller
{
    /**
     * Construct this object by extending the basic Controller class
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     */
    public function changePassword($user_id = NULL)
    {
        Auth::checkAuthentication();
        if ($user_id === NULL) {
            $user_id = Session::get('user_id');
        }
        if (UserModel::checkOwnership($user_id)) {
            $this->View->renderAdmin('changeUserPassword', array(
                'userID' => $user_id
            ));
        }
    }

    public function changePassword_action($user_id = NULL)
    {
        Auth::checkAuthentication();
        if ($user_id === NULL) {
            $user_id = Session::get('user_id');
        }
        if (UserModel::checkOwnership($user_id)) {
            UserModel::changePassword($user_id,
                                      Request::post('user_password_new'),
                                      Request::post('user_password_repeat'));
        }
    }
}
