<?php
$offer = $data['offer'];
$contactdata = $data['profile'];
?>

<div id="start_content">
    <div id="offer_box" class="right twothird">
        <?php
        $offerImage = explode(':', $offer->image);
        PA::ShowEditMenu($data);
        ?>
        <h1 class="headline"><?php echo $offer->title; ?></h1>

        <?php
        if ($offer->image) {
            echo '
            <div id="offer_image" style="background-image:';
            echo "url('"; echo PA::getPictureURL($offer->image,'medium','offer'); echo"');";
            echo '">';
            if ($offer->admin_featured) {
                echo '
                <div class="offer_featured"></div>';
            }
            echo '
            </div>';
        }
        if (isset($offer->detail) && $offer->detail != '') {
            ?>
            <div id="offer_about">
                <div class="offer_label">
                    <?php
                    if ($offer->type == 1) {
                        echo Text::get('OFFER_OFFER').':';
                    } elseif ($offer->type == 2) {
                        echo Text::get('OFFER_REQUEST').':';
                    }
                    ?>
                </div>
                <p>
                    <?php
                    if (!$offer->detail) {
                        echo Text::get('OFFER_NO_DETAIL');
                    } else {
                        echo $offer->detail;
                    }
                    ?>
                </p>
                <div id="offer_dates">
                   <?php PA::showOfferDates($offer->created,$offer->modified); ?>
                </div>
            </div>
            <?php
        }
        if (isset($offer->price) && $offer->price != '') {
            $offer_price = Helper::convertPrice($offer->price,
                                                $offer->currency,
                                                $offer->unit,
                                                'long');
            ?>

            <div id="offer_price">
                <div class="offer_label">
                <?php echo Text::get('OFFER_PRICE').':';?>
                </div>
                <?php echo $offer_price['price'].$offer_price['currency'].$offer_price['unit']; ?>
            </div>

            <?php
            $distance = PA::getDistance($offer->zipcode);
            PA::showDistanceBox($distance);
            ?>
            <div id="offer_tags">
                <div class="offer_label">
                <?php echo Text::get('OFFER_CATEGORY').':'; ?>
                </div>

                <?php
                $category1 = Text::get('CATEGORY1');
                $category2 = Text::get('CATEGORY2');

                if ($offer->category1) { echo $category1[$offer->category1].', '; }
                if ($offer->category2) { echo $category2[$offer->category2][0]; }
                ?>

            </div>
            <?php
        }
        if (isset($offer->tags) && $offer->tags !='') {
            $tags = explode(',',$offer->tags);

            if (count($tags) > 0) {
                ?>
                <div id="offer_tags">
                    <div class="offer_label">
                    <?php echo Text::get('OFFER_TAGS').':';?>
                    </div>
                    <?php
                    foreach ($tags as $tag) {
                        echo '<a href="'.PA::getURL().'search/q/'.urlencode(strtolower(trim($tag))).'">'.trim($tag).'</a> ';
                    }
                    ?>
                </div>
                <?php
            }
        }
        ?>
    </div>
    <div id="protagonist_box" class="left onethird">
        <?php
        if (PA::isExternalOffer($offer) === true) {
            PA::showExternalPlatform($offer->external_platform_id);
        } else {
            PA::showUserContact($contactdata);
            PA::showUserOpeningHours($contactdata);
            PA::showUserMore($contactdata);
        }
        ?>
    </div>
    <div class="clear"></div>
</div>
<?php
PA::showFooter();
?>
