<?php

/**
 * Class DatabaseArgs
 */
class DatabaseArgs
{
    private static $pageNumber      = 1;
    private static $howMany         = 12;
    private static $orderBy         = 'modified DESC';
    private static $userFeatured    = false;
    private static $adminFeatured   = false;
    private static $active          = true;
    private static $type            = 1;
    private static $user_id         = '';

    public static function setArgs($args)
    {
        foreach($args as $key => $value)
        {
            switch($key)
            {
                case 'page':
                    if (self::$pageNumber == 1)
                    {
                        self::setPageNumber($value);
                    }
                    break;
                case 'howMany':
                    self::setHowMany($value);
                    break;
                case 'orderBy':
                    self::setOrderBy($value);
                    break;
                case 'active':
                    self::setActive($value);
                    break;
                case 'userFeatured':
                    self::setUserFeatured($value);
                    break;
                case 'adminFeatured':
                    self::setAdminFeatured($value);
                    echo 'feature an<br>';
                    break;
                case 'user_id':
                    self::setUserId($value);
                    break;
                case 'type':
                    self::setType($value);
                    break;
            }
            //echo $key.' updated<br>';
        }
    }

    public static function resetArgs()
    {
        self::setHowMany(12);
        self::setOrderBy(array('modified','DESC'));
        self::setActive(true);
        self::setUserFeatured(false);
        self::setAdminFeatured(false);
        self::setUserId('');
        self::setType(1);
        echo 'reset';
    }

    public static function setActive($active)
    {
        if (in_array($active,array(true,false)))
        {
            self::$active = $active;
            return true;
        } else {
            return false;
        }
    }

    public static function setUserFeatured($featured)
    {
        if (in_array($featured,array('true','false')))
        {
            self::$userFeatured = $featured;
        }
    }

    public static function setAdminFeatured($featured)
    {
        if (in_array($featured,array('true','false')))
        {
            self::$adminFeatured = $featured;
        }
    }

    public static function setPageNumber($page)
    {
        self::$pageNumber = (int) $page;
    }

    public static function setHowMany($howMany)
    {
        self::$howMany = (int) $howMany;
    }

    public static function setOrderBy($orderBy)
    {
        if ($orderBy == 'random')
        {
            $orderBy = 'rand()';
        }
        elseif (in_array($orderBy[0], array('created','modified','company_name','id','price')) &&
                in_array($orderBy[1], array('ASC','DESC')))
        {
            $orderBy = $orderBy[0].' '.$orderBy[1];
        }
        else
        {
            $orderBy = 'modified DESC';
        }
        self::$orderBy = $orderBy;
    }

    public static function setType($typeName)
    {
        switch ($typeName)
        {
            case 1:
            case 'offer':
                $type = 1;
                break;
            case 2:
            case 'search':
                $type = 2;
                break;
            case false:
                $type = false;
                break;
        }
        self::$type = $type;
    }

    public static function setUserId($user_id)
    {
        self::$user_id = (int) $user_id;
    }

    public static function getPageNumber()
    {
        return self::$pageNumber;
    }

    public static function getHowMany()
    {
        return self::$howMany;
    }

    public static function getOrderBy()
    {
        return self::$orderBy;
    }

    public static function getStart()
    {
        return (self::getPageNumber()-1) * self::getHowMany();
    }

    public static function getWhereStmt()
    {
        if (self::$active == true)
        {
            $where = 'WHERE status > 1';
        } else {
            $where = 'WHERE status > 0';
        }
        if (self::$userFeatured == true)
        {
            $where .= ' AND user_featured = 1';
        }
        if (self::$adminFeatured == true)
        {
            $where .= ' AND admin_featured = 1';
        }
        if (self::$type != false)
        {
            $where .= ' AND type = '.self::$type;
        }
        if (self::$user_id != '')
        {
            $where .= ' AND user_id = '.self::$user_id;
        }
        return $where;
    }
}
